/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.utils;

import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.HDLogger;
import com.inet.lib.util.IOFunctions;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.image.ImageScaler;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.SuppressFBWarnings;

public class TicketValuesImageResolver {
    public static final TicketValuesImageResolver INSTANCE = new TicketValuesImageResolver();

    private TicketValuesImageResolver() {
    }

    public static TicketValuesImageResolver getInstance() {
        return INSTANCE;
    }

    public List<Integer> getAvailableSizes(String relativePath) {
        try {
            PersistenceEntry entryFolder = AppDataLocation.getImageDirectory().resolve(relativePath);
            if (!entryFolder.exists()) {
                return Collections.emptyList();
            }
            return entryFolder.walk("*.png").map(e -> e.getName().substring(0, e.getName().length() - 4)).map(n -> Integer.valueOf(n)).sorted().collect(Collectors.toList());
        }
        catch (IllegalArgumentException iae) {
            HDLogger.debug(iae);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL resolveDataImage(String relativePath, int targetSize) {
        try {
            PersistenceEntry entryFolder = AppDataLocation.getImageDirectory().resolve(relativePath);
            if (!entryFolder.exists()) {
                return null;
            }
            PersistenceEntry entry = entryFolder.resolve(targetSize + ".png");
            if (entry.exists()) {
                try (InputStream in = entry.getInputStream();){
                    URL uRL = new URL("data:image/png;base64," + Base64.getEncoder().encodeToString(IOFunctions.readBytes((InputStream)in)));
                    return uRL;
                }
                catch (Throwable t) {
                    HDLogger.error(t);
                }
            }
            List availableSizes = entryFolder.walk("*.png").map(e -> e.getName().substring(0, e.getName().length() - 4)).map(n -> Integer.valueOf(n)).sorted().collect(Collectors.toList());
            Integer sourceSize = null;
            Optional<Integer> firstMultiple = availableSizes.stream().filter(s -> {
                double divLogTwo;
                double modTargetSize = s.doubleValue() % (double)targetSize;
                return modTargetSize == 0.0 && (divLogTwo = Math.log(s.doubleValue() / (double)targetSize) / Math.log(2.0)) == (double)((int)divLogTwo);
            }).findFirst();
            if (firstMultiple.isPresent()) {
                sourceSize = firstMultiple.get();
            }
            if (sourceSize == null && (firstMultiple = availableSizes.stream().filter(s -> {
                double modTargetSize = s.doubleValue() % (double)targetSize;
                return modTargetSize == 0.0;
            }).findFirst()).isPresent()) {
                sourceSize = firstMultiple.get();
            }
            if (sourceSize == null && (firstMultiple = availableSizes.stream().filter(s -> s >= targetSize).findFirst()).isPresent()) {
                sourceSize = firstMultiple.get();
            }
            if (sourceSize == null && (firstMultiple = availableSizes.stream().sorted((a, b) -> b.compareTo((Integer)a)).filter(s -> s < targetSize).findFirst()).isPresent()) {
                sourceSize = firstMultiple.get();
            }
            if (sourceSize == null) return null;
            PersistenceEntry sourceEntry = entryFolder.resolve(sourceSize + ".png");
            try (InputStream inputStream = sourceEntry.getInputStream();){
                ImageScaler.ImageScalerResult result = ImageScaler.scale((InputStream)inputStream, (int)targetSize);
                URL uRL = new URL("data:image/png;base64," + Base64.getEncoder().encodeToString(result.getImageData()) + (result.isScaled() ? "#scaled" : ""));
                return uRL;
            }
            catch (Throwable t) {
                HDLogger.error(t);
                return null;
            }
        }
        catch (IllegalArgumentException iae) {
            HDLogger.debug(iae);
        }
        return null;
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Valid image data will be stored in a defined local folder. The relative path is provided by code. No user input available here.")
    public void storeIcon(String relativePath, String base64ImageData, int size) {
        try {
            URL iconUrl = new URL(base64ImageData);
            PersistenceEntry entryFolder = AppDataLocation.getImageDirectory().resolve(relativePath);
            PersistenceEntry imageFile = entryFolder.resolve(size + ".png");
            try (InputStream in = iconUrl.openStream();
                 OutputStream out = imageFile.getOutputStream();){
                IOFunctions.copyData((InputStream)in, (OutputStream)out);
            }
        }
        catch (Throwable t) {
            HDLogger.error(t);
        }
    }

    public void removeIcon(String relativePath, int size) {
        PersistenceEntry entryFolder = AppDataLocation.getImageDirectory().resolve(relativePath);
        PersistenceEntry imageFile = entryFolder.resolve(size + ".png");
        imageFile.deleteValue();
    }
}

