/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.utils;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.utils.SecurityUtils;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MailEncodingUtilities {
    private static byte[] convert_array;
    private static final char[] BASE64;
    private static final Charset UTF8;
    private static final Pattern ENCODING_PATTERN;

    public static String tryEncoding(String instring, boolean isSubject, boolean rekusiveraufruf) {
        if (instring == null) {
            return "";
        }
        Object returnString = instring;
        try {
            int pos2;
            String lowString = instring.toLowerCase().trim();
            int pos1 = lowString.indexOf("=?iso-8859-1?q?");
            if (pos1 > -1 || (pos1 = lowString.indexOf("=?iso-8859-2?q?")) > -1) {
                pos2 = lowString.indexOf("?=", pos1 + 15);
                returnString = pos2 > -1 ? MailEncodingUtilities.tryEncoding(instring.substring(0, pos1) + MailEncodingUtilities.replaceISOcodes(instring.substring(pos1 + 15, pos2), false) + instring.substring(pos2 + 2), isSubject, true) : instring.substring(0, pos1) + instring.substring(pos1 + 15);
            } else {
                pos1 = lowString.indexOf("=?iso-8859-15?q?");
                if (pos1 > -1) {
                    pos2 = lowString.indexOf("?=", pos1 + 16);
                    returnString = pos2 > -1 ? MailEncodingUtilities.tryEncoding(instring.substring(0, pos1) + MailEncodingUtilities.replaceISOcodes(instring.substring(pos1 + 16, pos2), false) + instring.substring(pos2 + 2), isSubject, true) : instring.substring(0, pos1) + instring.substring(pos1 + 16);
                } else {
                    pos1 = lowString.indexOf("=?windows-1252?q?");
                    if (pos1 > -1) {
                        pos2 = lowString.indexOf("?=", pos1 + 17);
                        returnString = pos2 > -1 ? MailEncodingUtilities.tryEncoding(instring.substring(0, pos1) + MailEncodingUtilities.replaceISOcodes(instring.substring(pos1 + 17, pos2), true) + instring.substring(pos2 + 2), isSubject, true) : instring.substring(0, pos1) + instring.substring(pos1 + 17);
                    } else {
                        pos1 = lowString.indexOf("=?windows-1255?q?");
                        if (pos1 > -1) {
                            pos2 = lowString.indexOf("?=", pos1 + 17);
                            returnString = pos2 > -1 ? MailEncodingUtilities.tryEncoding(instring.substring(0, pos1) + MailEncodingUtilities.replaceISOcodes(instring.substring(pos1 + 17, pos2), false) + instring.substring(pos2 + 2), isSubject, true) : instring.substring(0, pos1) + instring.substring(pos1 + 17);
                        } else {
                            pos1 = lowString.indexOf("=?windows-1256?b?");
                            if (pos1 > -1) {
                                pos2 = lowString.indexOf("?=", pos1 + 17);
                                returnString = pos2 > -1 ? MailEncodingUtilities.tryEncoding(instring.substring(0, pos1) + SecurityUtils.decodeBase64(instring.substring(pos1 + 17, pos2)) + instring.substring(pos2 + 2), isSubject, true) : instring.substring(0, pos1) + instring.substring(pos1 + 17);
                            } else {
                                pos1 = lowString.indexOf("-8859-1?b?");
                                if (pos1 > -1) {
                                    pos2 = lowString.indexOf("?=", pos1 + 10);
                                    if (pos2 > -1) {
                                        returnString = lowString.indexOf("=?") > 0 ? instring.substring(0, lowString.indexOf("=?")) : "";
                                        returnString = MailEncodingUtilities.tryEncoding((String)returnString + new String(SecurityUtils.decodeBase64(instring.substring(pos1 + 10, pos2).getBytes(UTF8)), UTF8) + instring.substring(pos2 + 2), isSubject, true);
                                    }
                                } else {
                                    pos1 = lowString.indexOf("-8859-15?b?");
                                    if (pos1 > -1) {
                                        pos2 = lowString.indexOf("?=", pos1 + 11);
                                        if (pos2 > -1) {
                                            returnString = lowString.indexOf("=?") > 0 ? instring.substring(0, lowString.indexOf("=?")) : "";
                                            returnString = MailEncodingUtilities.tryEncoding((String)returnString + new String(SecurityUtils.decodeBase64(instring.substring(pos1 + 11, pos2).getBytes(UTF8)), UTF8) + instring.substring(pos2 + 2), isSubject, true);
                                        }
                                    } else if (lowString.indexOf("utf-7?q?") > -1) {
                                        pos1 = lowString.indexOf("=?unicode-1-1-utf-7?q?");
                                        if (pos1 > -1 && (pos2 = lowString.indexOf("?=", pos1 + 20)) > -1) {
                                            returnString = MailEncodingUtilities.tryEncoding(instring.substring(0, pos1) + MailEncodingUtilities.replaceUTF7codes(instring.substring(pos1 + 22, pos2), isSubject) + instring.substring(pos2 + 2), isSubject, true);
                                        } else {
                                            pos1 = lowString.indexOf("=?utf-7?q?");
                                            if (pos1 > -1 && (pos2 = lowString.indexOf("?=", pos1 + 20)) > -1) {
                                                returnString = MailEncodingUtilities.tryEncoding(instring.substring(0, pos1) + MailEncodingUtilities.replaceUTF7codes(instring.substring(pos1 + 10, pos2), isSubject) + instring.substring(pos2 + 2), isSubject, true);
                                            } else {
                                                pos1 = lowString.indexOf("=?utf-7?b?q");
                                                if (pos1 > -1 && (pos2 = lowString.indexOf("?=", pos1 + 20)) > -1) {
                                                    returnString = MailEncodingUtilities.tryEncoding(instring.substring(0, pos1) + MailEncodingUtilities.replaceUTF7codes(instring.substring(pos1 + 11, pos2), isSubject) + instring.substring(pos2 + 2), isSubject, true);
                                                }
                                            }
                                        }
                                    } else {
                                        pos1 = lowString.indexOf("=?utf-7?b?");
                                        if (pos1 > -1) {
                                            pos2 = lowString.indexOf("?=", pos1 + 10);
                                            if (pos2 > -1) {
                                                returnString = MailEncodingUtilities.replaceUTF7codes(new String(SecurityUtils.decodeBase64(instring.substring(pos1 + 10, pos2).getBytes(UTF8)), UTF8), isSubject);
                                            }
                                        } else {
                                            pos1 = lowString.indexOf("=?utf-8?b?");
                                            if (pos1 > -1) {
                                                pos2 = lowString.indexOf("?=", pos1 + 10);
                                                if (pos2 > -1) {
                                                    returnString = MailEncodingUtilities.tryEncoding(instring.substring(0, pos1) + new String(SecurityUtils.decodeBase64(instring.substring(pos1 + 10, pos2).getBytes(UTF8)), UTF8) + instring.substring(pos2 + 2), isSubject, true);
                                                }
                                            } else {
                                                pos1 = lowString.indexOf("=?utf-8?q?");
                                                if (pos1 > -1) {
                                                    pos2 = lowString.indexOf("?=", pos1 + 10);
                                                    returnString = pos2 > -1 ? MailEncodingUtilities.tryEncoding(instring.substring(0, pos1) + MailEncodingUtilities.replaceISOcodes(instring.substring(pos1 + 10, pos2), true) + instring.substring(pos2 + 2), isSubject, true) : instring.substring(0, pos1) + instring.substring(pos1 + 10);
                                                } else {
                                                    int end;
                                                    Matcher m = ENCODING_PATTERN.matcher(lowString);
                                                    if (m.find() && (end = lowString.indexOf("?=", m.end())) > -1) {
                                                        String start = instring.substring(0, m.start());
                                                        String content = instring.substring(m.end(), end);
                                                        if (lowString.charAt(m.end() - 2) == 'b') {
                                                            content = new String(SecurityUtils.decodeBase64(content.getBytes(UTF8)), UTF8);
                                                        } else if (lowString.charAt(m.end() - 2) == 'q') {
                                                            content = MailEncodingUtilities.replaceISOcodes(content, true);
                                                        }
                                                        String rest = instring.substring(end + 2);
                                                        returnString = MailEncodingUtilities.tryEncoding(start + content + rest, isSubject, true);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable er) {
            HDLogger.error(er);
        }
        if (!rekusiveraufruf) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < ((String)returnString).length(); ++i) {
                if (((String)returnString).charAt(i) == '\u00c3') {
                    if (i < ((String)returnString).length() - 1) {
                        buf.append((char)(((String)returnString).charAt(i + 1) + 64));
                    }
                    ++i;
                    continue;
                }
                if (((String)returnString).charAt(i) <= '\u001f') continue;
                buf.append(((String)returnString).charAt(i));
            }
            returnString = buf.toString();
        }
        return returnString;
    }

    public static String replaceUTF7codes(String codeString, boolean isSubject) {
        int pos = codeString.indexOf(43);
        if (pos == -1) {
            return codeString;
        }
        StringBuffer outString = new StringBuffer();
        int start = 0;
        while (pos > -1 && pos < codeString.length() - 4) {
            String subString = codeString.substring(start, pos);
            if (isSubject && subString.indexOf(95) > -1) {
                subString = subString.replace('_', ' ');
            }
            outString.append(subString);
            if (codeString.charAt(pos + 4) == '-') {
                byte ch1 = convert_array[(byte)codeString.charAt(pos + 1)];
                byte ch2 = convert_array[(byte)codeString.charAt(pos + 2)];
                byte ch3 = convert_array[(byte)codeString.charAt(pos + 3)];
                char resChar = (char)((ch1 << 10) + (ch2 << 4) + (ch3 >> 2));
                outString.append(resChar);
                start = pos + 5;
            } else {
                outString.append('+');
                start = pos + 1;
            }
            pos = codeString.indexOf(43, start);
        }
        outString.append(codeString.substring(start));
        return outString.toString();
    }

    private static String replaceISOcodes(String codeString, boolean useUrlDecoder) {
        int pos = codeString.indexOf(61);
        if (pos == -1) {
            return codeString;
        }
        if (useUrlDecoder) {
            try {
                String bla = codeString.replace('=', '%');
                return URLDecoder.decode(bla, "UTF-8");
            }
            catch (Exception bla) {
                // empty catch block
            }
        }
        StringBuffer outString = new StringBuffer();
        int start = 0;
        while (pos > -1 && pos < codeString.length() - 2) {
            outString.append(codeString.substring(start, pos));
            String str = codeString.substring(pos + 1, pos + 3);
            outString.append((char)Integer.parseInt(str, 16));
            start = pos + 3;
            pos = codeString.indexOf(61, start);
        }
        outString.append(codeString.substring(start));
        return outString.toString();
    }

    public static String decodeUTF7(byte[] src, boolean html) {
        StringBuffer text = new StringBuffer();
        boolean headerFinished = false;
        boolean lastUmbruch = false;
        for (int i = 0; i < src.length - 4; ++i) {
            if (src[i] != 13 && headerFinished) {
                if (src[i] == 43 && src[i + 1] == 45) {
                    text.append('+');
                    continue;
                }
                if (src[i] == 43 && src[i + 4] == 45) {
                    byte ch1 = convert_array[src[i + 1]];
                    byte ch2 = convert_array[src[i + 2]];
                    byte ch3 = convert_array[src[i + 3]];
                    char resChar = (char)((ch1 << 10) + (ch2 << 4) + (ch3 >> 2));
                    text.append(resChar);
                    i += 4;
                    continue;
                }
                text.append((char)src[i]);
                continue;
            }
            if (headerFinished || src[i] == 13) continue;
            if (lastUmbruch) {
                headerFinished = true;
                continue;
            }
            lastUmbruch = src[i] == 10;
        }
        if (src.length > 3) {
            text.append((char)src[src.length - 4]);
        }
        if (src.length > 2) {
            text.append((char)src[src.length - 3]);
        }
        if (src.length > 1) {
            text.append((char)src[src.length - 2]);
        }
        if (src.length > 0) {
            text.append((char)src[src.length - 1]);
        }
        String result = text.toString();
        if (html) {
            int end;
            int begin = result.indexOf("<html>");
            if (begin == -1) {
                begin = result.indexOf("<HTML>");
            }
            if (begin > 0) {
                result = result.substring(begin);
            }
            if ((end = result.indexOf("</html>")) == -1) {
                end = result.indexOf("</HTML>");
            }
            result = result.substring(0, end + 7);
        } else {
            int cut;
            while ((result.startsWith("charset=") || result.startsWith("Content-")) && (cut = result.indexOf(10)) > -1 && cut < result.length() - 1) {
                result = result.substring(cut + 1);
            }
        }
        return result;
    }

    static {
        int i;
        convert_array = new byte[256];
        BASE64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        UTF8 = StandardCharsets.UTF_8;
        ENCODING_PATTERN = Pattern.compile("=\\?[0-9a-z_\\-]*\\?[a-z]\\?");
        for (i = 0; i < 255; ++i) {
            MailEncodingUtilities.convert_array[i] = -1;
        }
        for (i = 0; i < BASE64.length; ++i) {
            MailEncodingUtilities.convert_array[MailEncodingUtilities.BASE64[i]] = (byte)i;
        }
    }
}

