/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.ui.model;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldSortedIteratorDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import java.net.URL;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class TicketFieldDefinition {
    private FIELD_GROUPING grouping;
    private String key;
    private boolean supportsText;
    private boolean supportsIcon;

    protected TicketFieldDefinition(TicketField<?> field, boolean supportsText, boolean supportsIcon) {
        this(FIELD_GROUPING.TICKET, field.getKey(), supportsText, supportsIcon);
    }

    protected TicketFieldDefinition(TicketAttribute<?> attribute, boolean supportsText, boolean supportsIcon) {
        this(FIELD_GROUPING.TICKET, attribute.getKey(), supportsText, supportsIcon);
    }

    protected TicketFieldDefinition(FIELD_GROUPING grouping, TicketField<?> field, boolean supportsText, boolean supportsIcon) {
        this(grouping, field.getKey(), supportsText, supportsIcon);
    }

    protected TicketFieldDefinition(FIELD_GROUPING grouping, TicketAttribute<?> attribute, boolean supportsText, boolean supportsIcon) {
        this(grouping, attribute.getKey(), supportsText, supportsIcon);
    }

    protected TicketFieldDefinition(FIELD_GROUPING grouping, String key, boolean supportsText, boolean supportsIcon) {
        this.grouping = grouping;
        this.key = key;
        this.supportsText = supportsText;
        this.supportsIcon = supportsIcon;
    }

    public FIELD_GROUPING getGrouping() {
        return this.grouping;
    }

    public String getKey() {
        return this.key;
    }

    public boolean supportsText() {
        return this.supportsText;
    }

    public boolean supportsIcon() {
        return this.supportsIcon;
    }

    public String getDisplayName() {
        return Tickets.getFieldDisplayName(this.getKey());
    }

    public URL getColumnIcon(Integer iconSize) {
        return null;
    }

    public URL getIconForValue(String valueAsString, int size) {
        return null;
    }

    public String getValueAsStringForIcon(@Nonnull TicketVO ticket) {
        return null;
    }

    public abstract String getDisplayValue(@Nonnull TicketVO var1);

    public SortGroupInformation getSortGroupInformation() {
        return SortGroupInformation.noSortGroups;
    }

    @Nullable
    public FieldEditDefinition getEditDefinition() {
        return null;
    }

    @Nonnull
    public Comparator<TicketVO> getComparator() {
        Comparator comp = Comparator.naturalOrder();
        Comparator nullsFirst = Comparator.nullsFirst(comp);
        return (a, b) -> nullsFirst.compare(a.getForKey(this.key), b.getForKey(this.key));
    }

    @Nullable
    public FieldSortedIteratorDefinition getSortedDefinition() {
        return null;
    }

    public static enum FIELD_GROUPING {
        TICKET,
        TICKET_OWNER;


        public String getDisplayName() {
            return Tickets.MSG.getMsg("ticketlist.columns.grouping." + this.name(), new Object[0]);
        }
    }
}

