/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.BasicFieldValidation;

public class TicketFieldTargetTime
extends TicketField<Integer> {
    public static final String KEY = "targettime";

    public TicketFieldTargetTime() {
        super(KEY, null);
    }

    public Integer getValidOrDefaultValue(Integer value, GUID entryID) {
        if (value != null && value == 0) {
            value = null;
        }
        return (Integer)super.getValidOrDefaultValue((Object)value, entryID);
    }

    public void validate(Integer value) {
        super.validate((Object)value);
        if (value != null) {
            BasicFieldValidation.throwIfZero((int)value);
            BasicFieldValidation.throwIfNegative((int)value);
        }
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        return master;
    }

    @Override
    public String valueToString(Integer fieldValue) {
        return TicketFieldTargetTime.targetTimeStringFrom(fieldValue);
    }

    @Override
    protected int getFieldChangeReaStepActionId() {
        return -30;
    }

    public static String targetTimeStringFrom(Number aktTargetTime) {
        if (aktTargetTime == null) {
            return "";
        }
        return String.format("%02d:%02d", aktTargetTime.intValue() / 60, aktTargetTime.intValue() % 60);
    }
}

