/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.tickets.GeneratedTicketAttribute;
import com.inet.helpdesk.core.ticketmanager.timeline.TimelineDataHandler;
import com.inet.helpdesk.shared.model.ticket.TicketTimelineInformations;
import com.inet.plugin.ServerPluginManager;

public class TicketAttributeEscalationLight
extends GeneratedTicketAttribute<Value> {
    public static final String KEY = "escalationlight";
    private static TimelineDataHandler dataHandler = null;

    public TicketAttributeEscalationLight() {
        super(KEY);
    }

    @Override
    public Value getValueFor(int ticketId) {
        TicketTimelineInformations escalationData = this.getEscalationData(ticketId);
        if (escalationData == null) {
            return null;
        }
        long targetTime = escalationData.getTargetTime();
        TicketTimelineInformations deadlineData = TicketAttributeEscalationLight.getHandler().getDeadlineData(ticketId);
        if (deadlineData != null && deadlineData.getTargetTime() < targetTime) {
            return Value.attention;
        }
        long firstTreshold = escalationData.getFirstThreshold();
        long secondTreshold = escalationData.getSecondThreshold();
        long now = System.currentTimeMillis();
        if (now < firstTreshold) {
            return Value.green;
        }
        if (now >= firstTreshold && now <= secondTreshold) {
            return Value.yellow;
        }
        if (now > secondTreshold) {
            return Value.red;
        }
        return null;
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        return master;
    }

    private TicketTimelineInformations getEscalationData(int ticketId) {
        return TicketAttributeEscalationLight.getHandler().getEscalationData(ticketId);
    }

    public Value copyValue(Value value) {
        return value;
    }

    public static TimelineDataHandler getHandler() {
        if (dataHandler == null) {
            ServerPluginManager spm = ServerPluginManager.getInstance();
            dataHandler = (TimelineDataHandler)spm.getSingleInstance(TimelineDataHandler.class);
        }
        return dataHandler;
    }

    public static enum Value {
        attention,
        green,
        yellow,
        red;

    }
}

