/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.argcontainers;

import com.inet.id.GUID;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class TicketSearchFilterOptions {
    private List<FieldCondition> fieldConditions = new ArrayList<FieldCondition>();
    private boolean onlyOwnResources = false;
    private boolean ticketsBundled = false;
    private boolean showWorkflowSlaves = true;
    private boolean hideWiedervorlageTicketsAsConfigured = true;
    private TicketsToFind ticketsToFind;
    private int numOfTickets = 100;
    private Long from;
    private Long to;
    private static final AndSearchExpression CONDITION_TO_MATCH_OPEN_INQUIRIES = new AndSearchExpression(){
        {
            this.add((SearchExpression)new SearchCondition("dispatchingreastepid", SearchCondition.SearchTermOperator.Equals, null));
            this.add((SearchExpression)new SearchCondition("statusid", SearchCondition.SearchTermOperator.BETWEEN, (Object)new Integer[]{0, 299}));
        }
    };
    public static final AndSearchExpression CONDITIONS_TO_MATCH_OPEN_TICKETS = new AndSearchExpression(){
        {
            this.add((SearchExpression)new SearchCondition("statusid", SearchCondition.SearchTermOperator.BETWEEN, (Object)new Integer[]{100, 299}));
            this.add((SearchExpression)new SearchCondition("dispatchingreastepid", SearchCondition.SearchTermOperator.Equals, (Object)""));
        }
    };
    public static final TicketsToFind ONLY_OPEN_INQUIRIES = requestedResources -> CONDITION_TO_MATCH_OPEN_INQUIRIES;
    public static final TicketsToFind ONLY_OPEN_TICKETS = requestedResources -> {
        ArrayList<Object> searchExpression = new ArrayList<Object>();
        if (requestedResources != null) {
            if (requestedResources.length == 0) {
                searchExpression.add(new SearchCondition("statusid", SearchCondition.SearchTermOperator.Equals, (Object)Integer.MIN_VALUE));
                return searchExpression;
            }
            OrSearchExpression orExpression = new OrSearchExpression();
            Arrays.stream(requestedResources).forEach(resID -> orExpression.add((Object)new SearchCondition("resourceid", SearchCondition.SearchTermOperator.Equals, resID)));
            searchExpression.add(orExpression);
        }
        searchExpression.addAll((Collection<Object>)CONDITIONS_TO_MATCH_OPEN_TICKETS);
        return searchExpression;
    };
    public static final TicketsToFind ONLY_OPEN_TICKETS_AND_INQUIRIES = requestedResources -> {
        ArrayList<OrSearchExpression> searchExpression = new ArrayList<OrSearchExpression>();
        OrSearchExpression topOrExpression = new OrSearchExpression();
        topOrExpression.add((Object)CONDITION_TO_MATCH_OPEN_INQUIRIES);
        searchExpression.add(topOrExpression);
        if (requestedResources == null) {
            topOrExpression.add((Object)CONDITIONS_TO_MATCH_OPEN_TICKETS);
        } else if (requestedResources.length > 0) {
            AndSearchExpression ticketExpression = new AndSearchExpression();
            OrSearchExpression orExpression = new OrSearchExpression();
            Arrays.stream(requestedResources).forEach(resID -> orExpression.add((Object)new SearchCondition("resourceid", SearchCondition.SearchTermOperator.Equals, resID)));
            ticketExpression.add((SearchExpression)orExpression);
            ticketExpression.add((SearchExpression)CONDITIONS_TO_MATCH_OPEN_TICKETS);
            topOrExpression.add((Object)ticketExpression);
        }
        return searchExpression;
    };
    public static final TicketsToFind ANY = requestedResources -> {
        ArrayList<OrSearchExpression> searchExpression = new ArrayList<OrSearchExpression>();
        if (requestedResources == null) {
            return searchExpression;
        }
        SearchCondition conditionForAllOther = new SearchCondition("statusid", SearchCondition.SearchTermOperator.NOT_BETWEEN, (Object)new Integer[]{0, 99});
        OrSearchExpression topOrExpression = new OrSearchExpression();
        searchExpression.add(topOrExpression);
        topOrExpression.add((Object)CONDITION_TO_MATCH_OPEN_INQUIRIES);
        if (requestedResources.length > 0) {
            AndSearchExpression ticketExpression = new AndSearchExpression();
            OrSearchExpression orExpression = new OrSearchExpression();
            Arrays.stream(requestedResources).forEach(resID -> orExpression.add((Object)new SearchCondition("resourceid", SearchCondition.SearchTermOperator.Equals, resID)));
            ticketExpression.add((SearchExpression)orExpression);
            ticketExpression.add((SearchExpression)conditionForAllOther);
            topOrExpression.add((Object)ticketExpression);
        }
        return searchExpression;
    };
    public static final TicketsToFind ONLY_TICKETS = requestedResources -> {
        List<SearchExpression> searchExpression = ANY.getConditions(requestedResources);
        searchExpression.add((SearchExpression)new SearchCondition("statusid", SearchCondition.SearchTermOperator.GE, (Object)100));
        return searchExpression;
    };

    public static final TicketsToFind ONLY_TICKETS_WITH_STATUS(int statusId) {
        return requestedResources -> Collections.unmodifiableList(Arrays.asList(new SearchCondition("statusid", SearchCondition.SearchTermOperator.Equals, (Object)statusId)));
    }

    private TicketSearchFilterOptions() {
    }

    public static TicketSearchFilterOptions of(TicketsToFind ticketsToFind) {
        TicketSearchFilterOptions options = new TicketSearchFilterOptions();
        return options.findTickets(ticketsToFind);
    }

    public TicketSearchFilterOptions findTickets(TicketsToFind ticketsToFind) {
        if (ticketsToFind == null) {
            throw new IllegalArgumentException("TicketsToFind cannot be null!");
        }
        this.ticketsToFind = ticketsToFind;
        return this;
    }

    public TicketSearchFilterOptions addFieldCondition(FieldCondition condition) {
        if (condition == null) {
            throw new IllegalArgumentException("Condition is null!");
        }
        this.fieldConditions.add(condition);
        return this;
    }

    public TicketSearchFilterOptions addFieldCondition(SearchExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Expression is null!");
        }
        this.fieldConditions.add(() -> expression);
        return this;
    }

    public TicketSearchFilterOptions withOnlyOwnResources(boolean onlyOwnResources) {
        this.onlyOwnResources = onlyOwnResources;
        return this;
    }

    public TicketSearchFilterOptions withTicketsBundled(boolean ticketsBundled) {
        this.ticketsBundled = ticketsBundled;
        return this;
    }

    public TicketSearchFilterOptions withNumOfTickets(int numOfTickets) {
        this.numOfTickets = numOfTickets;
        return this;
    }

    public TicketSearchFilterOptions withShowWorkflowSlaves(boolean showWorkflowslaves) {
        this.showWorkflowSlaves = showWorkflowslaves;
        return this;
    }

    public TicketSearchFilterOptions withDateFrom(Long from) {
        this.from = from;
        this.to = null;
        return this;
    }

    public TicketSearchFilterOptions withDateTo(Long to) {
        this.from = null;
        this.to = to;
        return this;
    }

    public TicketSearchFilterOptions withDateBetween(Long from, Long to) {
        this.from = from;
        this.to = to;
        return this;
    }

    public TicketSearchFilterOptions withHideWiedervorlageTicketsAsConfigured(boolean hideWiedervorlageTicketsAsConfigured) {
        this.hideWiedervorlageTicketsAsConfigured = hideWiedervorlageTicketsAsConfigured;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("fieldConditions: " + this.fieldConditions).append("\n");
        sb.append("onlyOwnResources=").append(this.onlyOwnResources).append("\n");
        sb.append("ticketsBundled=").append(this.ticketsBundled).append("\n");
        sb.append("showWorkflowSlaves=").append(this.showWorkflowSlaves).append("\n");
        sb.append("hideWiedervorlageTicketsAsConfigured=").append(this.hideWiedervorlageTicketsAsConfigured).append("\n");
        sb.append("NumOfTickets=").append(this.numOfTickets).append("\n");
        sb.append("from=").append(this.ticketsBundled).append(", to=").append(this.to).append("\n");
        return sb.toString();
    }

    public TicketsToFind getTicketsToFind() {
        return this.ticketsToFind;
    }

    public List<FieldCondition> getFieldConditions() {
        return this.fieldConditions;
    }

    public boolean isOnlyOwnResources() {
        return this.onlyOwnResources;
    }

    public boolean isTicketsBundled() {
        return this.ticketsBundled;
    }

    public boolean isShowWorkflowSlaves() {
        return this.showWorkflowSlaves;
    }

    public int getNumOfTickets() {
        return this.numOfTickets;
    }

    public Long getFrom() {
        return this.from;
    }

    public Long getTo() {
        return this.to;
    }

    public boolean isHideWiedervorlageTicketsAsConfigured() {
        return this.hideWiedervorlageTicketsAsConfigured;
    }

    public static interface TicketsToFind {
        public List<SearchExpression> getConditions(GUID[] var1);
    }

    public static interface FieldCondition {
        public SearchExpression getCondition();
    }
}

