/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.shared.model.Status;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class TicketVO {
    private static Map<String, Field<Object>> registeredFieldsAndAttributesMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object getForKey(String key) throws IllegalArgumentException {
        Field<Object> fieldOrAttribute;
        if (registeredFieldsAndAttributesMap == null) {
            Class<TicketVO> clazz = TicketVO.class;
            // MONITORENTER : com.inet.helpdesk.core.ticketmanager.model.TicketVO.class
            if (registeredFieldsAndAttributesMap == null) {
                registeredFieldsAndAttributesMap = new HashMap<String, Field<Object>>();
                ServerPluginManager spm = ServerPluginManager.getInstance();
                spm.get(TicketAttribute.class).stream().forEach(att -> registeredFieldsAndAttributesMap.put(att.getKey(), (Field<Object>)att));
                spm.get(TicketField.class).stream().forEach(field -> registeredFieldsAndAttributesMap.put(field.getKey(), (Field<Object>)field));
            }
            // MONITOREXIT : clazz
        }
        if ((fieldOrAttribute = registeredFieldsAndAttributesMap.get(key)) == null) {
            throw new IllegalArgumentException("Unknown key: " + key);
        }
        if (!(fieldOrAttribute instanceof TicketAttribute)) return this.getValue((TicketField)fieldOrAttribute);
        return this.getAttribute((TicketAttribute)fieldOrAttribute);
    }

    public abstract <VALUE> VALUE getAttribute(TicketAttribute<VALUE> var1);

    public abstract <VALUE> boolean hasAttributeKey(TicketAttribute<VALUE> var1);

    public abstract Set<TicketAttribute<Object>> getIncludedAttributes();

    public abstract <VALUE> VALUE getValue(TicketField<VALUE> var1);

    public abstract <VALUE> boolean hasFieldKey(TicketField<VALUE> var1);

    public abstract Set<TicketField<Object>> getIncludedFields();

    public abstract int getID();

    public final int getInitialReaStepID() {
        return this.getAttribute(Tickets.ATTRIBUTE_INITIAL_REA_STEP_ID);
    }

    public final Integer getDispatchingReaStepID() {
        return this.getAttribute(Tickets.ATTRIBUTE_DISPATCHING_REA_STEP_ID);
    }

    public final boolean isDispatched() {
        return this.getDispatchingReaStepID() != null && this.getDispatchingReaStepID() >= 0;
    }

    public final boolean isOpenAndDispatched() {
        return Status.isOpenStatus(this.getStatusID()) && this.isDispatched();
    }

    public final long getLastChanged() {
        return this.getAttribute(Tickets.ATTRIBUTE_LAST_CHANGED);
    }

    public final int getStatusID() {
        return this.getAttribute(Tickets.ATTRIBUTE_STATUS_ID);
    }

    public final int getPriorityID() {
        return this.getValue(Tickets.FIELD_PRIORITY_ID);
    }

    @Nonnull
    public final String getSubject() {
        return this.getValue(Tickets.FIELD_SUBJECT);
    }

    @Nullable
    public final Integer getCategoryID() {
        return this.getValue(Tickets.FIELD_CATEGORY_ID);
    }

    public final int getClassificationID() {
        return this.getValue(Tickets.FIELD_CLASSIFICATION_ID);
    }

    @Nullable
    public final GUID getResourceID() {
        return this.getValue(Tickets.FIELD_RESOURCE_GUID);
    }

    @Nullable
    public final GUID getOwnerID() {
        return this.getValue(Tickets.FIELD_OWNER_GUID);
    }

    @Nonnull
    public final String getAnnotation() {
        return this.getValue(Tickets.FIELD_ANNOTATION);
    }

    public final long getInquiryDate() {
        return this.getAttribute(Tickets.ATTRIBUTE_INQUIRY_DATE);
    }

    @Nullable
    public final GUID getLastEditorID() {
        return this.getAttribute(Tickets.ATTRIBUTE_LAST_EDITOR_GUID);
    }

    @Nullable
    public final GUID getLastChangedByID() {
        return this.getAttribute(Tickets.ATTRIBUTE_LAST_CHANGED_BY_GUID);
    }

    @Nullable
    public final String getEmailEingang() {
        return this.getAttribute(Tickets.ATTRIBUTE_EMAIL_EINGANG);
    }

    @Nullable
    public final Integer getWorkflowID() {
        return this.getAttribute(Tickets.ATTRIBUTE_WORKFLOW_ID);
    }

    @Nullable
    public final Long getWorkflowStartDate() {
        return this.getAttribute(Tickets.ATTRIBUTE_WORKFLOW_START_DATE);
    }

    public final boolean isSubTicketInWorkflow() {
        if (this.getWorkflowID() == null) {
            return false;
        }
        return !Objects.equals(this.getID(), this.getWorkflowID());
    }

    public final int getSumTime() {
        return this.getAttribute(Tickets.ATTRIBUTE_SUM_TIME);
    }

    @Nonnull
    public final String getCustom1() {
        return this.getValue(Tickets.FIELD_CUSTOM_1);
    }

    @Nonnull
    public final String getCustom2() {
        return this.getValue(Tickets.FIELD_CUSTOM_2);
    }

    @Nonnull
    public final String getCustom3() {
        return this.getValue(Tickets.FIELD_CUSTOM_3);
    }

    @Nonnull
    public final String getCustom4() {
        return this.getValue(Tickets.FIELD_CUSTOM_4);
    }

    @Nonnull
    public final String getCustom5() {
        return this.getValue(Tickets.FIELD_CUSTOM_5);
    }

    @Nonnull
    public final String getCustom6() {
        return this.getValue(Tickets.FIELD_CUSTOM_6);
    }

    @Nonnull
    public final String getCustom7() {
        return this.getValue(Tickets.FIELD_CUSTOM_7);
    }

    @Nonnull
    public final String getIdentifier() {
        return this.getValue(Tickets.FIELD_IDENTIFIER);
    }

    public final int getItilID() {
        return this.getValue(Tickets.FIELD_ITIL_ID);
    }

    @Nullable
    public final Integer getTargetTime() {
        return this.getValue(Tickets.FIELD_TARGET_TIME);
    }

    @Nullable
    public final Long getDeadline() {
        return this.getValue(Tickets.FIELD_DEADLINE);
    }

    public final boolean hasAttachments() {
        return this.getAttribute(Tickets.ATTRIBUTE_ATTACHMENTS);
    }

    public final int getBundleID() {
        Integer bundleID = this.getAttribute(Tickets.ATTRIBUTE_BUNDLE_ID);
        if (bundleID == null) {
            return this.getID();
        }
        return bundleID;
    }

    public final boolean isMasterInBundle() {
        Integer bundleID = this.getAttribute(Tickets.ATTRIBUTE_BUNDLE_ID);
        return bundleID != null && this.getID() == bundleID.intValue();
    }

    public final boolean isSlaveInBundle() {
        Integer bundleID = this.getAttribute(Tickets.ATTRIBUTE_BUNDLE_ID);
        return bundleID != null && this.getID() != bundleID.intValue();
    }

    public final boolean isUnbundled() {
        return this.getAttribute(Tickets.ATTRIBUTE_BUNDLE_ID) == null;
    }

    public final boolean isInquiry() {
        return !this.isDispatched();
    }

    public final boolean isAutoEscalated() {
        return this.getAttribute(Tickets.ATTRIBUTE_AUTOESCALATED);
    }

    public <T> T getFieldOrAttributeValue(Field<T> fieldOrAttribute) {
        if (fieldOrAttribute instanceof TicketAttribute) {
            return (T)this.getAttribute((TicketAttribute)fieldOrAttribute);
        }
        if (fieldOrAttribute instanceof TicketField) {
            return (T)this.getValue((TicketField)fieldOrAttribute);
        }
        if (fieldOrAttribute == Tickets.ATTRIBUTE_TICKET_ID) {
            return (T)Integer.valueOf(this.getID());
        }
        return null;
    }
}

