/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

import com.inet.annotations.JsonData;
import com.inet.editor.HtmlConverter;

@JsonData
public class ReaStepTextVO {
    private String text;
    private boolean htmlContent;

    private ReaStepTextVO() {
    }

    private ReaStepTextVO(String text, boolean htmlContent) {
        this.text = text == null ? "" : text;
        this.htmlContent = htmlContent;
    }

    public String getText() {
        return this.text;
    }

    public boolean hasHtmlContent() {
        return this.htmlContent;
    }

    public static ReaStepTextVO of(String text, boolean htmlContent) {
        return new ReaStepTextVO(text, htmlContent);
    }

    public static ReaStepTextVO empty() {
        return ReaStepTextVO.of("", false);
    }

    public boolean isEmpty() {
        return this.text.trim().isEmpty() || this.htmlContent && HtmlConverter.html2text((String)this.text).trim().isEmpty() && !this.text.contains("src=");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.htmlContent ? 1231 : 1237);
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReaStepTextVO other = (ReaStepTextVO)obj;
        if (this.htmlContent != other.htmlContent) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public String toString() {
        return "ReaStepTextVO [text=" + this.text + ", htmlContent=" + this.htmlContent + "]";
    }
}

