/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

import com.inet.annotations.InternalApi;
import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionForTicketOwner;
import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextMember;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.html.InetHtmlConfiguration;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlWriter;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.Logger;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.swing.text.Element;

@InternalApi
public class AutoTextManager
extends GenericFieldsManager<AutoTextVO> {
    public static final int TYP_VISIBLE_DISPATCHER = 1;
    public static final int TYP_VISIBLE_SUPPORTER = 2;
    public static final int TYP_VISIBLE_EMAIL_ANSWER = 4;
    public static final int TYP_VISIBLE_ENDUSER = 8;
    public static final int TYP_SIGNATURE = 16;
    public static final String TEXTBAUSTEIN_START_TAG = "{";
    public static final String TEXTBAUSTEIN_END_TAG = "}";
    public static final String PLACEHOLDER_CUSTOM_TICKETID_STRING = "ticketIdString";
    public static final String PLACEHOLDER_CUSTOM_REASTEPDATA = "reastep";
    public static final String PLACEHOLDER_CUSTOM_CURRENTUSER_DISPLAYNAME = "currentuser.displayname";
    public static final String PLACEHOLDER_CUSTOM_USER_EMAIL = "email";
    public static final String PLACEHOLDER_PREFIX_OWNER = "ticketowner.";
    public static final String PLACEHOLDER_PREFIX_CURRENTUSER = "currentuser.";
    private static final Comparator<AutoTextVO> COMPARE_IGNORE_CASE = (o1, o2) -> {
        int compareToIgnoreCase;
        String g1 = o1.getGroupLabel();
        String g2 = o2.getGroupLabel();
        if (g1 == null) {
            g1 = "";
        }
        if (g2 == null) {
            g2 = "";
        }
        if (g1.length() == 0) {
            if (g2.length() > 0) {
                return 1;
            }
        } else if (g2.length() == 0) {
            return -1;
        }
        if ((compareToIgnoreCase = g1.compareToIgnoreCase(g2)) == 0) {
            compareToIgnoreCase = o1.getLabel().compareToIgnoreCase(o2.getLabel());
        }
        return compareToIgnoreCase;
    };

    public AutoTextManager() {
        super(AutoTextVO.class, "tblAutoTexts");
    }

    public List<AutoTextVO> getAllAutoTexts() {
        return this.getAutoTexts(null, null, null, false);
    }

    public List<AutoTextVO> getAutoTexts(@Nullable Integer ticketId, @Nullable Integer stepId, @Nullable Integer actionId) {
        return this.getAutoTexts(ticketId, stepId, actionId, true);
    }

    private List<AutoTextVO> getAutoTexts(@Nullable Integer ticketId, @Nullable Integer stepId, @Nullable Integer actionId, boolean filterAutoTextsBasedOnTicketContext) {
        List<AutoTextVO> all = this.getAll(true);
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        int userID = HDUsersAndGroups.getUserID(currentUserAccount);
        Set groupsForUser = UserGroupManager.getInstance().getGroupsForUser(currentUserAccount.getID());
        TicketContext ticketContext = this.getTicketContext(ticketId, currentUserAccount);
        TicketPermissionContext permissionContext = ticketContext.getPermissionContext();
        boolean isInquiry = ticketContext.isInquiry();
        all.removeIf(vo -> {
            if (!(vo.getUserId() != null && userID == vo.getUserId() || this.canAccessDueToAllowedMembers(currentUserAccount, groupsForUser, (AutoTextVO)vo))) {
                return true;
            }
            if (filterAutoTextsBasedOnTicketContext) {
                boolean emailVisible;
                int flags = vo.getTyp();
                boolean enduserVisible = (flags & 8) == 8;
                boolean inquiryVisible = (flags & 1) == 1;
                boolean requestVisible = (flags & 2) == 2;
                boolean bl = emailVisible = (flags & 4) == 4;
                if (!enduserVisible && permissionContext.hasEnduserAccessToTicket()) {
                    return true;
                }
                if (permissionContext.hasDispatcherAccessToTicket() || permissionContext.hasSupporterAccessToTicket()) {
                    boolean actionSendEmail;
                    boolean bl2 = actionSendEmail = actionId != null && actionId == -7;
                    if (!actionSendEmail || !emailVisible) {
                        if (!inquiryVisible && isInquiry) {
                            return true;
                        }
                        if (!requestVisible && !isInquiry) {
                            return true;
                        }
                    }
                }
            }
            return false;
        });
        all = all.stream().map(vo -> {
            String langText = vo.getContentText();
            String contentWithPlaceholdersFilled = this.fillPlaceholders(langText, ticketId, stepId);
            AutoTextVO entry = AutoTextVO.of(vo.getId(), vo.getUserId(), vo.getLabel(), vo.getTyp(), contentWithPlaceholdersFilled, vo.getShortcut(), vo.getGroupLabel(), vo.getMemberships());
            return entry;
        }).collect(Collectors.toList());
        all.sort(COMPARE_IGNORE_CASE);
        return all;
    }

    private TicketContext getTicketContext(@Nullable Integer ticketId, UserAccount currentUserAccount) {
        TicketVO ticket;
        TicketPermissionContext context;
        if (ticketId == null) {
            context = new TicketPermissionContext(true, TicketPermissionContext.SupporterPermission.NONE, true);
            ticket = null;
        } else {
            context = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticketId);
            ticket = TicketManager.getReader().getTicket(ticketId);
        }
        boolean inquiry = ticket == null || ticket.isInquiry();
        return new TicketContext(context, inquiry);
    }

    public String fillPlaceholders(String content, @Nullable Integer ticketId, @Nullable Integer stepId) {
        if (StringFunctions.isEmpty((String)content)) {
            return content;
        }
        TicketVO ticket = ticketId == null ? null : TicketManager.getReader().getTicket(ticketId);
        UserAccount supporter = UserManager.getInstance().getCurrentUserAccount();
        int endIndex = 0;
        int startIndex = -1;
        while ((startIndex = ((String)content).indexOf(TEXTBAUSTEIN_START_TAG, startIndex + 1)) >= 0) {
            endIndex = ((String)content).indexOf(TEXTBAUSTEIN_END_TAG, startIndex + TEXTBAUSTEIN_START_TAG.length());
            if (endIndex < 0) continue;
            String placeHolder = ((String)content).substring(startIndex + TEXTBAUSTEIN_START_TAG.length(), endIndex);
            Object replacer = this.getCustomPlaceholderValue(placeHolder, ticket, stepId, supporter);
            if (replacer == null) {
                TicketFieldDefinition def;
                replacer = placeHolder.startsWith(PLACEHOLDER_PREFIX_CURRENTUSER) ? this.getCurrentUserFieldValue(supporter, placeHolder) : ((def = this.findDefinition(placeHolder)) != null ? this.getTicketFieldValue(ticket, def) : "?" + placeHolder + "?");
            }
            content = ((String)content).substring(0, startIndex) + (String)replacer + ((String)content).substring(endIndex + TEXTBAUSTEIN_END_TAG.length());
        }
        return content;
    }

    private String getCurrentUserFieldValue(UserAccount supporter, String placeHolder) {
        if (placeHolder.equals(PLACEHOLDER_CUSTOM_CURRENTUSER_DISPLAYNAME)) {
            return supporter.getDisplayName();
        }
        String placeHolderWithOwnerPrefix = placeHolder.replace(PLACEHOLDER_PREFIX_CURRENTUSER, PLACEHOLDER_PREFIX_OWNER);
        TicketFieldDefinition def = this.findDefinition(placeHolderWithOwnerPrefix);
        if (def == null) {
            return "?" + placeHolder + "?";
        }
        MutableTicketAttributes attributes = new MutableTicketAttributes();
        MutableTicketData data = new MutableTicketData();
        data.put(Tickets.FIELD_OWNER_GUID, supporter.getID());
        TicketVOSingle dummy = TicketVOSingle.create(141, attributes, data);
        return this.nullToEmpty(def.getDisplayValue(dummy));
    }

    private String nullToEmpty(String displayValue) {
        if (displayValue == null) {
            return "";
        }
        return displayValue;
    }

    private TicketFieldDefinition findDefinition(String placeHolder) {
        List list = ServerPluginManager.getInstance().get(TicketFieldDefinition.class);
        for (TicketFieldDefinition ticketFieldDefinition : list) {
            if (!ticketFieldDefinition.getKey().equals(placeHolder) || !ticketFieldDefinition.supportsText()) continue;
            return ticketFieldDefinition;
        }
        return null;
    }

    private String getTicketFieldValue(@Nullable TicketVO ticket, TicketFieldDefinition def) {
        if (ticket == null) {
            return "";
        }
        return this.nullToEmpty(def.getDisplayValue(ticket));
    }

    private String getCustomPlaceholderValue(String placeHolder, @Nullable TicketVO ticket, @Nullable Integer stepId, UserAccount currentUser) {
        if (PLACEHOLDER_CUSTOM_REASTEPDATA.equalsIgnoreCase(placeHolder)) {
            Object replacer = "";
            if (stepId != null) {
                ReaStepTextVO reaStepText = TicketManager.getReader().getReaStepText(stepId);
                ReaStepVO reaStep = TicketManager.getReader().getReaStep(stepId);
                if (reaStepText != null) {
                    String text = reaStepText.getText();
                    text = this.getInlinedHtml(text);
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, ClientLocale.getThreadLocale());
                    String date = dateFormat.format(new Date(reaStep.getStartDate()));
                    if (reaStepText.hasHtmlContent()) {
                        replacer = (String)replacer + Tickets.MSG.getMsg("autotext.emailheader", new Object[]{date, (reaStep.getDisplayName() != null ? reaStep.getDisplayName() : "") + "&nbsp;&lt;" + reaStep.getEmailSenderAddress() + "&gt;&nbsp;"});
                        replacer = (String)replacer + "<br>";
                        replacer = (String)replacer + "<div style=\"border-top-style:none;border-right-style:none;border-bottom-style:none;border-left-style:solid;border-left-color:blue;border-left-width:1.5pt;padding-top:0cm;padding-right:0cm;padding-bottom:0cm;padding-left:4pt;color:rgb(0,0,0);\">";
                        replacer = (String)replacer + text;
                        replacer = (String)replacer + "</div>";
                    } else {
                        replacer = (String)replacer + Tickets.MSG.getMsg("autotext.emailheader", new Object[]{date, (reaStep.getDisplayName() != null ? reaStep.getDisplayName() : "") + "&nbsp;&#60;" + reaStep.getEmailSenderAddress() + "&#62;&nbsp;"});
                        replacer = (String)replacer + "<br>";
                        Object result = "";
                        StringTokenizer t = new StringTokenizer(text, "\n");
                        while (t.hasMoreTokens()) {
                            result = (String)result + "> " + t.nextToken() + "\n";
                        }
                        replacer = (String)replacer + HtmlConverter.text2html((String)result, null);
                    }
                }
            }
            return replacer;
        }
        if (PLACEHOLDER_CUSTOM_TICKETID_STRING.equals(placeHolder)) {
            if (ticket == null) {
                return "";
            }
            return Tickets.getTicketIDForEmailSubject(ticket.getID());
        }
        if (placeHolder.endsWith(PLACEHOLDER_CUSTOM_USER_EMAIL)) {
            if (placeHolder.equalsIgnoreCase("currentuser.email")) {
                return (String)currentUser.getValue((UserField)UsersAndGroups.FIELD_EMAIL);
            }
            if (placeHolder.equalsIgnoreCase("ticketowner.email")) {
                if (ticket == null) {
                    return "";
                }
                GUID ownerID = ticket.getOwnerID();
                if (ownerID == null) {
                    return "";
                }
                UserAccount userAccount = UserManager.getInstance().getUserAccount(ownerID);
                if (userAccount == null) {
                    return "Unknown user";
                }
                return (String)userAccount.getValue((UserField)UsersAndGroups.FIELD_EMAIL);
            }
        }
        return null;
    }

    @Deprecated
    public static AutoTextManager getInstance() {
        return (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class);
    }

    public List<AutoTextVO> getAllAutoTextsForUser(GUID userId, boolean includeAutoTextsForAll) {
        List<AutoTextVO> list = this.getAll(true);
        UserAccount userAccount = UserManager.getInstance().getUserAccount(userId);
        Set groupsForUser = UserGroupManager.getInstance().getGroupsForUser(userAccount.getID());
        list.removeIf(vo -> {
            if (includeAutoTextsForAll && this.canAccessDueToAllowedMembers(userAccount, groupsForUser, (AutoTextVO)vo)) {
                return false;
            }
            return !Objects.equals(HDUsersAndGroups.getUserID(userAccount), vo.getUserId());
        });
        return list;
    }

    private boolean canAccessDueToAllowedMembers(UserAccount userAccount, Set<UserGroupInfo> groupsForUser, AutoTextVO vo) {
        List<AutoTextMember> memberships = vo.getMemberships();
        if (memberships != null && memberships.size() > 0) {
            for (AutoTextMember member : memberships) {
                if (!(member.getType().equals((Object)com.inet.usersandgroups.api.ui.Type.user) ? userAccount.getID().equals((Object)member.getId()) : member.getType().equals((Object)com.inet.usersandgroups.api.ui.Type.group) && groupsForUser.stream().map(UserGroupInfo::getID).anyMatch(guid -> guid.equals((Object)member.getId())))) continue;
                return true;
            }
        }
        return false;
    }

    public List<AutoTextVO> getAllAutoTextsForAdministrator(GUID userId) {
        UserAccount userAccount = UserManager.getInstance().getUserAccount(userId);
        Set groupsForUser = UserGroupManager.getInstance().getGroupsForUser(userAccount.getID());
        boolean isAdminGroup = groupsForUser.contains(UserGroupManager.getInstance().getGroup(UsersAndGroups.GROUPID_ADMIN));
        if (!userAccount.getAccountType().equals((Object)UserAccountType.Administrator) && !isAdminGroup) {
            return new ArrayList<AutoTextVO>();
        }
        List<AutoTextVO> list = this.getAll(true);
        return list;
    }

    public List<String> getAutoTextGroups() {
        return this.getAll(true).stream().map(AutoTextVO::getGroupLabel).filter(Objects::nonNull).map(g -> g.trim()).distinct().sorted((a, b) -> {
            if (a.isEmpty()) {
                if (b.isEmpty()) {
                    return 0;
                }
                return 1;
            }
            if (b.isEmpty()) {
                return -1;
            }
            return a.compareToIgnoreCase((String)b);
        }).collect(Collectors.toList());
    }

    @Override
    public URL getIcon(int id, int size) {
        return null;
    }

    public Map<String, String> getAllPossiblePlaceholders() {
        HashMap<String, String> result = new HashMap<String, String>();
        ServerPluginManager.getInstance().get(TicketFieldDefinition.class).forEach(f -> {
            if (f.supportsText()) {
                result.put(f.getKey(), f.getDisplayName());
                if (f instanceof AbstractTicketFieldDefinitionForTicketOwner) {
                    String key = f.getKey().replace(PLACEHOLDER_PREFIX_OWNER, PLACEHOLDER_PREFIX_CURRENTUSER);
                    result.put(key, f.getDisplayName());
                }
            }
        });
        result.put(PLACEHOLDER_CUSTOM_REASTEPDATA, Tickets.MSG.getMsg("autotext.placeholder.reastep", new Object[0]));
        result.put(PLACEHOLDER_CUSTOM_TICKETID_STRING, Tickets.MSG.getMsg("autotext.placeholder.ticketIdString", new Object[0]));
        result.put(PLACEHOLDER_CUSTOM_CURRENTUSER_DISPLAYNAME, Tickets.MSG.getMsg("autotext.placeholder.currentuser.displayname", new Object[0]));
        result.put("currentuser.email", Tickets.MSG.getMsg("autotext.placeholder.email", new Object[0]));
        result.put("ticketowner.email", Tickets.MSG.getMsg("autotext.placeholder.email", new Object[0]));
        return result;
    }

    @Override
    protected void updateModelValueFromResultSet(AutoTextVO vo, ResultSet rs, int columnIndex, Field field) throws IllegalAccessException, SQLException {
        if (!field.getName().equalsIgnoreCase("memberships")) {
            super.updateModelValueFromResultSet(vo, rs, columnIndex, field);
            return;
        }
        ArrayList fromJson = null;
        try (InputStream binaryStream = rs.getBinaryStream(columnIndex);){
            String readBytes;
            if (binaryStream != null && !StringFunctions.isEmpty((String)(readBytes = IOFunctions.readString((InputStream)binaryStream, (Charset)StandardCharsets.UTF_8)))) {
                fromJson = (ArrayList)new Json().fromJson(readBytes, ArrayList.class, new Type[]{AutoTextMember.class});
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        vo.setMemberships(fromJson);
    }

    @Override
    protected void updateResultSetValueFromModelValue(AutoTextVO vo, Field field, ResultSet rs, int columnIndex) throws IllegalAccessException, SQLException {
        if (!field.getName().equalsIgnoreCase("memberships")) {
            super.updateResultSetValueFromModelValue(vo, field, rs, columnIndex);
            return;
        }
        List<AutoTextMember> memberships = vo.getMemberships();
        String json = new Json().toJson(memberships);
        rs.updateObject(columnIndex, (Object)json.getBytes(StandardCharsets.UTF_8));
    }

    public HashMap<String, Boolean> getAllAutoTextNames(int userId) {
        HashMap<String, Boolean> names = new HashMap<String, Boolean>();
        List list = this.getAll(true);
        for (AutoTextVO autoTextVO : list) {
            names.put(autoTextVO.getLabel(), autoTextVO.getMemberships() != null && !autoTextVO.getMemberships().isEmpty() || autoTextVO.getUserId() != null && autoTextVO.getUserId() == userId);
        }
        return names;
    }

    private String getInlinedHtml(String htmlText) {
        InetHtmlDocument doc = new InetHtmlDocument();
        doc.setDocumentProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, (Object)InetHtmlConfiguration.getMailEditorConfig());
        doc.putProperty((Object)"IgnoreCharsetDirective", (Object)Boolean.TRUE);
        htmlText = htmlText.replace("<head>", "<head><style>p.hddefault { margin-top:0px; margin-bottom:0px; }</style>");
        try {
            doc.parse((Reader)new StringReader(htmlText), 0);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        doc.setDocumentProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, (Object)InetHtmlConfiguration.getMailEditorConfig());
        StringWriter out = new StringWriter();
        Element element = ElementUtils.getBodyElement((InetHtmlDocument)doc);
        InetHtmlWriter writer = new InetHtmlWriter((Writer)out, element);
        writer.setInlineMode(true);
        writer.setAllowStyleSpan(false);
        writer.setEmptyBlockFiller("<br>");
        try {
            writer.write();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        String textContent = out.toString();
        if (textContent.indexOf("src=\"Attachment") != -1) {
            textContent = textContent.replace("src=\"Attachment", "src=\"../Attachment");
        }
        if (textContent.indexOf("href=\"Attachment") != -1) {
            textContent = textContent.replace("href=\"Attachment", "href=\"../Attachment");
        }
        return textContent;
    }

    private static class TicketContext {
        private final TicketPermissionContext permissionContext;
        private final boolean inquiry;

        public TicketContext(TicketPermissionContext permissionContext, boolean inquiry) {
            this.permissionContext = permissionContext;
            this.inquiry = inquiry;
        }

        public TicketPermissionContext getPermissionContext() {
            return this.permissionContext;
        }

        public boolean isInquiry() {
            return this.inquiry;
        }
    }
}

