/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fields.itil;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.fields.Deletable;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import java.util.Objects;

@JsonData
public class ItilVO
extends FieldVO
implements Deletable {
    private String ItilBezeichnung;
    private String ItiImage;
    private boolean geloescht;
    private boolean intern;
    private boolean masterTyp;
    private int protectedContent;
    private String Info;
    private int MsgTyp;
    private String MsgEmail;

    private ItilVO() {
    }

    public ItilVO(int id, String name, String imageName, boolean deleted, boolean internal, boolean masterType, int protectedContent, String info, int messageType, String messageEmail) {
        super(id);
        this.ItilBezeichnung = name;
        this.ItiImage = imageName;
        this.geloescht = deleted;
        this.intern = internal;
        this.masterTyp = masterType;
        this.protectedContent = protectedContent;
        this.Info = info;
        this.MsgTyp = messageType;
        this.MsgEmail = messageEmail;
    }

    public ItilVO(int id, String name) {
        this(id, name, null, false, false, false, 0, null, 0, null);
    }

    @Override
    public String getDisplayValue() {
        return this.ItilBezeichnung;
    }

    public String getImageName() {
        return this.ItiImage;
    }

    @Override
    public boolean isDeleted() {
        return this.geloescht;
    }

    public boolean isInternal() {
        return this.intern;
    }

    public boolean isMasterType() {
        return this.masterTyp;
    }

    public int getProtectedContent() {
        return this.protectedContent;
    }

    public String getInfo() {
        return this.Info;
    }

    public int getMessageType() {
        return this.MsgTyp;
    }

    public String getMessageEmail() {
        return this.MsgEmail;
    }

    public boolean isCloseSubOrders() {
        return this.isMasterType() && (this.protectedContent & 2) != 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ItilVO)) {
            return false;
        }
        ItilVO other = (ItilVO)obj;
        return this.getId() == other.getId() && this.protectedContent == other.protectedContent && this.masterTyp == other.masterTyp && this.geloescht == other.geloescht && this.intern == other.intern && this.MsgTyp == other.MsgTyp && Objects.equals(this.ItilBezeichnung, other.ItilBezeichnung) && Objects.equals(this.ItiImage, other.ItiImage) && Objects.equals(this.Info, other.Info) && Objects.equals(this.MsgEmail, other.MsgEmail);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.Info == null ? 0 : this.Info.hashCode());
        result = 31 * result + (this.ItiImage == null ? 0 : this.ItiImage.hashCode());
        result = 31 * result + (this.ItilBezeichnung == null ? 0 : this.ItilBezeichnung.hashCode());
        result = 31 * result + (this.MsgEmail == null ? 0 : this.MsgEmail.hashCode());
        result = 31 * result + this.MsgTyp;
        result = 31 * result + (this.geloescht ? 1231 : 1237);
        result = 31 * result + (this.intern ? 1231 : 1237);
        result = 31 * result + (this.masterTyp ? 1231 : 1237);
        result = 31 * result + this.protectedContent;
        return result;
    }
}

