/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithGenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.DefaultValuesManager;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectOption;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectOptions;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class TicketFieldDefinitionPriorityId
extends AbstractTicketFieldDefinitionWithGenericFieldsManager {
    public TicketFieldDefinitionPriorityId() {
        super(Tickets.FIELD_PRIORITY_ID, PriorityManager.getInstance());
    }

    @Override
    public String getDisplayName() {
        return HDFieldDisplayNameProvider.getDisplayNameForCustomField(Tickets.FIELD_PRIORITY_ID);
    }

    @Override
    public URL getColumnIcon(Integer iconSize) {
        if (iconSize <= 16) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_prio_16.png");
        }
        if (iconSize <= 32) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_prio_16@2x.png");
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_prio_16@3x.png");
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        return new SelectEditDefinition(){

            @Override
            public boolean isAvailable(List<TicketVO> tickets) {
                UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
                if (!HDUsersAndGroups.isSupporter(currentUserAccount)) {
                    MandatoryFieldsManager mandatoryFieldsManager = (MandatoryFieldsManager)ServerPluginManager.getInstance().getSingleInstance(MandatoryFieldsManager.class);
                    List<MandatoryFieldVO> mandatoryFieldSettings = mandatoryFieldsManager.getMandatoryFieldSettings();
                    MandatoryFieldVO mandatoryField = mandatoryFieldSettings.stream().filter(f -> ((Object)((Object)f.getTicketField())).equals((Object)Tickets.FIELD_PRIORITY_ID)).findFirst().orElse(null);
                    return mandatoryField != null && mandatoryField.getUserMandatorySetting() != MandatoryFieldVO.MandatoryType.HIDDEN;
                }
                if (tickets != null) {
                    ActionVO action = (ActionVO)ActionManager.getInstance().get(3);
                    for (TicketVO ticket : tickets) {
                        if (TicketManager.getTicketActionChecker().checkAction(action, ticket, TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket)) == null) continue;
                        return false;
                    }
                }
                return true;
            }

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                Integer prioId;
                SelectOption selectOption;
                String valueString;
                String value = values.get(this.getFieldKey());
                if (!StringFunctions.isEmpty((String)value) && !StringFunctions.isEmpty((String)(valueString = (selectOption = (SelectOption)new Json().fromJson(value, SelectOption.class)).getValue())) && (prioId = Integer.valueOf(valueString)) != null) {
                    ticketData.put(Tickets.FIELD_PRIORITY_ID, prioId);
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                int prioId = 0;
                if (ticket != null) {
                    prioId = ticket.getPriorityID();
                } else {
                    UserAccount ownerAccount;
                    DefaultValuesManager defaultValuesManager = (DefaultValuesManager)ServerPluginManager.getInstance().getSingleInstance(DefaultValuesManager.class);
                    Integer defaultPriorityID = defaultValuesManager.getDefaultPriorityID(ownerAccount = ownerId == null ? null : UserManager.getInstance().getUserAccount(ownerId));
                    if (defaultPriorityID != null) {
                        prioId = defaultPriorityID;
                    }
                }
                SelectOption option = new SelectOption(null, "");
                PriorityVO priorityVO = (PriorityVO)PriorityManager.getInstance().get(prioId);
                if (priorityVO != null) {
                    option = new SelectOption(String.valueOf(prioId), priorityVO.getDisplayValue(), String.valueOf(priorityVO.getId()));
                }
                values.put(this.getFieldKey(), new Json().toJson((Object)option));
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionPriorityId.this.getKey();
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionPriorityId.this.getDisplayName();
            }

            @Override
            public SelectOptions getSelectOptions(List<TicketVO> tickets, String searchTerm, int chunkSize, int currentSize) {
                ArrayList<SelectOption> list = new ArrayList<SelectOption>();
                Comparator<PriorityVO> comparator = new Comparator<PriorityVO>(){

                    @Override
                    public int compare(PriorityVO o1, PriorityVO o2) {
                        return o2.getId() - o1.getId();
                    }
                };
                List prios = PriorityManager.getInstance().getAll(true);
                prios.sort(comparator);
                for (PriorityVO priorityVO : prios) {
                    String priorityDisplayValue = priorityVO.getDisplayValue();
                    if (priorityDisplayValue == null) {
                        priorityDisplayValue = "";
                    }
                    if (!priorityDisplayValue.toLowerCase().contains(searchTerm.toLowerCase())) continue;
                    list.add(new SelectOption(String.valueOf(priorityVO.getId()), priorityDisplayValue, String.valueOf(priorityVO.getId())));
                }
                if (list.size() < currentSize) {
                    return new SelectOptions(new ArrayList<SelectOption>(), 0);
                }
                List<SelectOption> subList = list.subList(currentSize, Math.min(list.size(), currentSize + chunkSize));
                return new SelectOptions(subList, list.size());
            }
        };
    }
}

