/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.Freifeld;
import com.inet.helpdesk.config.FreifeldSetting;
import com.inet.helpdesk.config.FreifeldSettingList;
import com.inet.helpdesk.config.FreifeldType;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldCustomField;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectOption;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectOptions;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.usersandgroups.HDFieldLocator;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.SuppressFBWarnings;

public class CustomFieldDefinitionEditInformations {
    private static final ConfigValue<FreifeldSettingList> FREIFELDER = new ConfigValue(HDConfigKeys.FREIFELDER);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FreifeldSetting getEditInformation(UserAccount account, TicketFieldCustomField ticketField) {
        Freifeld freifeld = CustomFieldDefinitionEditInformations.getCorrespondingFreifeld(ticketField);
        FreifeldSettingList list = (FreifeldSettingList)FREIFELDER.get();
        FreifeldSetting currentSetting = null;
        for (FreifeldSetting freifeldSetting : list) {
            if (!freifeldSetting.getFreifeld().equals((Object)freifeld)) continue;
            currentSetting = freifeldSetting;
        }
        if (ticketField.getKey().equals("custom4") || ticketField.getKey().equals("custom5") || ticketField.getKey().equals("custom6") || ticketField.getKey().equals("custom7")) {
            return currentSetting;
        }
        if (currentSetting == null) {
            ServerPluginManager spm = ServerPluginManager.getInstance();
            ConnectionFactory connectionFactory = (ConnectionFactory)spm.getSingleInstance(ConnectionFactory.class);
            Connection con = null;
            PreparedStatement stm = null;
            ResultSet rs = null;
            boolean hasEntries = false;
            Field field = HDFieldLocator.getOldDbFieldForNewField(ticketField);
            try {
                con = connectionFactory.getConnection();
                stm = con.prepareStatement("SELECT Beschreibung FROM tblSettings WHERE SetID=?");
                stm.setInt(1, field.getLanguageSetID());
                rs = stm.executeQuery();
                if (rs.next()) {
                    final boolean isSupporter = HDUsersAndGroups.isSupporter(account);
                    Predicate<String> predicate = new Predicate<String>(){

                        @Override
                        public boolean test(String line) {
                            return isSupporter && line.startsWith("*") || line.startsWith("#");
                        }
                    };
                    String settingTxt = rs.getString(1);
                    if (settingTxt != null) {
                        hasEntries = Arrays.stream(settingTxt.split("\\n")).filter(predicate).findAny().isPresent();
                    }
                    if (!hasEntries && field == Field.TICKETDATA_TICKETFIELD3) {
                        String gebTxt;
                        rs.close();
                        stm.close();
                        stm = con.prepareStatement("SELECT Werte FROM tblGebaeude WHERE GebID=?");
                        stm.setInt(1, (Integer)account.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID));
                        rs = stm.executeQuery();
                        if (rs.next() && (gebTxt = rs.getString(1)) != null) {
                            hasEntries = Arrays.stream(gebTxt.split("\\n")).filter(predicate).findAny().isPresent();
                        }
                    }
                }
            }
            catch (SQLException e) {
                HDLogger.error(e);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Throwable throwable) {}
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Throwable throwable) {}
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Throwable throwable) {}
            }
            if (hasEntries) {
                currentSetting = new FreifeldSetting(freifeld);
            }
        }
        return currentSetting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL ist provided internally and is hard coded.")
    public static SelectOptions getData(UserAccount account, TicketFieldCustomField ticketField, boolean emptyValue) {
        ArrayList<SelectOption> options = new ArrayList<SelectOption>();
        Freifeld freifeld = CustomFieldDefinitionEditInformations.getCorrespondingFreifeld(ticketField);
        FreifeldSettingList list = (FreifeldSettingList)FREIFELDER.get();
        FreifeldSetting currentSetting = null;
        for (FreifeldSetting freifeldSetting : list) {
            if (!freifeldSetting.getFreifeld().equals((Object)freifeld)) continue;
            currentSetting = freifeldSetting;
        }
        if (currentSetting != null) {
            String db = currentSetting.getDatabase();
            String command = currentSetting.getQueryName();
            boolean allowMulti = currentSetting.getFreifeldType() == FreifeldType.Multi;
            ConnectionFactory factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
            Connection con = null;
            Statement pst = null;
            ResultSet rs = null;
            if (emptyValue && !allowMulti) {
                options.add(new SelectOption("", ""));
            }
            try {
                con = factory.getConnection(db);
                Object query = factory.getCommand(command);
                if (!(query instanceof String)) {
                    SelectOptions selectOptions = null;
                    return selectOptions;
                }
                pst = con.prepareStatement(query.toString());
                rs = pst.executeQuery();
                while (rs.next()) {
                    String key = rs.getString(1);
                    if (StringFunctions.isEmpty((String)key)) continue;
                    options.add(new SelectOption(key, key));
                }
            }
            catch (SQLException e) {
                HDLogger.error(e);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Throwable e) {}
                try {
                    if (pst != null) {
                        pst.close();
                    }
                }
                catch (Throwable e) {}
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Throwable e) {}
            }
        }
        if (ticketField.getKey().equals("custom1") || ticketField.getKey().equals("custom2") || ticketField.getKey().equals("custom3")) {
            ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
            Connection con = null;
            PreparedStatement stm = null;
            ResultSet rs = null;
            Field field = HDFieldLocator.getOldDbFieldForNewField(ticketField);
            try {
                con = connectionFactory.getConnection();
                stm = con.prepareStatement("SELECT Beschreibung FROM tblSettings WHERE SetID=?");
                stm.setInt(1, field.getLanguageSetID());
                rs = stm.executeQuery();
                if (rs.next()) {
                    final boolean isSupporter = HDUsersAndGroups.isSupporter(account);
                    Predicate<String> predicate = new Predicate<String>(){

                        @Override
                        public boolean test(String line) {
                            return isSupporter && line.startsWith("*") || line.startsWith("#");
                        }
                    };
                    String settingTxt = rs.getString(1);
                    if (settingTxt != null) {
                        List labels = Arrays.stream(settingTxt.split("\\n")).filter(predicate).collect(Collectors.toList());
                        for (String string : labels) {
                            string = string.substring(1).trim();
                            options.add(new SelectOption(string, string));
                        }
                    }
                    if (field == Field.TICKETDATA_TICKETFIELD3) {
                        String gebTxt;
                        rs.close();
                        stm.close();
                        stm = con.prepareStatement("SELECT Werte FROM tblGebaeude WHERE GebID=?");
                        stm.setInt(1, (Integer)account.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID));
                        rs = stm.executeQuery();
                        if (rs.next() && (gebTxt = rs.getString(1)) != null) {
                            List labels = Arrays.stream(gebTxt.split("\\n")).filter(predicate).collect(Collectors.toList());
                            for (String string : labels) {
                                string = string.substring(1).trim();
                                options.add(new SelectOption(string, string));
                            }
                        }
                    }
                }
            }
            catch (SQLException e) {
                HDLogger.error(e);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Throwable throwable) {}
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Throwable throwable) {}
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        return new SelectOptions(options, options.size());
    }

    private static Freifeld getCorrespondingFreifeld(TicketField<?> field) {
        switch (field.getKey()) {
            case "custom1": {
                return Freifeld.auftrag1;
            }
            case "custom2": {
                return Freifeld.auftrag2;
            }
            case "custom3": {
                return Freifeld.auftrag3;
            }
            case "custom4": {
                return Freifeld.auftrag4;
            }
            case "custom5": {
                return Freifeld.auftrag5;
            }
            case "custom6": {
                return Freifeld.auftrag6;
            }
            case "custom7": {
                return Freifeld.auftrag7;
            }
        }
        return null;
    }
}

