/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByIDSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroup;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.Field;
import java.net.URL;

@InternalApi
public abstract class AbstractTicketFieldDefinitionWithGenericFieldsManager
extends TicketFieldDefinition {
    private GenericFieldsManager<?> fieldsManager;
    private Field<Integer> fieldInstance;

    public AbstractTicketFieldDefinitionWithGenericFieldsManager(TicketAttribute<Integer> fieldInstance, GenericFieldsManager<?> fieldsManager) {
        super(fieldInstance, true, true);
        this.fieldInstance = fieldInstance;
        this.fieldsManager = fieldsManager;
    }

    public AbstractTicketFieldDefinitionWithGenericFieldsManager(TicketField<Integer> fieldInstance, GenericFieldsManager<?> fieldsManager) {
        super(fieldInstance, true, true);
        this.fieldInstance = fieldInstance;
        this.fieldsManager = fieldsManager;
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        Integer value = ticket.getFieldOrAttributeValue(this.fieldInstance);
        if (value == null) {
            return null;
        }
        if (this.fieldInstance instanceof TicketField) {
            return ((TicketField)this.fieldInstance).valueToString(value);
        }
        Object entry = this.fieldsManager.get(value);
        if (entry == null) {
            return null;
        }
        return ((FieldVO)entry).getDisplayValue();
    }

    @Override
    public String getValueAsStringForIcon(TicketVO ticket) {
        Integer value = ticket.getFieldOrAttributeValue(this.fieldInstance);
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public URL getIconForValue(String valueAsString, int size) {
        if (StringFunctions.isEmpty((String)valueAsString)) {
            return null;
        }
        return this.fieldsManager.getIcon(Integer.parseInt(valueAsString), size);
    }

    @Override
    public SortGroupInformation getSortGroupInformation() {
        return new ByIDSortGroupInformation(this.fieldInstance.getKey(), sortGroupKey -> {
            Object entry = this.fieldsManager.get(Integer.parseInt(sortGroupKey));
            String displayName = null;
            boolean iconAvailable = false;
            if (entry != null && !StringFunctions.isEmpty((String)((FieldVO)entry).getDisplayValue())) {
                displayName = ((FieldVO)entry).getDisplayValue();
                iconAvailable = true;
            } else {
                displayName = Tickets.MSG.getMsg("value.unset", new Object[0]);
            }
            String iconKey = sortGroupKey;
            return new SortGroup(displayName, iconAvailable, iconKey);
        });
    }

    @Override
    public String getDisplayName() {
        if (this.fieldInstance instanceof TicketField) {
            return ((TicketField)this.fieldInstance).getFieldDisplayName(ClientLocale.getThreadLocale());
        }
        return super.getDisplayName();
    }
}

