/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.DateTimeUtils;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByDateRangeSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.http.servlet.ClientLocale;
import com.inet.usersandgroups.api.Field;

@InternalApi
public abstract class AbstractTicketFieldDefinitionWithDate
extends TicketFieldDefinition {
    private Field<?> fieldInstance;
    private boolean shortDateFormat;

    public AbstractTicketFieldDefinitionWithDate(TicketAttribute<?> fieldInstance, boolean shortDateFormat) {
        super(fieldInstance, true, false);
        this.fieldInstance = fieldInstance;
        this.shortDateFormat = shortDateFormat;
    }

    public AbstractTicketFieldDefinitionWithDate(TicketField<?> fieldInstance, boolean supportsIcon, boolean shortDateFormat) {
        super(fieldInstance, true, supportsIcon);
        this.fieldInstance = fieldInstance;
        this.shortDateFormat = shortDateFormat;
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        Object value = ticket.getFieldOrAttributeValue(this.fieldInstance);
        if (value == null) {
            return null;
        }
        if (this.shortDateFormat) {
            return DateTimeUtils.dateTimeToShortFormat((Long)value);
        }
        return DateTimeUtils.dateTimeToLongFormat((Long)value);
    }

    @Override
    public SortGroupInformation getSortGroupInformation() {
        return new ByDateRangeSortGroupInformation(this.fieldInstance.getKey());
    }

    @Override
    public String getDisplayName() {
        if (this.fieldInstance instanceof TicketField) {
            return ((TicketField)this.fieldInstance).getFieldDisplayName(ClientLocale.getThreadLocale());
        }
        return super.getDisplayName();
    }
}

