/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager;

import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.plugin.veto.VetoSemaphore;
import com.inet.plugin.veto.VetoType;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class TicketManagerVetoPower {
    public static final VetoType TYPE = new VetoType("ticketindex", 550);
    private static final AtomicBoolean reindex = new AtomicBoolean(false);
    private final AtomicBoolean startedInitialization = new AtomicBoolean(false);
    private final Consumer<Boolean> indexInitializer;
    private VetoSemaphore veto;

    public TicketManagerVetoPower(@Nonnull Consumer<Boolean> indexInitializer) {
        this.indexInitializer = indexInitializer;
        this.veto = new VetoSemaphore(Tickets.MSG);
    }

    public VetoSemaphore checkForVeto() {
        if (!this.startedInitialization.getAndSet(true)) {
            this.veto.setStatusPercentage(0);
            this.veto.setStatusMessage("waitingForInitOfTicketIndex", new String[0]);
            new Thread(() -> {
                this.veto.setStatusMessage("executingInitOfTicketIndex", new String[0]);
                try {
                    this.indexInitializer.accept(reindex.get());
                }
                catch (Throwable t) {
                    this.veto.setStatusMessage("failedInitOfTicketIndex", new String[0]);
                    this.veto = null;
                    return;
                }
                this.veto.setStatusPercentage(100);
                this.veto.setStatusMessage("finishedInitOfTicketIndex", new String[0]);
                this.veto.complete(null);
                this.veto = null;
            }, "Ticket Search Index Init").start();
        }
        return this.veto;
    }

    public static void requestReIndexing() {
        reindex.set(true);
    }
}

