/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.data.TicketDataConnector;
import com.inet.helpdesk.core.ticketmanager.extension.EmailReceivedArgument;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExtensionArguments {
    public static final ExtArg<TicketDataConnector.MailNotification> EXTARG_AUTO_MAIL = new JsonizableAndImmutableExtArg<TicketDataConnector.MailNotification>("ticketextension.automail", TicketDataConnector.MailNotification.class);
    public static final ExtArg<Boolean> EXTARG_NEW_USER_TICKET_JS_TRIGGER = new JsonizableAndImmutableExtArg<Boolean>("ticketextension.newuserticketjstrigger", Boolean.class);
    public static final ExtArg<EditReastepTextActionExtensionData> EXTARG_CHANGED_REA_STEP = new JsonizableAndImmutableExtArg<EditReastepTextActionExtensionData>("ticketextension.changedreastep", EditReastepTextActionExtensionData.class);
    public static final ExtArg<AdditionalEmailAction> EXTARG_APPLY_ANSWER = new JsonizableAndImmutableExtArg<AdditionalEmailAction>("ticketextension.applyanswer", AdditionalEmailAction.class);
    public static final ExtArg<Long> EXTARG_APPOINTMENT = new JsonizableAndImmutableExtArg<Long>("processingtimeextension.appointment", Long.class);
    public static final ExtArg<ResourceActionExtensionData> EXTARG_RESOURCE_ACTION_EXTENSION_DATA = new JsonizableAndImmutableExtArg<ResourceActionExtensionData>("ticketactionextension.escalate", ResourceActionExtensionData.class);
    public static final ExtArg<MutableTicketData> EXTARG_TICKET_DATA = new ExtArg<MutableTicketData>(){

        @Override
        public String getKey() {
            return "ticketDataToChange";
        }

        @Override
        public Class<MutableTicketData> getValueType() {
            return MutableTicketData.class;
        }

        @Override
        public String toJson(MutableTicketData value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MutableTicketData fromJson(String jsonData) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MutableTicketData copyValue(MutableTicketData value) {
            return value.copy();
        }
    };
    public static final ExtArg<BundleTicketActionExtensionData> EXTARG_BUNDLE_TICKETS = new ExtArg<BundleTicketActionExtensionData>(){

        @Override
        public String getKey() {
            return "ticketactionextension.bundle";
        }

        @Override
        public Class<BundleTicketActionExtensionData> getValueType() {
            return BundleTicketActionExtensionData.class;
        }

        @Override
        public String toJson(BundleTicketActionExtensionData value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BundleTicketActionExtensionData fromJson(String jsonData) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BundleTicketActionExtensionData copyValue(BundleTicketActionExtensionData value) {
            return value.copy();
        }
    };
    public static final ExtArg<DispatchNow> EXTARG_DISPATCH_NOW = new JsonizableAndImmutableExtArg<DispatchNow>("ticketextension.dispatchNow", DispatchNow.class);
    private Map<ExtArg<Object>, Object> dataMap = new HashMap<ExtArg<Object>, Object>();
    public static final ExtArg<EmailReceivedArgument> EXTARG_EMAIL_DATA = new ExtArg<EmailReceivedArgument>(){

        @Override
        public String getKey() {
            return "readMailData";
        }

        @Override
        public Class<EmailReceivedArgument> getValueType() {
            return EmailReceivedArgument.class;
        }

        @Override
        public String toJson(EmailReceivedArgument value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public EmailReceivedArgument fromJson(String jsonData) {
            throw new UnsupportedOperationException();
        }

        @Override
        public EmailReceivedArgument copyValue(EmailReceivedArgument value) {
            return value;
        }
    };
    public static final ExtArg<Boolean> EXTARG_IMPLICIT_AUTO_ACTION = new JsonizableAndImmutableExtArg<Boolean>("ticketextension.implicitautoaction", Boolean.class);

    public static List<ExtArg<?>> getExtArgsForRegistration() {
        ArrayList extArgs = new ArrayList();
        extArgs.add(EXTARG_AUTO_MAIL);
        extArgs.add(EXTARG_NEW_USER_TICKET_JS_TRIGGER);
        extArgs.add(EXTARG_CHANGED_REA_STEP);
        extArgs.add(EXTARG_APPLY_ANSWER);
        extArgs.add(EXTARG_APPOINTMENT);
        extArgs.add(EXTARG_RESOURCE_ACTION_EXTENSION_DATA);
        extArgs.add(EXTARG_TICKET_DATA);
        extArgs.add(EXTARG_BUNDLE_TICKETS);
        extArgs.add(EXTARG_DISPATCH_NOW);
        return extArgs;
    }

    public static ExtensionArguments create() {
        return new ExtensionArguments();
    }

    @Nonnull
    public static ExtensionArguments copyOf(@Nonnull ExtensionArguments original) {
        ExtensionArguments extensionArguments = new ExtensionArguments();
        for (ExtArg<Object> extArg : original.dataMap.keySet()) {
            Object originalValue = original.dataMap.get(extArg);
            Object copiedValue = extArg.copyValue(originalValue);
            extensionArguments.dataMap.put(extArg, copiedValue);
        }
        return extensionArguments;
    }

    public static ExtensionArguments generateForSubOperation(@Nonnull ExtensionArguments original) {
        ExtensionArguments newArgs = ExtensionArguments.create();
        if (original.containsExtArg(EXTARG_AUTO_MAIL)) {
            newArgs.put(EXTARG_AUTO_MAIL, original.get(EXTARG_AUTO_MAIL));
        }
        return newArgs;
    }

    private ExtensionArguments() {
    }

    public Set<ExtArg<Object>> getIncludedExtArgs() {
        return new HashSet<ExtArg<Object>>(this.dataMap.keySet());
    }

    public boolean containsExtArg(ExtArg<?> key) {
        return this.dataMap.containsKey(key);
    }

    public <VALUE> VALUE get(ExtArg<VALUE> key) {
        return (VALUE)this.dataMap.get(key);
    }

    public <VALUE> void put(ExtArg<VALUE> key, VALUE value) {
        this.dataMap.put(key, value);
    }

    public <VALUE> VALUE remove(ExtArg<VALUE> key) {
        return (VALUE)this.dataMap.remove(key);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataMap == null ? 0 : this.dataMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionArguments other = (ExtensionArguments)obj;
        return !(this.dataMap == null ? other.dataMap != null : !this.dataMap.equals(other.dataMap));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExtensionArgs:[");
        this.dataMap.entrySet().forEach(e -> sb.append(((ExtArg)e.getKey()).getKey()).append("=").append(e.getValue()));
        sb.append("]");
        return sb.toString();
    }

    public static enum DispatchNow {
        NOT,
        ALWAYS,
        IF_RESOURCE_AVAILABLE;


        public static DispatchNow ofBooleanFlag(Boolean flag) {
            if (flag != null && flag.booleanValue()) {
                return ALWAYS;
            }
            return NOT;
        }
    }

    public static class JsonizableAndImmutableExtArg<VALUE>
    implements ExtArg<VALUE> {
        private final String key;
        private final Class<VALUE> valueType;

        public JsonizableAndImmutableExtArg(@Nonnull String key, @Nonnull Class<VALUE> valueType) {
            this.key = key;
            this.valueType = valueType;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Class<VALUE> getValueType() {
            return this.valueType;
        }

        @Override
        public String toJson(VALUE value) {
            return new Json().toJson(value);
        }

        @Override
        public VALUE fromJson(String jsonData) {
            return (VALUE)new Json().fromJson(jsonData, this.getValueType());
        }

        @Override
        public VALUE copyValue(VALUE value) {
            return value;
        }
    }

    public static enum AdditionalEmailAction {
        SEND_ONLY,
        SEND_AND_CLOSE,
        SEND_AND_CLOSE_AFTER_X_DAYS;

    }

    @JsonData
    public static class EditReastepTextActionExtensionData {
        private int changedReaStepID;
        private ReaStepTextVO changeReaStepContent;

        private EditReastepTextActionExtensionData() {
        }

        private EditReastepTextActionExtensionData(int changedReaStepID, ReaStepTextVO changeReaStepContent) {
            if (changeReaStepContent == null) {
                throw new IllegalArgumentException("ChangedReaStepContent cannot be null, use ReaStepTextVO.empty() if you want to clear the text!");
            }
            this.changedReaStepID = changedReaStepID;
            this.changeReaStepContent = changeReaStepContent;
        }

        public static EditReastepTextActionExtensionData create(int changedReaStepID, ReaStepTextVO changeReaStepContent) {
            return new EditReastepTextActionExtensionData(changedReaStepID, changeReaStepContent);
        }

        public int getChangedReaStepID() {
            return this.changedReaStepID;
        }

        public ReaStepTextVO getChangeReaStepContent() {
            return this.changeReaStepContent;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.changeReaStepContent == null ? 0 : this.changeReaStepContent.hashCode());
            result = 31 * result + this.changedReaStepID;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EditReastepTextActionExtensionData other = (EditReastepTextActionExtensionData)obj;
            if (this.changeReaStepContent == null ? other.changeReaStepContent != null : !this.changeReaStepContent.equals(other.changeReaStepContent)) {
                return false;
            }
            return this.changedReaStepID == other.changedReaStepID;
        }
    }

    @JsonData
    public static class ResourceActionExtensionData {
        private GUID targetResID;
        private List<Integer> slaveTicketIDs;
        private boolean changeTicketStatus;

        private ResourceActionExtensionData() {
        }

        private ResourceActionExtensionData(GUID targetResID, @Nullable List<Integer> slaveTicketIDs, boolean changeTicketStatus) {
            if (targetResID == null) {
                throw new IllegalArgumentException(Tickets.MSG.getMsg("error.noResourceSpecified", new Object[0]));
            }
            this.targetResID = targetResID;
            this.slaveTicketIDs = slaveTicketIDs == null || slaveTicketIDs.isEmpty() ? Collections.emptyList() : new ArrayList<Integer>(slaveTicketIDs);
            this.changeTicketStatus = changeTicketStatus;
        }

        public static ResourceActionExtensionData forAuthorizationOfTicket(GUID targetResID) {
            return new ResourceActionExtensionData(targetResID, null, true);
        }

        public static ResourceActionExtensionData forEscalationOfActiveTicket(GUID targetResID, boolean changeTicketStatus) {
            return new ResourceActionExtensionData(targetResID, null, changeTicketStatus);
        }

        public static ResourceActionExtensionData forEscalationOfActivAndInactivTicketsWithoutChangingStatus(GUID targetResID, @Nullable List<Integer> slaveTicketIDs) {
            return new ResourceActionExtensionData(targetResID, slaveTicketIDs, false);
        }

        public GUID getTargetResID() {
            return this.targetResID;
        }

        public List<Integer> getSlaveTicketIDs() {
            return Collections.unmodifiableList(this.slaveTicketIDs);
        }

        public boolean shouldChangeTicketStatus() {
            return this.changeTicketStatus;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.changeTicketStatus ? 1231 : 1237);
            result = 31 * result + (this.slaveTicketIDs == null ? 0 : this.slaveTicketIDs.hashCode());
            result = 31 * result + (this.targetResID == null ? 0 : this.targetResID.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceActionExtensionData other = (ResourceActionExtensionData)obj;
            if (this.changeTicketStatus != other.changeTicketStatus) {
                return false;
            }
            if (this.slaveTicketIDs == null ? other.slaveTicketIDs != null : !this.slaveTicketIDs.equals(other.slaveTicketIDs)) {
                return false;
            }
            return !(this.targetResID == null ? other.targetResID != null : !this.targetResID.equals((Object)other.targetResID));
        }
    }

    public static interface ExtArg<T> {
        public String getKey();

        public Class<T> getValueType();

        public String toJson(T var1);

        public T fromJson(String var1);

        public T copyValue(T var1);
    }

    public static class BundleTicketActionExtensionData {
        private final List<Integer> slaveTicketIDs;
        private final Map<Integer, List<Integer>> slaveToBundledTicketsMap;

        public BundleTicketActionExtensionData(List<Integer> slaveTicketIDs, Map<Integer, List<Integer>> slaveToBundledTicketsMap) {
            this.slaveTicketIDs = Collections.unmodifiableList(new ArrayList<Integer>(slaveTicketIDs));
            HashMap map = new HashMap();
            slaveToBundledTicketsMap.entrySet().stream().forEach(entry -> map.put((Integer)entry.getKey(), Collections.unmodifiableList(new ArrayList((Collection)entry.getValue()))));
            this.slaveToBundledTicketsMap = Collections.unmodifiableMap(map);
        }

        public List<Integer> getSlaveTicketIDs() {
            return this.slaveTicketIDs;
        }

        public Map<Integer, List<Integer>> getSlaveToBundledTicketsMap() {
            return this.slaveToBundledTicketsMap;
        }

        public BundleTicketActionExtensionData copy() {
            return new BundleTicketActionExtensionData(this.slaveTicketIDs, this.slaveToBundledTicketsMap);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.slaveTicketIDs == null ? 0 : this.slaveTicketIDs.hashCode());
            result = 31 * result + (this.slaveToBundledTicketsMap == null ? 0 : this.slaveToBundledTicketsMap.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BundleTicketActionExtensionData other = (BundleTicketActionExtensionData)obj;
            if (this.slaveTicketIDs == null ? other.slaveTicketIDs != null : !this.slaveTicketIDs.equals(other.slaveTicketIDs)) {
                return false;
            }
            return !(this.slaveToBundledTicketsMap == null ? other.slaveToBundledTicketsMap != null : !this.slaveToBundledTicketsMap.equals(other.slaveToBundledTicketsMap));
        }
    }
}

