/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.model.ticket;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.model.ticket.ReaStep;
import com.inet.helpdesk.core.model.ticket.Ticket;
import com.inet.helpdesk.core.model.ticket.TicketWithReaSteps;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TicketIterator
implements Closeable,
Iterator<TicketWithReaSteps> {
    private static final String SQL_GET_ALL_TICKETS = "SELECT tblAuftraege.*, tblBuendel.* FROM tblBuendel, tblAuftraege WHERE tblAuftraege.BunID = tblBuendel.BunID";
    private final ResultSet rs;
    private final Connection connection;

    public TicketIterator(ConnectionFactory connectionFactory) throws SQLException {
        this.connection = connectionFactory.getConnection();
        PreparedStatement ps = this.connection.prepareStatement(SQL_GET_ALL_TICKETS);
        this.rs = ps.executeQuery();
    }

    @Override
    public boolean hasNext() {
        try {
            return this.rs.next();
        }
        catch (SQLException e) {
            HDLogger.error(e);
            return false;
        }
    }

    @Override
    public TicketWithReaSteps next() {
        try {
            return new TicketWithReaSteps(this.readTicketFromResultSet(), this.readReastepsFromResultSet(), this.readAttachmentsFromResultSet());
        }
        catch (ServerDataException e) {
            HDLogger.error(e);
            return null;
        }
    }

    private List<String> readAttachmentsFromResultSet() {
        return new ArrayList<String>();
    }

    private List<ReaStep> readReastepsFromResultSet() {
        return new ArrayList<ReaStep>();
    }

    private Ticket readTicketFromResultSet() throws ServerDataException {
        return null;
    }

    @Override
    public void close() throws IOException {
        try {
            this.rs.close();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }
}

