/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.model.ticket;

import com.inet.annotations.JsonData;
import java.io.Serializable;

@JsonData
public class FormField
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String field;
    private String value;
    private String display;
    private String notAllowed;
    private String image;
    private int options;
    private int typeId;
    private int displayType;

    public FormField() {
    }

    public FormField(String field, String value, String displayName, String notAllowedValue, String imageURL, int options, int displayType, int typeId) {
        this.field = field;
        this.value = value;
        this.display = displayName;
        this.notAllowed = notAllowedValue;
        this.image = imageURL;
        this.options = options;
        this.displayType = displayType;
        this.typeId = typeId;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getField() {
        return this.field;
    }

    public String getNotAllowedValue() {
        return this.notAllowed;
    }

    public String getImageURL() {
        return this.image;
    }

    public void setImageUrl(String imageUrl) {
        this.image = imageUrl;
    }

    public void setNotAllowedValue(String notAllowedValue) {
        this.notAllowed = notAllowedValue;
    }

    public int getDisplayType() {
        return this.displayType;
    }

    public String getDisplayName() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public int getOptions() {
        return this.options;
    }

    public void addOption(int option) {
        this.options |= option;
    }

    public void removeOption(int option) {
        this.options &= ~option;
    }

    public boolean hasOption(int option) {
        return (this.options & option) == option;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("field: ");
        b.append(this.field);
        b.append("\nValue: ").append(this.value);
        b.append("\nOptions: ").append(this.options);
        b.append("\ndisplayName: ").append(this.display);
        b.append("\ntypeId: ").append(this.typeId);
        b.append("\nDisplayType: ").append(this.displayType);
        b.append("\nimageURL: ").append(this.image);
        b.append("\nnotAllowedValue: ").append(this.notAllowed);
        b.append("\n");
        return b.toString();
    }

    public static class Option {
        public static final int FIRSTLEVEL = 1;
        public static final int MANDATORY = 3;
        public static final int READONLY = 4;
        public static final int NEEDSCHANGE = 9;
        public static final int SERVERVALIDATION = 16;
        public static final int HIDDEN = 32;
        public static final int HTMLCONTENT = 64;
        public static final int ALLOWDATEINPAST = 128;
        public static final int MULTILINE = 256;
    }

    public static class DisplayType {
        public static final int TEXTFIELD = 0;
        public static final int TEXTAREA = 1;
        public static final int SELECT = 2;
        public static final int DURATIONINMINUTES = 3;
        public static final int DATE = 4;
        public static final int DATETIME = 5;
        public static final int CURRENCY = 6;
        public static final int EDITABLESELECT = 7;
        public static final int MULTISELECT = 8;
    }
}

