/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.data.valueprovider;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.model.general.Entry;
import com.inet.helpdesk.shared.model.Field;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class KeyValueQueryValueProvider
implements ServerValuesConnector.ValueProvider {
    private final String db;
    private final String command;
    private int myId;
    private String valueColumn;
    private String displayColumn;
    private String refField;
    private boolean allowsEmptyValue;
    private String defaultStringKey;

    public KeyValueQueryValueProvider(String db, Field refField) {
        this.refField = refField.name();
        this.db = db;
        switch (refField) {
            case USERDATA_LANGUAGE: {
                this.command = "Sprachen";
                this.valueColumn = "SprID";
                this.displayColumn = "Sprache";
                this.allowsEmptyValue = false;
                this.defaultStringKey = "xx";
                break;
            }
            default: {
                throw new IllegalArgumentException("KeyValueQueryValueProvider not implemented for field " + refField);
            }
        }
    }

    public KeyValueQueryValueProvider(String db, String refField, String command, String valueColumn, String displayColumn, boolean allowsEmptyValue, String defaultStringKey) {
        this.refField = refField;
        this.db = db;
        this.command = command;
        this.valueColumn = valueColumn;
        this.displayColumn = displayColumn;
        this.allowsEmptyValue = allowsEmptyValue;
        this.defaultStringKey = defaultStringKey;
    }

    @Override
    public String getFieldKey() {
        return this.refField;
    }

    @Override
    public void notifyRegisteredId(int yourId) {
        this.myId = yourId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Query is hard coded. No user manipulation possible.")
    public ArrayList<Entry> getData(UserAccount account, boolean emptyValue) throws ServerDataException {
        ConnectionFactory factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        ArrayList<Entry> result = new ArrayList<Entry>();
        if (emptyValue && this.allowsEmptyValue) {
            result.add(new Entry(this.myId, EMPYT_VALUE_ID, "", ""));
        }
        try (Connection con = factory.getConnection(this.db);){
            Object query = factory.getCommand(this.command);
            if (!(query instanceof String)) {
                ArrayList<Entry> arrayList = null;
                return arrayList;
            }
            try (PreparedStatement pst = con.prepareStatement(query.toString());
                 ResultSet rs = pst.executeQuery();){
                while (rs.next()) {
                    String key = String.valueOf(rs.getObject(this.valueColumn));
                    String display = String.valueOf(rs.getObject(this.displayColumn));
                    Entry res = new Entry(this.myId, key.hashCode(), key, display);
                    result.add(res);
                }
                return result;
            }
        }
        catch (SQLException e) {
            throw new ServerDataException(e);
        }
    }

    @Override
    public boolean allowMultipleValues() {
        return false;
    }

    @Override
    public boolean allowCustomValues() {
        return false;
    }

    @Override
    public boolean hasData(UserAccount account) throws ServerDataException {
        return true;
    }

    @Override
    public Entry getDefaultValue(UserAccount account) throws ServerDataException {
        ArrayList<Entry> data = this.getData(account, false);
        if (this.defaultStringKey != null && data != null) {
            for (Entry e : data) {
                if (!this.defaultStringKey.equals(e.getStringKey())) continue;
                return e;
            }
        }
        return new Entry(this.myId, EMPYT_VALUE_ID, "", "");
    }
}

