/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.pages;

import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigPage;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TicketConfigPage
implements ConfigPage {
    static final Map<String, Permission> INCLUDED_GROUPS = new HashMap<String, Permission>(){
        {
            this.put("ticketvalues", HdPermissions.TEMPLATE_DEFINITION);
            this.put("ticketsettings", Permission.CONFIGURATION);
        }
    };

    public String getPageKey() {
        return "configuration.ticket";
    }

    public String getParentKey() {
        return null;
    }

    public Integer getOptionalPriority() {
        return 4000;
    }

    public String getShortDisplayName() {
        return HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.ticket", new Object[0]);
    }

    public String getFullDisplayName() {
        return HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.ticket", new Object[0]);
    }

    public String getDescription() {
        return HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.ticket.description", new Object[0]);
    }

    public String getHelpKey() {
        return "configuration.ticket";
    }

    public URL getIconURL() {
        return this.getClass().getResource("/com/inet/helpdesk/config/pages/ticket_48.png");
    }

    public boolean isAccessAllowed() {
        return SystemPermissionChecker.hasAnyPermission((UserAccount)UserManager.getInstance().getCurrentUserAccount(), (Permission[])new Permission[]{HdPermissions.TEMPLATE_DEFINITION, Permission.CONFIGURATION});
    }

    public List<ConfigPage> getChildren(ConfigStructure configStructure) {
        ArrayList<ConfigPage> children = new ArrayList<ConfigPage>();
        List groups = configStructure.getGroups();
        for (final ConfigGroup group : groups) {
            if (!INCLUDED_GROUPS.containsKey(group.getKey())) continue;
            children.add(new ConfigPage(){

                public String getPageKey() {
                    return "configuration.ticket." + group.getKey();
                }

                public String getParentKey() {
                    return "configuration.ticket";
                }

                public String getShortDisplayName() {
                    return group.getDisplayName();
                }

                public String getFullDisplayName() {
                    return group.getDisplayName() + " - " + HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.ticket", new Object[0]);
                }

                public String getDescription() {
                    return HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.ticket.description", new Object[0]);
                }

                public String getHelpKey() {
                    return group.getKey();
                }

                public URL getIconURL() {
                    return this.getClass().getResource("/com/inet/helpdesk/config/pages/" + group.getKey() + "_48.png");
                }

                public boolean isAccessAllowed() {
                    return SystemPermissionChecker.checkAccess((Permission)INCLUDED_GROUPS.get(group.getKey()));
                }

                public Set<String> getIncludedConfigGroups(ConfigStructure configStructure) {
                    return new HashSet<String>(Arrays.asList(group.getKey()));
                }
            });
        }
        return children;
    }

    public Set<String> getIncludedConfigGroups(ConfigStructure configStructure) {
        return configStructure.getGroups().stream().filter(group -> INCLUDED_GROUPS.containsKey(group.getKey())).map(LocalizedKey::getKey).collect(Collectors.toSet());
    }
}

