/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.autotext.handler;

import com.inet.helpdesk.config.autotext.data.AutoTextDescription;
import com.inet.helpdesk.config.autotext.data.AutoTextGroupsDescription;
import com.inet.helpdesk.config.autotext.data.SaveAutoTextsRequest;
import com.inet.helpdesk.config.autotext.data.TargetEntry;
import com.inet.helpdesk.config.autotext.handler.AutoTextAttachmentHelper;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextMember;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFunctions;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.http.upload.AttachmentDescription;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.shared.http.upload.AttachmentType;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;

public class SaveAutoText
extends ServiceMethod<SaveAutoTextsRequest, Void> {
    public Void invoke(HttpServletRequest req, HttpServletResponse resp, SaveAutoTextsRequest payload) throws IOException {
        final ArrayList openStream = new ArrayList();
        try {
            AutoTextVO of;
            AutoTextDescription desc = payload.getAutoTextDescription();
            GUID currentUserAccountID = UserManager.getInstance().getCurrentUserAccountID();
            Integer hdUserId = HDUsersAndGroups.getUserID(currentUserAccountID);
            AutoTextManager man = (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class);
            HashMap<String, String> fieldValues = payload.getFieldValues();
            String htmlText = fieldValues.get("htmleditor");
            htmlText = TicketFunctions.correctAttachmentPathesForServer((String)htmlText);
            Integer autotextId = desc.getId();
            ArrayList<String> deleteAttachments = payload.getDeleteAttachments();
            if (autotextId != null && deleteAttachments != null && !deleteAttachments.isEmpty() && ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
                AutoTextAttachmentHelper.deleteAutoTextAttachments(autotextId, deleteAttachments);
            }
            ArrayList<LargeContent> addedAttachments = new ArrayList<LargeContent>();
            if (payload.getAttachments() != null) {
                int attachmentNumber = 0;
                for (AttachmentDescription ad : payload.getAttachments()) {
                    final Part f = req.getPart("attachment" + attachmentNumber++);
                    LargeContent lc = new LargeContent(new LargeContent.InputStreamProvider(){

                        @Override
                        public InputStream getStream() {
                            try {
                                InputStream inputStream = f.getInputStream();
                                openStream.add(inputStream);
                                return inputStream;
                            }
                            catch (Throwable t) {
                                HDLogger.error(t);
                                throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)t));
                            }
                        }

                        @Override
                        public long getSize() {
                            return f.getSize();
                        }
                    });
                    lc.setContentType(AttachmentType.valueOf((String)ad.getAttachmentType().name()));
                    lc.setLastModified(ad.getLastModified());
                    lc.setName(ad.getName());
                    addedAttachments.add(lc);
                }
            }
            String group = desc.getGroup();
            if (autotextId != null) {
                of = AutoTextVO.of(autotextId, desc.getOwnerId(), desc.getLabel(), desc.getFlags(), htmlText, desc.getShortcut(), group, this.getMemberList(desc.getAutoTextGroups()));
                man.update(of);
            } else {
                of = AutoTextVO.of(-1, hdUserId, desc.getLabel(), desc.getFlags(), htmlText, desc.getShortcut(), group, this.getMemberList(desc.getAutoTextGroups()));
                man.add(of);
                autotextId = of.getId();
            }
            if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
                AutoTextAttachmentHelper.addAttachmentsToAutotext(autotextId, addedAttachments);
                if (payload.getDuplicatedAutotextId() != null) {
                    AutoTextAttachmentHelper.addDuplAttachmentsToAutotext(autotextId, payload.getDuplicatedAutotextId());
                }
            }
        }
        catch (Throwable t) {
            HDLogger.error(t);
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)t));
        }
        finally {
            for (InputStream stream : openStream) {
                try {
                    stream.close();
                }
                catch (Throwable t) {
                    if (t instanceof ClientMessageException) {
                        throw t;
                    }
                    HDLogger.error(t);
                    throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)t));
                }
            }
        }
        return null;
    }

    public String getMethodName() {
        return "autotext.saveautotext";
    }

    public short getMethodType() {
        return 1;
    }

    private List<AutoTextMember> getMemberList(AutoTextGroupsDescription groups) {
        if (groups == null) {
            return null;
        }
        String value = groups.getValue();
        if (StringFunctions.isEmpty((String)value)) {
            return null;
        }
        ArrayList fromJson = (ArrayList)new Json().fromJson(value, ArrayList.class, new Type[]{TargetEntry.class});
        if (fromJson == null || fromJson.isEmpty()) {
            return null;
        }
        ArrayList<AutoTextMember> menbersList = new ArrayList<AutoTextMember>();
        for (TargetEntry targetEntry : fromJson) {
            menbersList.add(new AutoTextMember(targetEntry.getGuid(), targetEntry.getEntryType()));
        }
        return menbersList;
    }
}

