/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.autotext;

import com.inet.config.structure.model.ConfigPage;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;

public class AutoTextConfigPage
implements ConfigPage {
    public String getPageKey() {
        return "configuration.autotext";
    }

    public String getParentKey() {
        return "configuration.templates";
    }

    public String getShortDisplayName() {
        return HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.autotext", new Object[0]);
    }

    public String getFullDisplayName() {
        return HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.autotext.fulldisplayname", new Object[0]);
    }

    public String getDescription() {
        return HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.autotext.description", new Object[0]);
    }

    public URL getIconURL() {
        return this.getClass().getResource("/com/inet/helpdesk/config/autotext/images/autotext_48.png");
    }

    public String getRelativeTemplateUrl() {
        return "weblib/configuration.autotext.html";
    }

    public boolean isAccessAllowed() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return false;
        }
        if (HDUsersAndGroups.isSupporter(currentUserAccount)) {
            return true;
        }
        return SystemPermissionChecker.hasAnyPermission((UserAccount)currentUserAccount, (Permission[])new Permission[]{Permission.CONFIGURATION, HdPermissions.TEMPLATE_DEFINITION});
    }

    public String getHelpKey() {
        return "configuration.autotext";
    }
}

