/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.model.general.Entry;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.shared.model.general.ContextType;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class LocalizedKeyListFactory {
    static List<LocalizedKey> getResources() {
        Set resources = UserGroupManager.getInstance().getGroups(HDUsersAndGroups.RESOURCE);
        HashMap idToResource = new HashMap();
        resources.forEach(ugi -> idToResource.put(ugi.getID(), ugi));
        return resources.stream().map(ugi -> {
            Object displayName = ugi.getDisplayName();
            GUID parent = ugi.getParentID();
            while (parent != null) {
                UserGroupInfo parentRes = (UserGroupInfo)idToResource.get(parent);
                displayName = parentRes.getDisplayName() + "/" + (String)displayName;
                parent = parentRes.getParentID();
            }
            return new LocalizedKey("" + HDUsersAndGroups.getResourceId(ugi.getID()), (String)displayName);
        }).sorted((o1, o2) -> o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName())).collect(Collectors.toList());
    }

    static List<LocalizedKey> getResourceNames(ConnectionFactory connectionFactory) {
        ArrayList<LocalizedKey> resources = new ArrayList<LocalizedKey>();
        try (Connection con = connectionFactory.getConnection();
             PreparedStatement st = con.prepareStatement("select ResBezeichnung from tblRessourcen WHERE geloescht = 0 ORDER BY ResBezeichnung ASC");
             ResultSet rs = st.executeQuery();){
            while (rs.next()) {
                String bez = rs.getString(1);
                resources.add(new LocalizedKey(bez, bez));
            }
        }
        catch (SQLException e) {
            HDLogger.error(e);
        }
        return resources;
    }

    static List<LocalizedKey> getPriorities(ConnectionFactory connectionFactory) {
        ArrayList<LocalizedKey> priorities = new ArrayList<LocalizedKey>();
        try (Connection con = connectionFactory.getConnection();
             PreparedStatement st = con.prepareStatement("select PriID, PriBezeichnung from tblPrioritaeten WHERE geloescht = 0 ORDER BY PriID DESC");
             ResultSet rs = st.executeQuery();){
            while (rs.next()) {
                int priID = rs.getInt(1);
                String bez = rs.getString(2);
                priorities.add(new LocalizedKey("" + priID, bez));
            }
        }
        catch (SQLException e) {
            HDLogger.error(e);
        }
        return priorities;
    }

    static List<LocalizedKey> getCategories(ServerValuesConnector svc) {
        ArrayList<LocalizedKey> result = new ArrayList<LocalizedKey>();
        if (UserManager.getRecoveryEnabledInstance().getCurrentUserAccount() == null) {
            return result;
        }
        try {
            ArrayList<Entry> categories = svc.getData(ContextType.supporter, 4, false);
            LocalizedKeyListFactory.addEntriesTo(result, categories, "");
        }
        catch (ServerDataException e) {
            HDLogger.error(e);
        }
        return result;
    }

    static void addEntriesTo(List<LocalizedKey> result, List<Entry> entries, String prefix) {
        for (Entry e : entries) {
            String displayName = prefix + e.getDisplayName();
            result.add(new LocalizedKey(displayName, displayName));
            LocalizedKeyListFactory.addEntriesTo(result, e.getChildren(), displayName + "\\");
        }
    }

    public static List<LocalizedKey> getTicketFieldAndAttributeNamesForEnduser() {
        ArrayList<LocalizedKey> result = new ArrayList<LocalizedKey>();
        for (TicketFieldDefinition att : ServerPluginManager.getInstance().get(TicketFieldDefinition.class)) {
            if (!att.getGrouping().equals((Object)TicketFieldDefinition.FIELD_GROUPING.TICKET)) continue;
            result.add(new LocalizedKey(att.getKey(), att.getDisplayName()));
        }
        Collections.sort(result, new Comparator<LocalizedKey>(){

            @Override
            public int compare(LocalizedKey o1, LocalizedKey o2) {
                return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
            }
        });
        return result;
    }
}

