/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.bot;

import com.inet.annotations.InternalApi;
import com.inet.collaboration.bot.BotResponseFormatter;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.DateTimeUtils;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketview.GlobalSearchViewDefinition;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.http.servlet.ClientLocale;
import com.inet.permissions.AccessDeniedException;
import com.inet.search.SearchResult;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class TicketBotUtils {
    private static final Pattern TICKET_ID = Pattern.compile("(?i)(?<=#)\\d[^ a-zA-Z]*");
    private static final ConfigValue<String> EXTERNAL_URL = new ConfigValue(ConfigKey.SERVER_URL);
    public static final String SEARCH_REGEX = "(?i)(ticket\\s+)?(suche|search|s)\\s+(.*)";
    private static final Pattern SEARCH_PATTERN = Pattern.compile("(?i)(ticket\\s+)?(suche|search|s)\\s+(.*)");

    public static void extractTicketVOsFromText(String text, Consumer<TicketVO> handler) {
        Matcher m = TICKET_ID.matcher(text);
        while (m.find()) {
            String match = m.group();
            match = match.replaceAll("[^0-9]", "");
            int tID = Integer.valueOf(match);
            try {
                TicketVO ticket = TicketManager.getReader().getTicket(tID);
                handler.accept(ticket);
            }
            catch (AccessDeniedException exc) {
                handler.accept(null);
            }
        }
    }

    public static void runTicketSearchFromText(String text, Consumer<SearchResult<Integer>> handler) {
        Matcher m = SEARCH_PATTERN.matcher(text);
        if (m.find()) {
            String searchTerm = m.group(3);
            IndexSearchEngine<Integer> searchEngine = TicketManager.getReader().getSearchEngine();
            SearchCommand command = new TextSearchCommandBuilder(searchEngine, searchTerm).build();
            UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
            if (currentUserAccount != null) {
                SearchCommand searchCommand = new GlobalSearchViewDefinition().createSearchCommand(currentUserAccount.getID(), ClientLocale.getThreadLocale(), searchEngine);
                searchCommand.getSearchExpression().add((SearchExpression)command.getSearchExpression());
                searchCommand.setResultLimit(5);
                if (searchCommand.getSearchExpression().size() == 0 && "*".equals(searchTerm)) {
                    searchCommand.getSearchExpression().add((SearchExpression)new SearchCondition("statusid", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
                }
                SearchResult results = searchEngine.search(searchCommand);
                handler.accept((SearchResult<Integer>)results);
            } else {
                handler.accept((SearchResult<Integer>)new SearchResult(new ArrayList(), false));
            }
        }
    }

    public static void postTicketToFormatter(@Nullable TicketVO ticket, @Nonnull BotResponseFormatter botResponseFormatter) {
        if (ticket == null) {
            botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("bot.unknownticket", new Object[0]));
        } else {
            String subject = ticket.getSubject();
            int priorityID = ticket.getPriorityID();
            int statusID = ticket.getStatusID();
            PriorityVO prioVO = (PriorityVO)PriorityManager.getInstance().get(priorityID);
            String prio = prioVO.getDisplayValue();
            StatusVO statusVO = (StatusVO)StatusManager.getInstance().get(statusID);
            String status = statusVO.getDisplayValue();
            String date = DateTimeUtils.dateTimeToShortFormat(ticket.getLastChanged());
            String baseURL = (String)EXTERNAL_URL.get();
            if (baseURL.endsWith("/")) {
                baseURL = baseURL.substring(0, baseURL.length() - 1);
            }
            String ticketURL = baseURL + "/ticketlist/ticket/" + ticket.getID();
            ArrayList<BotResponseFormatter.BotResponseField> list = new ArrayList<BotResponseFormatter.BotResponseField>();
            list.add(TicketBotUtils.dataField("bot.fieldlabel.subject", subject));
            list.add(TicketBotUtils.dataField("bot.fieldlabel.status", status));
            list.add(TicketBotUtils.dataField("bot.fieldlabel.priority", prio));
            list.add(TicketBotUtils.dataField("bot.fieldlabel.lastchanged", date));
            list.add(new BotResponseFormatter.BotResponseField(HelpdeskServerPlugin.MSG_SERVER.getMsg("bot.fieldlabel.link", new Object[0]), (BotResponseFormatter.BotResponseValue)new BotResponseFormatter.BotResponseLinkValueImpl(HelpdeskServerPlugin.MSG_SERVER.getMsg("bot.fieldlabel.gototicket", new Object[0]), ticketURL)));
            botResponseFormatter.formatResponse(subject + " (#" + ticket.getID() + ")", ticketURL, list);
        }
    }

    private static BotResponseFormatter.BotResponseField dataField(String key, String value) {
        return new BotResponseFormatter.BotResponseField(HelpdeskServerPlugin.MSG_SERVER.getMsg(key, new Object[0]), () -> value);
    }
}

