/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.model;

import com.inet.dbupdater.databases.DatabaseInfoFactory;
import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.model.DiffComparator;
import com.inet.dbupdater.model.IModelComparator;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.sql.Connection;
import java.sql.SQLException;

public class Diff {
    public static final String REMOVED = "#removed#";
    private Node root;
    private Node sourceModel;
    private Node targetModel;
    private String targetDBMS = null;
    private final DatabaseInfos sourceInfos;
    private final DatabaseInfos targetInfos;
    private final IModelComparator comparator;

    public Diff(Node source, Node target) {
        this.sourceInfos = null;
        this.targetInfos = null;
        if (target == null) {
            throw new IllegalArgumentException("Cannot start a database diff without a target state!");
        }
        this.sourceModel = source;
        this.targetModel = target;
        this.comparator = new DiffComparator();
    }

    public Diff(Node source, Node target, DatabaseInfos sourceInfo, DatabaseInfos targetInfos, String targetDBMS) {
        this(source, target, sourceInfo, targetInfos, targetDBMS, new DiffComparator());
    }

    public Diff(Node source, Node target, DatabaseInfos sourceInfo, DatabaseInfos targetInfos, String targetDBMS, IModelComparator comparator) {
        this.sourceInfos = sourceInfo;
        this.targetInfos = targetInfos;
        if (target == null) {
            throw new IllegalArgumentException("Cannot start a database diff without a target state!");
        }
        this.sourceModel = source;
        this.targetModel = target;
        this.targetDBMS = targetDBMS;
        this.comparator = comparator;
    }

    public Node run() {
        if (this.prepare()) {
            return this.root;
        }
        return this.comparator.compare(this.sourceModel, this.targetModel, this.sourceInfos, this.targetInfos);
    }

    private boolean prepare() {
        if (this.targetModel == null) {
            this.root = this.sourceModel.createEmptyClone();
            return true;
        }
        NodeFactory.TAG tName = this.targetModel.getName();
        if (tName != NodeFactory.TAG.database && tName != NodeFactory.TAG.dbupdater) {
            throw new IllegalArgumentException("The diff operation requires a dbupdater- or a database-element as diff root");
        }
        if (this.sourceModel == null) {
            Node newTarget = this.targetModel;
            if (tName != NodeFactory.TAG.database) {
                newTarget = this.targetModel.findChildMatching(this.targetDBMS, NodeFactory.TAG.database);
                if (newTarget == null) {
                    newTarget = Diff.findDatabaseByType(this.targetModel, this.targetInfos);
                }
                if (newTarget == null) {
                    throw new IllegalArgumentException("The diff operation could not find a valid target state");
                }
            }
            this.root = newTarget.replicate(0);
            return true;
        }
        NodeFactory.TAG sName = this.sourceModel.getName();
        if (sName != NodeFactory.TAG.database && sName != NodeFactory.TAG.dbupdater) {
            throw new IllegalArgumentException("The diff operation requires a dbupdater- or a database-element as diff root");
        }
        if (sName == NodeFactory.TAG.dbupdater) {
            Node newSource = this.sourceModel.findChildMatching(this.targetDBMS, NodeFactory.TAG.database);
            if (newSource == null) {
                newSource = Diff.findDatabaseByType(this.sourceModel, this.sourceInfos);
            }
            if (newSource == null) {
                throw new IllegalArgumentException("The diff operation could not find a valid source state");
            }
            this.sourceModel = newSource;
        }
        String databaseKey = this.sourceModel.getKeyParamNames()[0];
        String sourceDBMS = this.sourceModel.getParameter(databaseKey);
        if (tName == NodeFactory.TAG.dbupdater) {
            Node newTarget;
            if (sourceDBMS == null || this.targetDBMS != null) {
                sourceDBMS = this.targetDBMS;
            }
            if ((newTarget = this.targetModel.findChildMatching(sourceDBMS, NodeFactory.TAG.database)) == null) {
                newTarget = Diff.findDatabaseByType(this.targetModel, this.targetInfos);
            }
            if (newTarget == null) {
                throw new IllegalArgumentException("The diff operation could not find a valid target state");
            }
            this.targetModel = newTarget;
        } else if (tName != NodeFactory.TAG.database && DatabaseInfoFactory.getDatabaseType(sourceDBMS) != DatabaseInfoFactory.getDatabaseType(this.targetModel.getParameter(databaseKey))) {
            throw new IllegalArgumentException("There is no valid target model for the DBMS type '" + sourceDBMS + "'");
        }
        return false;
    }

    public static Node findDatabaseByType(Node rootNode, DatabaseInfos dbInfos) {
        if (rootNode == null || dbInfos == null) {
            return null;
        }
        Connection connection = dbInfos.getDBConnection().getConnection();
        if (connection == null) {
            return null;
        }
        try {
            int type = DatabaseInfoFactory.getDatabaseType(connection);
            for (Node node : rootNode.getAllChildren()) {
                int nodeType;
                String name = node.getParameter("productname");
                if (name == null || (nodeType = DatabaseInfoFactory.getDatabaseType(name)) != type) continue;
                return node;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }
}

