/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultCreateDatabaseCommand;
import com.inet.dbupdater.model.Node;
import java.sql.SQLException;

public class MySQLCreateDatabaseCommand
extends DefaultCreateDatabaseCommand {
    private static final char[] INVALID_CHARS = new char[]{'.', '/', '\\', '\u0000'};

    public MySQLCreateDatabaseCommand(DatabaseInfos dbInfo, Node databaseNode) {
        super(dbInfo, databaseNode);
        String dbName = dbInfo.getDBConnection().getDatabaseName();
        for (char c : INVALID_CHARS) {
            int index = dbName.indexOf(c);
            if (index < 0) continue;
            throw new IllegalArgumentException("Illegal character '" + c + "' at index " + index + " in database name '" + dbName + "'");
        }
    }

    @Override
    protected void createDBUser(DatabaseInfos dbInfo, String accountUser, String accountPassword) throws SQLException {
        try {
            dbInfo.getDBConnection().executeUpdate(String.format("CREATE USER '%s'@'localhost' IDENTIFIED BY '%s'", accountUser, accountPassword));
            dbInfo.getDBConnection().executeUpdate(String.format("CREATE USER '%s'@'%%' IDENTIFIED BY '%s'", accountUser, accountPassword));
        }
        catch (SQLException ex) {
            if (ex.getMessage().contains("CREATE USER failed") || ex.toString().contains("CREATE USER failed") || ex.getCause() != null && ex.getCause().getMessage().contains("CREATE USER failed")) {
                logger.debug((Object)String.format("Login %s already exist - no problem, but if the password is different, then you cannot connect after update.", accountUser));
            }
            throw ex;
        }
        String dbName = dbInfo.getDBConnection().getDatabaseName();
        dbInfo.getDBConnection().executeUpdate(String.format("GRANT ALL PRIVILEGES ON %s.* TO '%s'@'localhost'", dbName, accountUser));
        dbInfo.getDBConnection().executeUpdate(String.format("GRANT ALL PRIVILEGES ON %s.* TO '%s'@'%%'", dbName, accountUser));
        dbInfo.getDBConnection().execute("FLUSH PRIVILEGES");
    }
}

