/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.model.Node;
import com.inet.logging.LogManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public interface IComposedCommand
extends IDatabaseCommand {
    public static final String PRIMARY_KEY = "PRIMARY";

    public List<IComposedCommand> addDataset(Node var1, ICommandFactory.COMMAND_TYPE var2) throws SQLException;

    public boolean accepts(Node var1, ICommandFactory.COMMAND_TYPE var2);

    public static List<IComposedCommand> createCommandList(IComposedCommand baseCommand, Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        List<IComposedCommand> subCommands;
        ArrayList<IComposedCommand> commands = new ArrayList<IComposedCommand>();
        commands.add(baseCommand);
        if (element != null && action != null && (subCommands = baseCommand.addDataset(element, action)) != null) {
            commands.addAll(subCommands);
        }
        return commands;
    }

    public static List<IComposedCommand> addToList(List<IComposedCommand> listToAddTo, List<IComposedCommand> listToAdd) {
        if (listToAdd != null) {
            listToAddTo.addAll(listToAdd);
        }
        return listToAddTo;
    }

    default public String getCommandKey() {
        String sql = null;
        try {
            sql = this.getSqlStatement();
        }
        catch (Exception e) {
            LogManager.getLogger((String)"DB Updater").debug((Object)e);
        }
        if (sql != null && !sql.isEmpty()) {
            return sql.toLowerCase();
        }
        return this.getClass().getName() + System.identityHashCode(this);
    }

    default public boolean isFutile() {
        return false;
    }
}

