/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.model.AttributeMap;
import java.sql.SQLException;
import java.util.ArrayList;

public class DefaultInsertDataCommand
implements IDatabaseCommand {
    private DatabaseInfos dbInfo;
    private final String name;
    private ArrayList<String> cols = new ArrayList();
    private ArrayList<String> vals = new ArrayList();

    public DefaultInsertDataCommand(DatabaseInfos dbInfo, String tableName) {
        this.name = tableName;
        this.dbInfo = dbInfo;
    }

    public void addColumn(AttributeMap<String> attributes, Object value) throws SQLException {
        this.cols.add(attributes.get(IDatabaseInfos.COLUMN_PARAM.column_name.name()));
        int type = Integer.parseInt(attributes.get(IDatabaseInfos.COLUMN_PARAM.data_type.name()));
        if (value == null) {
            this.vals.add("NULL");
        } else if (this.dbInfo.isQuoteableDataType(type)) {
            this.vals.add("'" + value.toString().replace("'", "''") + "'");
        } else {
            this.vals.add(value.toString());
        }
    }

    private String createStatement() {
        int i;
        StringBuilder b = new StringBuilder();
        b.append("INSERT INTO ");
        b.append(this.name);
        b.append(" (");
        for (i = 0; i < this.cols.size(); ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.cols.get(i));
        }
        b.append(") VALUES ( ");
        for (i = 0; i < this.vals.size(); ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.vals.get(i));
        }
        b.append(");");
        return b.toString();
    }

    @Override
    public int execute() throws SQLException {
        return this.dbInfo.getDBConnection().executeUpdate(this.getSqlStatement());
    }

    @Override
    public String getSqlStatement() {
        return this.createStatement();
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.executescripts;
    }
}

