/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultCommandSyntax;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.databases.commands.ITableCommand;
import com.inet.dbupdater.model.AttributeMap;
import com.inet.dbupdater.model.ISchemaNode;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DefaultAlterColumnCommand
implements ITableCommand {
    private DatabaseInfos dbInfo;
    private final Node name;
    private DefaultCommandSyntax syntax;
    private final String prefix;
    private String firstSQL;

    public DefaultAlterColumnCommand(DatabaseInfos dbInfo, DefaultCommandSyntax syntax, Node tableName) {
        this.name = tableName;
        this.dbInfo = dbInfo;
        this.syntax = syntax;
        this.prefix = "ALTER TABLE " + ((ISchemaNode)((Object)this.name)).getSourceName(dbInfo) + " ";
    }

    @Override
    public int execute() throws SQLException {
        return this.dbInfo.getDBConnection().executeUpdate(this.getSqlStatement());
    }

    @Override
    public String getSqlStatement() {
        return this.firstSQL;
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        if (action != ICommandFactory.COMMAND_TYPE.alter) {
            return false;
        }
        NodeFactory.TAG type = element.getName();
        return type == NodeFactory.TAG.column;
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.alterstructure;
    }

    private void addCommand(List<IComposedCommand> commands, String command) {
        if (this.firstSQL == null) {
            this.firstSQL = command;
        } else {
            commands.add(this.dbInfo.getCommandFactory().getPresetCommand(command, true, IDatabaseCommand.TIME.alterstructure, false, true));
        }
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        AttributeMap<String> attributes = element.getAttributeMap();
        String name = attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.column_name);
        ArrayList<IComposedCommand> commands = new ArrayList<IComposedCommand>();
        if (name == null) {
            throw new IllegalStateException("Cannot alter an unnamed column in table '" + this.name + "'");
        }
        boolean typeChanged = false;
        for (Object key : attributes.keySet()) {
            try {
                key = IDatabaseInfos.COLUMN_PARAM.valueOf(key.toString().toLowerCase());
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            if (key == IDatabaseInfos.COLUMN_PARAM.column_name) continue;
            String value = attributes.get(key);
            StringBuilder b = new StringBuilder();
            b.append(this.prefix).append("ALTER COLUMN ").append(this.dbInfo.getQuote(name));
            if (key == IDatabaseInfos.COLUMN_PARAM.column_size || key == IDatabaseInfos.COLUMN_PARAM.data_type || key == IDatabaseInfos.COLUMN_PARAM.decimal_digits || key == IDatabaseInfos.COLUMN_PARAM.isautoincrement || key == IDatabaseInfos.COLUMN_PARAM.type_name) {
                if (typeChanged) continue;
                typeChanged = true;
                Node target = element.getDiffTarget();
                if (target == null) {
                    target = element;
                }
                b.append(" TYPE ").append(this.syntax.getTypeString(target));
                this.addCommand(commands, b.toString());
                continue;
            }
            if (key == IDatabaseInfos.COLUMN_PARAM.column_def) {
                String typeString = element.getRecentValue(IDatabaseInfos.COLUMN_PARAM.data_type.name());
                int typeInt = Integer.parseInt(typeString.toString());
                b.append((String)(value == null ? " DROP DEFAULT" : " SET DEFAULT " + this.dbInfo.getQuotedValue(attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.column_def), typeInt)));
                this.addCommand(commands, b.toString());
            }
            if (key != IDatabaseInfos.COLUMN_PARAM.isnotnullable) continue;
            b.append(value == null || value.equals("false") ? " DROP NOT NULL" : " SET NOT NULL");
            this.addCommand(commands, b.toString());
        }
        return commands.size() > 0 ? commands : null;
    }
}

