/*
 * Decompiled with CFR 0.152.
 */
package srv.orderlistcache.cache;

import com.inet.helpdesk.shared.rpc.QueryParameter;
import java.io.Serializable;
import java.util.Arrays;
import srv.controller.ticket.Auftrag;

public class QueryCacheKey
implements Serializable {
    private String commandName;
    private Parameter[] parameters;
    private int hashCode;

    public QueryCacheKey(String commandName, Parameter ... parameters) {
        this.commandName = commandName;
        this.parameters = parameters;
        this.hashCode = commandName.hashCode();
        if (parameters != null) {
            for (Parameter param : parameters) {
                this.hashCode += param.key != null ? param.key.hashCode() : 0;
                this.hashCode += param.values != null ? Arrays.hashCode(param.values) : 0;
            }
        }
    }

    public String getCommandName() {
        return this.commandName;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QueryCacheKey)) {
            return false;
        }
        QueryCacheKey other = (QueryCacheKey)obj;
        if (!this.commandName.equals(other.commandName)) {
            return false;
        }
        if (this.parameters != null) {
            if (other.parameters == null || other.parameters.length != this.parameters.length) {
                return false;
            }
            for (int i = 0; i < this.parameters.length; ++i) {
                Parameter p1 = this.parameters[i];
                Parameter p2 = other.parameters[i];
                if (p1.key != null ? !p1.key.equals((Object)p2.key) : p2.key != null) {
                    return false;
                }
                if (Arrays.equals(p1.values, p2.values)) continue;
                return false;
            }
        } else if (other.parameters != null) {
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.getClass().getSimpleName());
        b.append(" '").append(this.commandName).append("' for ");
        if (this.parameters == null || this.parameters.length == 0) {
            b.append("any dataset");
        } else {
            boolean appendAnd = false;
            for (Parameter p : this.parameters) {
                if (appendAnd) {
                    b.append(" and ");
                }
                appendAnd = true;
                b.append(p.toString());
            }
        }
        return b.toString();
    }

    public static class Parameter
    extends QueryParameter {
        private transient Auftrag.Field key;
        private transient Serializable[] values;
        private transient boolean isNumeric;

        public Parameter(QueryParameter origParam) {
            super(origParam.getKey(), origParam.isNumeric(), origParam.getValues());
            this.key = Auftrag.Field.findField(origParam.getKey());
            boolean bl = this.isNumeric = this.key.isNumeric() || origParam.isNumeric();
            if (this.isNumeric) {
                String[] origValues = origParam.getValues();
                if (origValues != null) {
                    this.values = new Serializable[origValues.length];
                    for (int i = 0; i < this.values.length; ++i) {
                        this.values[i] = Integer.valueOf(origValues[i]);
                    }
                }
            } else {
                this.values = origParam.getValues();
            }
        }

        @Override
        public boolean isNumeric() {
            return this.isNumeric;
        }

        public Auftrag.Field getKeyField() {
            return this.key;
        }

        public Serializable[] getConvertedValues() {
            return this.values;
        }
    }
}

