/*
 * Decompiled with CFR 0.152.
 */
package srv.mail;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.shared.util.TypespecificIntMap;
import com.inet.helpdesk.usersandgroups.groups.IHelpDeskUserGroupManager;
import com.inet.id.GUID;
import com.inet.notification.Notification;
import com.inet.notification.NotificationManager;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.util.HashSet;
import srv.controller.UserMessage;
import srv.controller.UserSession;

public class MailErrorHandler {
    public MailErrorHandler(String account, String errorMessage, TypespecificIntMap<UserSession> connectedSwingClients, int resID) {
        String message = "Could not read E-Mail in account \"" + account + "\"\nCopy messsage to folder HD Error Messages\n" + errorMessage;
        HashSet accessors = new HashSet();
        if (resID > 0) {
            HDLogger.debug("fetching users in resource " + resID + " plus any admins + supporters...");
            IHelpDeskUserGroupManager manager = (IHelpDeskUserGroupManager)UserGroupManager.getInstance();
            UserGroupInfo resource = manager.getUserGroupInfoForResourceId(resID);
            if (resource != null) {
                accessors.addAll(resource.getMemberIDs());
            } else {
                HDLogger.error("resource " + resID + " is unknown!");
            }
            accessors.addAll(SystemPermissionChecker.getAllUsersWithAnyPermission((Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ_WRITE, Permission.CONFIGURATION}));
        } else {
            HDLogger.debug("fetching admin and dispatcher users...");
            accessors.addAll(SystemPermissionChecker.getAllUsersWithAnyPermission((Permission[])new Permission[]{HdPermissions.DISPATCHER, Permission.CONFIGURATION}));
        }
        for (Object allSessionKey : (IHelpDeskUserGroupManager)connectedSwingClients.getAllKeys()) {
            UserSession session = connectedSwingClients.get((int)allSessionKey);
            if (session == null || session.isClosed() || !accessors.contains(session.getOwner().getID())) continue;
            session.addMessage(new UserMessage("E-Mail Error!", message));
        }
        HDLogger.debug("about to notify the following users of an error: " + accessors);
        NotificationManager notiMan = NotificationManager.getInstance();
        Notification notification = new Notification("E-Mail Error!", message);
        notification.setCritical(true);
        for (GUID guid : accessors) {
            notiMan.sendNotification(guid, notification);
        }
    }
}

