/*
 * Decompiled with CFR 0.152.
 */
package srv.mail;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.TicketDataConnector;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.UserModelConverter;
import com.inet.usersandgroups.api.user.UserAccount;
import javax.annotation.Nullable;
import srv.ServerUtilities;
import srv.mail.Mail;

public class AutoMailSender {
    private static final ConfigValue<Boolean> MAIL_AUTORISIERUNG_USER = new ConfigValue(HDConfigKeys.MAIL_AUTORISIERUNG_USER);
    private static final ConfigValue<Boolean> MAIL_BEENDEN_USER = new ConfigValue(HDConfigKeys.MAIL_BEENDEN_USER);

    public static void sendIfNeeded(int ticketID, int mailType, @Nullable UserAccount producer) {
        String producerEmail = AutoMailSender.getEmailFrom(producer);
        AutoMailSender.sendIfNeeded(ticketID, mailType, producerEmail);
    }

    public static void sendIfNeeded(int ticketID, int mailType, @Nullable String producerEmail) {
        if (mailType > 0) {
            Mail.send(mailType, ticketID, producerEmail);
        }
    }

    public static void sendAutoMailAndNotifyResourceIfNeeded(int ticketID, int mailType, @Nullable UserAccount producer) {
        String producerEmail = AutoMailSender.getEmailFrom(producer);
        AutoMailSender.sendIfNeeded(ticketID, mailType, producerEmail);
        int producerID = HDUsersAndGroups.getUserID(producer);
        ServerUtilities.getOpenOrderController().notifyResourceIfNeeded(ticketID, mailType, producerID);
    }

    @Nullable
    public static String getEmailFrom(@Nullable UserAccount account) {
        String[] allEmails;
        if (account != null && (allEmails = UserModelConverter.getEmailAddresses(account)).length > 0) {
            return allEmails[0];
        }
        return null;
    }

    public static int getMailType(TicketDataConnector.MailNotification mailNotification, int actionID, boolean actionIsOpenToClosedTransition, boolean actionResultsInClosedTicket) {
        if (mailNotification == TicketDataConnector.MailNotification.NEVER) {
            return 0;
        }
        switch (actionID) {
            case -14: {
                return 0;
            }
            case 5: {
                if (mailNotification == TicketDataConnector.MailNotification.ALWAYS) {
                    boolean mailAutorisierungUser = (Boolean)MAIL_AUTORISIERUNG_USER.get();
                    return mailAutorisierungUser ? 2 : 14;
                }
                return 2;
            }
            case -23: 
            case -12: 
            case -11: 
            case -9: 
            case -2: {
                return 10;
            }
            case 6: {
                return 1;
            }
            case 8: {
                if (actionResultsInClosedTicket) {
                    return 0;
                }
                return 3;
            }
            case 4: {
                return 6;
            }
        }
        if (actionIsOpenToClosedTransition) {
            if (mailNotification == TicketDataConnector.MailNotification.ALWAYS) {
                boolean mailBeendenUser = (Boolean)MAIL_BEENDEN_USER.get();
                return mailBeendenUser ? 4 : 16;
            }
            return 4;
        }
        return 0;
    }
}

