/*
 * Decompiled with CFR 0.152.
 */
package srv.controller.ticket.timeline;

import java.util.ArrayList;
import srv.controller.ticket.timeline.TimelineDataHandlerImpl;
import srv.controller.ticket.timeline.TimelineJob;

public class TimelineJobExecuter
implements Runnable {
    private static final TimelineJobExecuter INSTANCE = new TimelineJobExecuter();
    private ArrayList<TimelineJob> jobs = new ArrayList();
    private boolean isRunning;
    private long wait_time_until_next_job;

    public static TimelineJobExecuter getInstance() {
        return INSTANCE;
    }

    private TimelineJobExecuter() {
    }

    public synchronized void addJob(TimelineJob job) {
        for (TimelineJob compare : this.jobs) {
            if (!job.equals(compare)) continue;
            this.jobs.remove(compare);
            TimelineDataHandlerImpl.LOGGER.debug((Object)("Job already in queue " + job));
            break;
        }
        this.jobs.add(job);
        TimelineDataHandlerImpl.LOGGER.debug((Object)("New job for execution " + job));
        if (!this.isRunning) {
            try {
                Thread th = new Thread((Runnable)this, "Timeline executer");
                TimelineDataHandlerImpl.LOGGER.debug((Object)"New Timeline executer Thread");
                th.start();
                this.isRunning = true;
            }
            catch (Exception e) {
                TimelineDataHandlerImpl.LOGGER.error((Object)e);
            }
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            TimelineJob job;
            TimelineJobExecuter timelineJobExecuter = this;
            synchronized (timelineJobExecuter) {
                while ((job = this.getMostUrgentJob()) == null) {
                    try {
                        this.wait(this.wait_time_until_next_job);
                    }
                    catch (Exception e) {
                        TimelineDataHandlerImpl.LOGGER.error((Object)e);
                    }
                }
            }
            try {
                job.execute();
                continue;
            }
            catch (Exception e) {
                TimelineDataHandlerImpl.LOGGER.error((Object)e);
                continue;
            }
            break;
        }
    }

    private synchronized TimelineJob getMostUrgentJob() {
        while (this.jobs.size() > 0) {
            TimelineJob mostUrgent = null;
            for (int i = 0; i < this.jobs.size(); ++i) {
                TimelineJob aJob = this.jobs.get(i);
                if (mostUrgent != null && mostUrgent.getExecutionTime() <= aJob.getExecutionTime()) continue;
                mostUrgent = aJob;
            }
            long timeToExecute = mostUrgent.getExecutionTime() - System.currentTimeMillis();
            if (timeToExecute <= 0L) {
                this.jobs.remove(mostUrgent);
                if (!mostUrgent.stillValid(true)) {
                    TimelineDataHandlerImpl.LOGGER.debug((Object)("Invalid job removed from queue " + mostUrgent));
                    continue;
                }
                TimelineDataHandlerImpl.LOGGER.debug((Object)("Job execution " + mostUrgent));
                return mostUrgent;
            }
            this.wait_time_until_next_job = timeToExecute;
            TimelineDataHandlerImpl.LOGGER.debug((Object)("Wait until next job:" + timeToExecute));
            return null;
        }
        TimelineDataHandlerImpl.LOGGER.debug((Object)"sleep until next job");
        this.wait_time_until_next_job = 100000000L;
        return null;
    }
}

