/*
 * Decompiled with CFR 0.152.
 */
package srv.controller.ticket;

import java.sql.SQLException;
import java.util.ArrayList;
import srv.controller.OpenOrderController;
import srv.controller.ticket.Auftrag;
import srv.controller.ticket.AuftragsReferenz;

public class AuftragWithReferences
extends Auftrag {
    private AuftragsReferenz firstReferenz;

    public AuftragWithReferences(OpenOrderController controlleti, int id) {
        super(controlleti, id);
        if (controlleti != null) {
            this.updateVersionToLastChanged(true);
        }
    }

    public AuftragsReferenz getFirstReferenz() {
        return this.firstReferenz;
    }

    public void removeReferenz() {
        this.firstReferenz = null;
    }

    public ArrayList<AuftragsReferenz> getSubOrderReferences() {
        ArrayList<AuftragsReferenz> subOrderRefs = null;
        for (AuftragsReferenz ref = this.firstReferenz; ref != null; ref = ref.getNextRef()) {
            if (subOrderRefs == null) {
                subOrderRefs = new ArrayList<AuftragsReferenz>();
            }
            if ((ref.getType() & 1) <= 0) continue;
            subOrderRefs.add(ref);
        }
        return subOrderRefs;
    }

    @Override
    protected void onCheck() {
        if (this.firstReferenz != null) {
            this.postWfChangeMessage(this.firstReferenz, this.getVersion(), true);
        }
    }

    @Override
    protected void onSetStatus() {
        if (this.firstReferenz != null) {
            this.postWfChangeMessage(this.firstReferenz, this.getVersion(), true);
        }
    }

    public void removeReferenz(AuftragsReferenz ref, int currentVersion) {
        if ((ref.getType() & 2) > 0) {
            this.postWfChangeMessage(ref, currentVersion, false);
        }
        ref.setAuf(null);
        if (ref == this.firstReferenz) {
            this.firstReferenz = this.firstReferenz.getNextRef();
        } else {
            AuftragsReferenz start;
            for (start = this.firstReferenz; start != null && start.getNextRef() != ref; start = start.getNextRef()) {
            }
            if (start != null && start.getNextRef() == ref) {
                start.setNextRef(ref.getNextRef());
                ref.setNextRef(null);
            }
        }
    }

    public void addReferenz(AuftragsReferenz ref, int currentVersion) throws SQLException {
        if (ref.getAuf() != this) {
            AuftragsReferenz start;
            if (ref.getAuf() != null) {
                ref.getAuf().removeReferenz(ref, currentVersion);
            }
            if (this.firstReferenz == null) {
                for (start = ref; start != null; start = start.getNextRef()) {
                    if (start != this.firstReferenz) continue;
                    throw new SQLException("Zikular Referenz " + this.getOrderID() + " <-> " + ref.getRefObj());
                }
                this.firstReferenz = ref;
            } else {
                for (start = this.firstReferenz; start != null; start = start.getNextRef()) {
                    if (start == ref) {
                        return;
                    }
                    for (AuftragsReferenz testRef = start.getNextRef(); testRef != null; testRef = testRef.getNextRef()) {
                        if (testRef != start) continue;
                        throw new SQLException("Zikular Referenz " + this.getOrderID() + " <-> " + ref.getRefObj());
                    }
                }
                start = this.firstReferenz;
                while (start.getNextRef() != null) {
                    start = start.getNextRef();
                }
                start.setNextRef(ref);
            }
            for (AuftragsReferenz someRef = ref; someRef != null; someRef = someRef.getNextRef()) {
                someRef.setAuf(this);
                if ((someRef.getType() & 2) <= 0) continue;
                this.postWfChangeMessage(ref, currentVersion, false);
            }
        }
    }

    private void postWfChangeMessage(AuftragsReferenz start, int currentVersion, boolean following) {
        while (start != null) {
            if ((start.getType() & 2) > 0 && start.getWorkflow() != null) {
                start.getWorkflow().checkRowChanges(start.getReferencedTicketId(), currentVersion);
            }
            if (!following) {
                return;
            }
            start = start.getNextRef();
        }
    }
}

