/*
 * Decompiled with CFR 0.152.
 */
package srv.controller;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManipulatorBackdoor;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import srv.ServerUtilities;
import srv.controller.OpenOrderController;
import srv.controller.ticket.AuftragsReferenz;
import srv.controller.ticket.attributes.ResourceAdditionalData;
import srv.mail.AutoMailSender;

public class WorkFlow {
    private static final Integer nichts = new Integer(0);
    private static final String wfName = "wf.-";
    private int hauptAuftrag;
    private int hauptStatus;
    private int hauptRes;
    private String bezeichnung;
    private WorkFlowStep[] mySteps;
    private int stepCount = 0;
    private int version;
    private Object[] data = null;
    private boolean inCheck = false;

    public WorkFlow(int id, String name, int statH, int resH, int vers) {
        this.bezeichnung = name;
        this.hauptAuftrag = id;
        this.hauptStatus = statH;
        this.hauptRes = resH;
        this.mySteps = new WorkFlowStep[2];
        this.version = vers;
        AuftragsReferenz mainReferenz = OpenOrderController.getReferenzObject(this.hauptAuftrag, 2);
        mainReferenz.setWorkflow(this);
        mainReferenz.setRefObj(this);
    }

    public void destroy() {
        for (int i = 0; i < this.stepCount; ++i) {
            this.mySteps[i].ref.setWorkflow(null);
            this.mySteps[i].ref.setRefObj(new Integer(this.hauptAuftrag));
            OpenOrderController.removeReferenz(this.mySteps[i].aufNr, 2);
        }
        AuftragsReferenz mainReferenz = OpenOrderController.getReferenzObject(this.hauptAuftrag, 2);
        mainReferenz.setWorkflow(null);
        mainReferenz.setRefObj(new Integer(this.hauptAuftrag));
        OpenOrderController.removeReferenz(this.hauptAuftrag, 2);
        this.stepCount = 0;
        this.mySteps = null;
    }

    protected synchronized void setData(int step, int resID, int status, long defaultAuth, int vers) {
        if (this.inCheck) {
            return;
        }
        this.version = vers;
        if (step == this.hauptAuftrag) {
            this.hauptStatus = status;
            this.hauptRes = resID;
            return;
        }
        WorkFlowStep row = this.getRow(step);
        if (row == null) {
            return;
        }
        row.latest = defaultAuth;
        row.status = status;
        row.resID = resID;
    }

    protected Object[] getData() {
        if (this.data == null) {
            this.data = new Object[8];
            this.data[0] = wfName;
            this.data[1] = "#" + this.hauptAuftrag + "  " + this.bezeichnung;
            this.data[2] = nichts;
            this.data[3] = new Integer(this.hauptAuftrag);
            this.data[4] = new Integer(this.stepCount);
            this.data[5] = nichts;
        }
        this.data[6] = (long)this.version;
        this.data[7] = nichts;
        return this.data;
    }

    protected boolean canGet(int[] resourcen) {
        if (this.stepCount == 0) {
            return false;
        }
        if (resourcen == null || this.checkID(resourcen, this.hauptRes)) {
            return true;
        }
        for (int i = 0; i < this.stepCount; ++i) {
            if (this.mySteps[i].status >= 300 || !this.checkID(resourcen, this.mySteps[i].resID)) continue;
            return true;
        }
        return false;
    }

    private boolean checkID(int[] resourcen, int idx) {
        for (int element : resourcen) {
            if (element != idx) continue;
            return true;
        }
        return false;
    }

    protected void addRow(int idx, int prev1, int prev2, long defaultAuth, int resID, int priID, int status) {
        this.mySteps[this.stepCount] = new WorkFlowStep(idx, prev1, prev2, defaultAuth, resID, priID, status);
        this.mySteps[this.stepCount].ref = OpenOrderController.getReferenzObject(idx, 2);
        this.mySteps[this.stepCount].ref.setRefObj(this.mySteps[this.stepCount]);
        this.mySteps[this.stepCount].ref.setWorkflow(this);
        ++this.stepCount;
        if (this.stepCount == this.mySteps.length) {
            WorkFlowStep[] newSteps = new WorkFlowStep[this.mySteps.length * 2];
            System.arraycopy(this.mySteps, 0, newSteps, 0, this.mySteps.length);
            this.mySteps = newSteps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check(Connection con) {
        if (this.inCheck) {
            return;
        }
        this.inCheck = true;
        Statement st = null;
        ResultSet rs = null;
        Statement pst = null;
        Timestamp zeitpunkt = null;
        try {
            boolean theEnd = false;
            if (this.hauptStatus > 299) {
                theEnd = true;
                for (int i = 0; i < this.stepCount; ++i) {
                    WorkFlowStep workFlowStep = this.mySteps[i];
                    if (workFlowStep.status >= 300) continue;
                    if (pst == null) {
                        pst = con.prepareStatement("UPDATE tblBuendel SET Status = 300, BearbeitungsDatum = ? WHERE BunID = ?");
                        pst.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                        st = con.createStatement(1005, 1008);
                        rs = st.executeQuery("SELECT * FROM tblRealisierung WHERE 1=0");
                        zeitpunkt = new Timestamp(System.currentTimeMillis());
                    }
                    Statement pstX = pst;
                    ResultSet rsX = rs;
                    Timestamp zeitpunktX = zeitpunkt;
                    TicketManipulatorBackdoor.getBackdoor().updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(workFlowStep.aufNr, true, () -> this.lambda$check$0((PreparedStatement)pstX, workFlowStep, con, rsX, zeitpunktX));
                    this.version = OpenOrderController.getCurrentVersion();
                }
            } else {
                int openOrderCount = 0;
                for (int i = 0; i < this.stepCount; ++i) {
                    int testStatus = 0;
                    WorkFlowStep workFlowStep = this.mySteps[i];
                    WorkFlowStep step1 = this.getRow(workFlowStep.prev1);
                    WorkFlowStep step2 = this.getRow(workFlowStep.prev2);
                    if (step1 != null || step2 != null || workFlowStep.status == -217) {
                        if (workFlowStep.latest < System.currentTimeMillis() && (workFlowStep.latest > 0L || step1 == null && step2 == null)) {
                            if (workFlowStep.status == -217) {
                                testStatus = 100;
                            }
                        } else if (step1 != null || step2 != null) {
                            testStatus = step1 != null && step1.status < 300 || step2 != null && step2.status < 300 ? -217 : 100;
                        }
                    }
                    if (testStatus == 100 && workFlowStep.status < 0 || testStatus == -217 && workFlowStep.status > 0) {
                        if (pst == null) {
                            pst = con.prepareStatement("UPDATE tblBuendel SET Status = ?, BearbeitungsDatum = ? WHERE BunID = (Select BunID From tblAuftraege Where AufID = ?)");
                            pst.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                            st = con.createStatement(1005, 1008);
                            rs = st.executeQuery("SELECT * FROM tblRealisierung WHERE 1=0");
                            zeitpunkt = new Timestamp(System.currentTimeMillis());
                        }
                        Statement pstX = pst;
                        ResultSet rsX = rs;
                        Timestamp zeitpunktX = zeitpunkt;
                        int testStatusX = testStatus;
                        TicketManipulatorBackdoor.getBackdoor().updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(workFlowStep.aufNr, () -> this.lambda$check$1((PreparedStatement)pstX, testStatusX, workFlowStep, con, rsX, zeitpunktX));
                        this.version = OpenOrderController.getCurrentVersion();
                        workFlowStep.status = testStatus;
                    }
                    if (workFlowStep.status >= 300) continue;
                    ++openOrderCount;
                }
                boolean bl = theEnd = openOrderCount == 0;
                if (theEnd) {
                    if (st == null) {
                        if (pst != null) {
                            try {
                                pst.close();
                            }
                            catch (Throwable i) {
                                // empty catch block
                            }
                        }
                        pst = con.prepareStatement("UPDATE tblBuendel SET Status = 300, BearbeitungsDatum = ? WHERE BunID = " + this.hauptAuftrag);
                        pst.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                        Statement pstFinal = pst;
                        TicketManipulatorBackdoor.getBackdoor().updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(this.hauptAuftrag, () -> WorkFlow.lambda$check$2((PreparedStatement)pstFinal));
                        st = con.createStatement(1005, 1008);
                        rs = st.executeQuery("SELECT * FROM tblRealisierung WHERE 1=0");
                        zeitpunkt = new Timestamp(System.currentTimeMillis());
                    }
                    ResultSet rsX = rs;
                    Timestamp zeitpunktX = zeitpunkt;
                    TicketManipulatorBackdoor.getBackdoor().updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(this.hauptAuftrag, () -> {
                        this.addRealisierung(con, rsX, this.hauptAuftrag, 2, "Beendet da Workflow-Teilauftr\u00e4ge abgeschlossen.", zeitpunktX);
                        int mailType = 4;
                        int producerID = -1;
                        String producerEmail = null;
                        AutoMailSender.sendIfNeeded(this.hauptAuftrag, mailType, producerEmail);
                        ServerUtilities.getOpenOrderController().notifyResourceIfNeeded(this.hauptAuftrag, mailType, producerID);
                        return null;
                    });
                    this.version = OpenOrderController.getCurrentVersion();
                }
            }
            if (theEnd) {
                if (st == null) {
                    st = con.createStatement();
                }
                st.execute("DELETE FROM tblWFaktiv WHERE HauptAuftrag = " + this.hauptAuftrag);
                this.destroy();
            }
        }
        catch (Throwable e) {
            HDLogger.error(e);
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (Throwable theEnd) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable theEnd) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Throwable theEnd) {}
            }
        }
        ServerUtilities.getOpenOrderController().realizeAllChanges();
        this.inCheck = false;
    }

    private WorkFlowStep getRow(int idx) {
        if (idx < 1) {
            return null;
        }
        for (int i = 0; i < this.stepCount; ++i) {
            if (this.mySteps[i].aufNr != idx) continue;
            return this.mySteps[i];
        }
        return null;
    }

    public static int getWfAufID(AuftragsReferenz ref) {
        if (ref.getWorkflow() != null) {
            return ref.getWorkflow().hauptAuftrag;
        }
        if (ref.getRefObj() instanceof Number) {
            return ((Number)ref.getRefObj()).intValue();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRowChanges(int changedAufId, int newVersion) {
        if (this.stepCount == 0) {
            return;
        }
        boolean significantChange = false;
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(changedAufId);
        UserGroupInfo res = UserGroupManager.getInstance().getGroup(ticket.getResourceID());
        if (res == null) {
            HDLogger.error(new Throwable("User Group representing resource with ID =\"" + ticket.getResourceID() + "\" could not be found."));
            return;
        }
        int resID = (Integer)res.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
        if (changedAufId == this.hauptAuftrag) {
            this.hauptRes = resID;
            this.hauptStatus = ticket.getStatusID();
            significantChange = this.hauptStatus > 299;
        } else {
            WorkFlowStep row = this.getRow(changedAufId);
            row.resID = resID;
            significantChange = row.status < 300 && ticket.getStatusID() > 299 || row.status > 299 && ticket.getStatusID() < 300;
            row.status = ticket.getStatusID();
        }
        if (significantChange) {
            Connection con = null;
            try {
                con = ((ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class)).getConnection();
                this.check(con);
            }
            catch (Throwable er) {
                HDLogger.error(er);
            }
            finally {
                try {
                    con.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.version = newVersion;
    }

    private void addRealisierung(Connection con, ResultSet rs, int id, int aktion, String wasText, Timestamp zeitpunkt) throws SQLException {
        int reaID = ServerUtilities.addRealisierung(con, rs, id, id, aktion, zeitpunkt, ServerUtilities.NULL_AS_USER_ID, "HelpDesk", null, null, null, null, 0, null, 0, wasText);
        if (aktion == 5) {
            String sql = "UPDATE tblAuftraege SET AutorisierenReaID = ? WHERE AufID = ?";
            try (PreparedStatement pstm = con.prepareStatement(sql);){
                pstm.setInt(1, reaID);
                pstm.setInt(2, id);
                pstm.executeUpdate();
            }
        }
    }

    public void setStepCount(int stepCount) {
        this.stepCount = stepCount;
    }

    private static /* synthetic */ Object lambda$check$2(PreparedStatement pstFinal) throws Exception {
        pstFinal.execute();
        return null;
    }

    private /* synthetic */ Object lambda$check$1(PreparedStatement pstX, int testStatusX, WorkFlowStep workFlowStep, Connection con, ResultSet rsX, Timestamp zeitpunktX) throws Exception {
        ResourceAdditionalData resource;
        pstX.setInt(1, testStatusX);
        pstX.setInt(3, workFlowStep.aufNr);
        pstX.execute();
        if (testStatusX == 100) {
            this.addRealisierung(con, rsX, workFlowStep.aufNr, 5, "Workflow-Teilauftrag autorisiert.", zeitpunktX);
            String id = String.valueOf(workFlowStep.aufNr);
            ServerUtilities.setDeadline(con, String.valueOf(workFlowStep.resID), id, id, String.valueOf(workFlowStep.priID), false);
        } else {
            this.addRealisierung(con, rsX, workFlowStep.aufNr, -8, "Workflow-Teilauftrag zur\u00fcck gesetzt.", zeitpunktX);
            String sql = "UPDATE tblAuftraege SET AutorisierenReaID = ? WHERE AufID = ?";
            try (PreparedStatement pstm = con.prepareStatement(sql);){
                pstm.setObject(1, null);
                pstm.setInt(2, workFlowStep.aufNr);
                pstm.executeUpdate();
            }
        }
        int producerID = -1;
        if (testStatusX == 100) {
            int mailType = 9;
            AutoMailSender.sendIfNeeded(workFlowStep.aufNr, mailType, (String)null);
            ServerUtilities.getOpenOrderController().notifyResourceIfNeeded(workFlowStep.aufNr, mailType, producerID);
        }
        if ((resource = ServerUtilities.getOpenOrderController().getResource(workFlowStep.resID)) != null) {
            resource.setBufferVersion(this.version);
        }
        return null;
    }

    private /* synthetic */ Object lambda$check$0(PreparedStatement pstX, WorkFlowStep workFlowStep, Connection con, ResultSet rsX, Timestamp zeitpunktX) throws Exception {
        ResourceAdditionalData resource;
        pstX.setInt(2, workFlowStep.aufNr);
        pstX.execute();
        if (workFlowStep.status > 99 && (resource = ServerUtilities.getOpenOrderController().getResource(workFlowStep.resID)) != null) {
            resource.setBufferVersion(this.version);
        }
        this.addRealisierung(con, rsX, workFlowStep.aufNr, 2, "Beendet da Workflow-Hauptauftrag abgeschlossen.", zeitpunktX);
        return null;
    }

    class WorkFlowStep {
        private int aufNr;
        private int resID;
        private int priID;
        private int prev1;
        private int prev2;
        private int status;
        private long latest;
        private AuftragsReferenz ref;

        WorkFlowStep(int myID, int prev1, int prev2, long defaultAuth, int resID, int priID, int status) {
            this.aufNr = myID;
            this.prev1 = prev1;
            this.prev2 = prev2;
            this.latest = defaultAuth;
            this.status = status;
            this.resID = resID;
            this.priID = priID;
        }
    }
}

