/*
 * Decompiled with CFR 0.152.
 */
package srv.controller;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.LocalizationBundle;
import com.inet.helpdesk.core.data.ResourceNotificationListener;
import com.inet.helpdesk.core.data.TranslationTextConnector;
import com.inet.helpdesk.core.model.general.Localization;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReaderForSystem;
import com.inet.helpdesk.core.ticketmanager.fields.Deletable;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.resource.ResourceManager;
import com.inet.helpdesk.core.ticketmanager.fields.resource.ResourceVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVOManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.TicketSearchFilterOptions;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.Status;
import com.inet.helpdesk.shared.util.TypespecificIntMap;
import com.inet.helpdesk.ticketmanager.adapt.OldApiAdapter;
import com.inet.helpdesk.usersandgroups.HDFieldLocator;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.IHelpDeskUserGroupManager;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.id.GUID;
import com.inet.logging.LogManager;
import com.inet.notification.Notification;
import com.inet.notification.NotificationManager;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import srv.ServerUtilities;
import srv.controller.Fetcher;
import srv.controller.UserSession;
import srv.controller.UserVersionManager;
import srv.controller.WorkFlow;
import srv.controller.ticket.Auftrag;
import srv.controller.ticket.AuftragWithReferences;
import srv.controller.ticket.AuftragsReferenz;
import srv.controller.ticket.attributes.ResourceAdditionalData;
import srv.controller.ticket.attributes.UserDefinedVO;
import srv.orderlistcache.OrderListCommandFactory;

public class OpenOrderController {
    private static final String ORDER_LIST_QUERY_WIEDERVORLAGE = "SELECT tblBuendel.*, tblAuftraege.AufID, tblAuftraege.UsrID, tblAuftraege.BetID, tblAuftraege.DerBetreff, tblAuftraege.DeadlineZeit, tblAuftraege.PriID, tblAuftraege.ResID, tblAuftraege.KlaID, tblAuftraege.ItiID, tblAuftraege.WFID, tblAuftraege.spezFeld, tblAuftraege.EmailEingang, tblAuftraege.AnfReaID, tblAuftraege.ItiCount, tblUser.UsrID as UserID, tblUser.Nachname, tblUser.Vorname, tblUser.Telefon, tblUser.GebID, tblUser.Abteilung, tblUser.Kostenstelle, tblUser.Frei1, tblUser.Frei2, tblUser.Frei3, tblUser.Frei4, tblUser.Frei5, tblUser.BgrID, tblUser.Computername FROM tblBuendel tblBuendel, tblAuftraege tblAuftraege LEFT OUTER JOIN tblUser tblUser ON tblAuftraege.UsrID = tblUser.UsrID WHERE (Status < 300 AND Status >= 0 AND Status <> 150) AND tblAuftraege.AutorisierenReaID is not null AND tblBuendel.BunID = tblAuftraege.BunID AND tblAuftraege.Master <> 0 %ResID%";
    private static final String ORDER_LIST_QUERY = "SELECT tblBuendel.*, tblAuftraege.AufID, tblAuftraege.UsrID, tblAuftraege.BetID, tblAuftraege.DerBetreff, tblAuftraege.DeadlineZeit, tblAuftraege.PriID, tblAuftraege.ResID, tblAuftraege.KlaID, tblAuftraege.ItiID, tblAuftraege.WFID, tblAuftraege.spezFeld, tblAuftraege.EmailEingang, tblAuftraege.AnfReaID, tblAuftraege.ItiCount, tblUser.UsrID as UserID, tblUser.Nachname, tblUser.Vorname, tblUser.Telefon, tblUser.GebID, tblUser.Abteilung, tblUser.Kostenstelle, tblUser.Frei1, tblUser.Frei2, tblUser.Frei3, tblUser.Frei4, tblUser.Frei5, tblUser.BgrID, tblUser.Computername FROM tblBuendel tblBuendel, tblAuftraege tblAuftraege LEFT OUTER JOIN tblUser tblUser ON tblAuftraege.UsrID = tblUser.UsrID WHERE (Status < 300 AND Status >= 0) AND tblAuftraege.AutorisierenReaID is not null AND tblBuendel.BunID = tblAuftraege.BunID AND tblAuftraege.Master <> 0 %ResID%";
    private static final int OPTION_WIEDERVORLAGE_HIDE = 0x20000000;
    private static int currentVersion = 0;
    private static boolean resubmissionHidden;
    private Map<Integer, ResourceAdditionalData> resourcesData;
    private ResourceManager resources;
    private PriorityManager prioritaet;
    private CategoryManager kategorien;
    private LocationManager location;
    private UserGroupVOManager userGroup;
    private static TypespecificIntMap<AuftragsReferenz> references;
    private static TypespecificIntMap<AuftragWithReferences> buendel;
    private static TypespecificIntMap<WorkFlow> workFlows;
    private TypespecificIntMap<Integer> BUENDEL_MSGFLAG = new TypespecificIntMap();
    private TypespecificIntMap<Integer> BUENDEL_VERSIONS = new TypespecificIntMap();
    private boolean nichtImScan = true;
    private boolean userViewField = false;
    private String queryAll;
    private String queryOne;
    private String queryJustResourceAndStatus;
    private String dbFeldLang;
    private String dbFeldKurz;
    private UserField<?> freiauswahlUserField;
    private final OrderListCommandFactory inquiryCacheController;
    private boolean isInInitResource;
    private static final TypespecificIntMap<Auftrag.Field> EXTERNAL_MODEL_MAPPING;
    private static final ConfigValue<Integer> CLIENT_START_OPTION;
    private static final ConfigValue<String> CLIENT_TREE_CONFIG;
    private static final ConfigValue<Boolean> EXTENDED_STATE_EVENTS;
    private static Map<Integer, Auftrag[]> msgMap;

    public OpenOrderController(OrderListCommandFactory inquiryCacheController) {
        this.inquiryCacheController = inquiryCacheController;
        resubmissionHidden = OpenOrderController.isResubmissionHidden();
        this.initQueriesAndSelectionField(true);
        this.resourcesData = new HashMap<Integer, ResourceAdditionalData>();
        this.prioritaet = PriorityManager.getInstance();
        this.kategorien = CategoryManager.getInstance();
        this.location = LocationManager.getInstance();
        this.userGroup = UserGroupVOManager.getInstance();
        this.resources = ResourceManager.getInstance();
    }

    private void initQueriesAndSelectionField(boolean initial) {
        this.dbFeldLang = (String)CLIENT_TREE_CONFIG.get();
        this.queryAll = "SELECT tblBuendel.BunID, tblBuendel.Status, tblBuendel.subAuftraege, tblAuftraege.ResID, tblAuftraege.WFID FROM tblBuendel, tblAuftraege WHERE tblBuendel.Status < 300 AND tblAuftraege.AutorisierenReaID is not null AND tblBuendel.BunID = tblAuftraege.BunID AND tblAuftraege.Master <> 0 AND tblBuendel.subAuftraege>0 UNION SELECT tblBuendel.BunID, tblBuendel.Status, tblBuendel.subAuftraege, tblAuftraege.ResID, tblAuftraege.WFID FROM tblBuendel, tblAuftraege WHERE tblBuendel.Status < 300 AND tblAuftraege.AutorisierenReaID is not null AND tblBuendel.BunID = tblAuftraege.BunID AND tblAuftraege.Master <> 0 AND tblAuftraege.WFID IS NOT NULL";
        this.queryOne = "SELECT tblBuendel.BunID, tblBuendel.Status, tblBuendel.subAuftraege, tblAuftraege.ResID, tblAuftraege.WFID FROM tblBuendel, tblAuftraege WHERE tblBuendel.BunID = ? AND tblBuendel.BunID = tblAuftraege.BunID AND tblAuftraege.Master <> 0 AND tblAuftraege.AutorisierenReaID is not null AND ( tblAuftraege.WFID IS NOT NULL OR tblBuendel.subAuftraege>0 )";
        this.queryJustResourceAndStatus = "SELECT tblBuendel.Status, tblAuftraege.ResID FROM tblBuendel, tblAuftraege WHERE tblBuendel.BunID = ? AND tblBuendel.BunID = tblAuftraege.BunID AND tblAuftraege.Master <> 0 ";
        this.userViewField = this.dbFeldLang.toLowerCase().startsWith("tbluser");
        if (this.dbFeldLang.indexOf(46) > -1) {
            this.dbFeldKurz = this.dbFeldLang.substring(this.dbFeldLang.indexOf(46) + 1);
        }
        if (this.userViewField) {
            this.freiauswahlUserField = (UserField)HDFieldLocator.getUserFieldForDBKey(this.dbFeldKurz);
        }
        if (!initial) {
            try (Connection con = ServerUtilities.getJJServer().getConnection("HDS");){
                this.checkAllOrders(con);
            }
            catch (SQLException e) {
                HDLogger.error(e);
            }
        }
    }

    void initResourceData() {
        if (this.isInInitResource) {
            return;
        }
        try {
            this.isInInitResource = true;
            this.resourcesData.clear();
            List<ResourceVO> allResources = this.resources.getAll(false);
            ResourceAdditionalData noResource = new ResourceAdditionalData(new ResourceVO(0, ""));
            this.resourcesData.put(0, noResource);
            allResources.forEach(r -> this.resourcesData.put(r.getId(), new ResourceAdditionalData((ResourceVO)r)));
        }
        finally {
            this.isInInitResource = false;
        }
    }

    protected String getTicketQuery(boolean all) {
        if (all) {
            return this.queryAll;
        }
        return this.queryOne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internally created statement")
    public void checkAllOrders(Connection con) {
        Statement st = null;
        ResultSet rs = null;
        this.nichtImScan = false;
        int curVersion = currentVersion;
        try {
            st = con.createStatement();
            st.setQueryTimeout(10);
            rs = st.executeQuery(this.queryAll);
            int[] allIDs = buendel.getAllKeys();
            while (rs.next()) {
                Number num;
                AuftragWithReferences auf;
                int resID = rs.getInt("ResID");
                int status = rs.getInt("Status");
                int id = rs.getInt("BunID");
                int position = OpenOrderController.isOnPosition(id, allIDs);
                if (position > -1) {
                    allIDs[position] = 0;
                }
                if ((auf = buendel.get(id)) == null) {
                    this.getResource(resID, con);
                    auf = new AuftragWithReferences(this, id);
                    if (rs.getInt("subAuftraege") > 0) {
                        this.loadSubAuftraege(con, auf, curVersion);
                    }
                    buendel.put(id, auf);
                    this.wipeCacheFor(auf);
                } else {
                    auf.check(status, resID, false);
                }
                if ((num = (Number)rs.getObject("WFID")) == null) continue;
                AuftragsReferenz ref = OpenOrderController.getReferenzObject(id, 2);
                if (num.intValue() == id) {
                    this.loadWorkFlow(con, id, status, auf.getResource().getId());
                    WorkFlow wf = workFlows.get(id);
                    if (wf != null) {
                        wf.check(con);
                    }
                } else if (ref.getRefObj() == null) {
                    ref.setRefObj(num);
                }
                auf.addReferenz(ref, curVersion);
            }
            for (int allID : allIDs) {
                if (allID <= 0) continue;
                this.checkOrders(con, allIDs, false);
                break;
            }
            this.nichtImScan = true;
            this.realizeAllChanges();
        }
        catch (SQLException er) {
            LogManager.logDiagnostics((Connection)con);
            HDLogger.error(er);
        }
        catch (Throwable er) {
            HDLogger.error(er);
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable er) {}
            try {
                st.close();
            }
            catch (Throwable er) {}
        }
    }

    private void checkOrder(Connection con, int id) {
        this.checkOrders(con, new int[]{id}, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internally created statement")
    public void checkOrders(Connection con, int[] ids, boolean realize) {
        PreparedStatement pst = null;
        ResultSet rs = null;
        boolean ownCon = con == null;
        int curVersion = currentVersion;
        try {
            if (ownCon) {
                con = ((ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class)).getConnection();
            }
            pst = con.prepareStatement(this.queryOne);
            pst.setQueryTimeout(10);
            for (int id : ids) {
                if (id <= 0) continue;
                pst.setInt(1, id);
                rs = pst.executeQuery();
                if (rs.next()) {
                    int status = rs.getInt("Status");
                    AuftragWithReferences auf = buendel.get(id);
                    if (status > 99 && status < 300) {
                        int resID = rs.getInt("ResID");
                        if (auf == null) {
                            this.getResource(resID, con);
                            auf = new AuftragWithReferences(this, id);
                            if (rs.getInt("subAuftraege") > 0) {
                                this.loadSubAuftraege(con, auf, curVersion);
                            }
                            buendel.put(id, auf);
                            this.wipeCacheFor(auf);
                        } else {
                            auf.check(rs.getInt("Status"), resID, realize && this.nichtImScan);
                        }
                        Number num = (Number)rs.getObject("WFID");
                        if (num != null) {
                            AuftragsReferenz ref = OpenOrderController.getReferenzObject(id, 2);
                            if (num.intValue() == id && workFlows.get(num.intValue()) == null) {
                                this.loadWorkFlow(con, id, rs.getInt("Status"), resID);
                            } else if (ref.getRefObj() == null) {
                                ref.setRefObj(num);
                            }
                            auf.addReferenz(ref, curVersion);
                        }
                        if (!realize || !this.nichtImScan) continue;
                        this.getResource(resID).realizeChanges(this);
                        continue;
                    }
                    if (auf == null) continue;
                    this.remove(id);
                    auf.setStatus(status, true, 228);
                    if (!realize || !this.nichtImScan) continue;
                    auf.getResourceAdditionals().realizeChanges(this);
                    continue;
                }
                if (buendel.get(id) == null) continue;
                this.remove(id);
            }
        }
        catch (Throwable er) {
            HDLogger.error(er);
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable throwable) {}
            try {
                pst.close();
            }
            catch (Throwable throwable) {}
            if (ownCon) {
                try {
                    con.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void remove(int id) {
        this.BUENDEL_VERSIONS.remove(id);
        Auftrag auf = buendel.get(id);
        if (auf != null) {
            buendel.remove(id);
        } else {
            auf = this.getAuftragAlwaysCreate(id);
        }
        if (auf != null && auf.getResourceAdditionals() != null) {
            auf.getResourceAdditionals().setBufferVersion(currentVersion + 1);
        }
    }

    private void remove(@Nonnull TicketVO ticket) {
        ResourceAdditionalData resource;
        buendel.remove(ticket.getID());
        if (ticket.getResourceID() != null && (resource = this.getResource(HDUsersAndGroups.getResourceId(ticket.getResourceID()))) != null) {
            resource.setBufferVersion(currentVersion + 1);
            resource.realizeChanges(this);
        }
    }

    public int changeBuendelVersion(int bunId) {
        Auftrag auf = this.getAuftrag(bunId);
        if (auf != null) {
            auf.updateVersion();
            auf.updateVersionToLastChanged(true);
            return currentVersion + 1;
        }
        return 0;
    }

    public void realizeAllChanges() {
        this.resourcesData.values().forEach(d -> d.realizeChanges(this));
    }

    public void reloadBundledTickets(int masterTicketID, List<Integer> slaveTicketIDs) {
        this.remove(masterTicketID);
        slaveTicketIDs.stream().forEach(id -> this.remove((int)id));
        try (Connection con = ((ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class)).getConnection();){
            OldApiAdapter.updateBuendelInOOCAndNotifyResource(con, masterTicketID);
            for (int slaveID : slaveTicketIDs) {
                OldApiAdapter.updateBuendelInOOCAndNotifyResource(con, slaveID);
            }
        }
        catch (SQLException ex) {
            HDLogger.error(ex);
        }
    }

    public void ticketChanged(int ticketId, @Nullable TicketVO oldTicket, @Nullable TicketVO newTicket) {
        boolean workFlowChange;
        if (newTicket == null) {
            this.remove(oldTicket);
            return;
        }
        boolean newIsOpenOrder = this.isTicketForOOCHandling(newTicket);
        boolean oldIsOpenOrder = oldTicket != null && this.isTicketForOOCHandling(oldTicket);
        boolean bl = workFlowChange = !Objects.equals(newTicket.getWorkflowID(), oldTicket == null ? null : oldTicket.getWorkflowID());
        if (newIsOpenOrder && (!oldIsOpenOrder || workFlowChange)) {
            this.checkOrder(null, ticketId);
        } else if (!newIsOpenOrder && !oldIsOpenOrder) {
            return;
        }
        Auftrag auftrag = this.getAuftragAlwaysCreate(ticketId);
        auftrag.updateVersion();
        auftrag.setStatus(newTicket.getStatusID(), true, oldTicket == null ? 0 : oldTicket.getStatusID());
        ResourceAdditionalData resourceAdds = auftrag.getResourceAdditionals();
        if (resourceAdds != null) {
            resourceAdds.realizeChanges(this);
        }
        if (oldTicket != null && oldTicket.getResourceID() != null && !oldTicket.getResourceID().equals((Object)newTicket.getResourceID())) {
            ResourceAdditionalData oldResource = this.getResource(HDUsersAndGroups.getResourceId(oldTicket.getResourceID()));
            oldResource.setBufferVersion(currentVersion + 1);
            oldResource.realizeChanges(this);
        }
        if (!newIsOpenOrder && oldIsOpenOrder) {
            this.remove(newTicket);
        }
    }

    public void removeSubReferenz(String prevSlave) {
        OpenOrderController.removeReferenz(Integer.parseInt(prevSlave), 1);
    }

    protected static void removeReferenz(int revID, int typ) {
        AuftragsReferenz ref = references.get(revID);
        if (ref != null) {
            if (ref.getType() == typ) {
                if (ref.getAuf() != null) {
                    ref.getAuf().removeReferenz(ref, currentVersion);
                }
                references.remove(revID);
            } else {
                ref.setType(ref.getType() & ~typ);
            }
        }
    }

    protected static AuftragsReferenz getReferenzObject(int aufNr, int typ) {
        AuftragsReferenz ref = references.get(aufNr);
        if (ref == null) {
            ref = new AuftragsReferenz(aufNr, typ);
            references.put(aufNr, ref);
        } else {
            ref.setType(ref.getType() | typ);
        }
        return ref;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="The statement and values are internally created")
    private void loadSubAuftraege(Connection con, AuftragWithReferences auf, int curVers) {
        try {
            int idx = auf.getOrderID();
            try (Statement st = con.createStatement();){
                st.setQueryTimeout(10);
                try (ResultSet rs = st.executeQuery("SELECT AufID, WFID FROM tblAuftraege Where tblAuftraege.Master = 0 AND tblAuftraege.BunID = " + idx);){
                    while (rs.next()) {
                        int subAuf = rs.getInt("AufID");
                        int wfID = rs.getInt("WFID");
                        auf.addReferenz(OpenOrderController.getReferenzObject(subAuf, 1), curVers);
                        if (wfID <= 0) continue;
                        AuftragsReferenz ref = OpenOrderController.getReferenzObject(subAuf, 2);
                        if (subAuf == wfID && workFlows.get(wfID) == null) {
                            this.loadWorkFlow(con, wfID, this.getTicketReader().getTicket(subAuf).getStatusID(), auf.getResource().getId());
                            continue;
                        }
                        if (ref.getRefObj() != null) continue;
                        ref.setRefObj(new Integer(wfID));
                    }
                }
            }
        }
        catch (Throwable er) {
            HDLogger.error(er);
        }
    }

    private TicketReaderForSystem getTicketReader() {
        return TicketManager.getReaderForSystem();
    }

    public void reloadWorkFlow(Connection con, int wfId) {
        workFlows.remove(wfId);
        this.checkOrder(con, wfId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="The statement and values are internally created")
    private synchronized void loadWorkFlow(Connection con, int id, int statusHaupt, int res) {
        Statement st = null;
        ResultSet rs = null;
        try {
            WorkFlow wf = workFlows.get(id);
            boolean newWF = wf == null;
            st = con.createStatement();
            st.setQueryTimeout(10);
            rs = st.executeQuery("SELECT tblWFaktiv.*, tblAuftraege_1.ResID, tblAuftraege_1.PriID, tblAuftraege.BunID, tblBuendel.Status FROM tblWFaktiv, tblAuftraege, tblAuftraege tblAuftraege_1, tblBuendel Where tblWFaktiv.HauptAuftrag = " + id + " AND tblWFaktiv.TeilAuftrag = tblAuftraege.AufId AND tblAuftraege.BunId = tblBuendel.BunID AND tblAuftraege.BunId = tblAuftraege_1.AufId  ORDER BY tblWFaktiv.TeilAuftrag");
            boolean wert = rs.next();
            if (wert) {
                if (newWF) {
                    String name = rs.getString("WFName");
                    wf = new WorkFlow(id, name, statusHaupt, res, currentVersion);
                }
                while (wert) {
                    long when;
                    int resID = rs.getInt("ResID");
                    int aufID = rs.getInt("TeilAuftrag");
                    Timestamp ts = rs.getTimestamp("Spaetestens");
                    long l = when = ts != null ? ts.getTime() : -1L;
                    if (newWF) {
                        Number ende1 = (Number)rs.getObject("Ende1");
                        int auf1 = ende1 != null ? ende1.intValue() : -1;
                        Number ende2 = (Number)rs.getObject("Ende2");
                        int auf2 = ende2 != null ? ende2.intValue() : -1;
                        wf.addRow(aufID, auf1, auf2, when, resID, rs.getInt("PriID"), rs.getInt("Status"));
                        ResourceAdditionalData resource = this.getResource(resID);
                        resource.setBufferVersion(++currentVersion);
                    } else {
                        wf.setData(aufID, resID, rs.getInt("Status"), when, currentVersion);
                    }
                    wert = rs.next();
                }
            } else if (!newWF) {
                wf.setStepCount(0);
            } else {
                wf = new WorkFlow(id, "", 300, -1, currentVersion);
            }
            workFlows.put(id, wf);
            if (newWF) {
                this.realizeAllChanges();
            }
        }
        catch (Throwable er) {
            HDLogger.error(er);
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable wf) {}
            try {
                st.close();
            }
            catch (Throwable wf) {}
        }
    }

    public int getUserChangeVersion() {
        return UserVersionManager.getInstance().getCurrentUserVersion();
    }

    public static int isOnPosition(int key, int[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != key) continue;
            return i;
        }
        return -1;
    }

    public String getUserGroupChangesVersion(String groupIds) {
        int[] groups = OpenOrderController.convertToIntArray(groupIds);
        return UserVersionManager.getInstance().getUserGroupChangesVersion(groups);
    }

    public String getUserOrderVersion(Integer id) {
        UserAccount userAccount = HDUsersAndGroups.getUserAccount(id);
        if (userAccount == null) {
            return "-1";
        }
        return String.valueOf(UserVersionManager.getInstance().getVersions(userAccount.getID()).getOrderVersion());
    }

    public String realizeUserDataChange(Connection con, int[] users, UserSession session) {
        UserVersionManager versionManager = UserVersionManager.getInstance();
        String retVal = versionManager.getChangedUsers(session);
        if (session != null) {
            session.setCheckedVersion(versionManager.getCurrentUserVersion());
        }
        return retVal;
    }

    public void notifyUserChangeToOrders(GUID userAccountID) {
        int changedOrders = 0;
        for (int aufID : OpenOrderController.getAllOpenOrderIDs()) {
            Auftrag auf = this.getAuftrag(aufID);
            TicketVO ticket = this.getTicketReader().getTicket(aufID);
            if (ticket.getOwnerID() == null || !ticket.getOwnerID().equals((Object)userAccountID)) continue;
            ++changedOrders;
            auf.updateVersionToLastChanged(true);
        }
        if (changedOrders > 0) {
            this.realizeAllChanges();
        }
    }

    public static List<Integer> getAllOpenOrderIDs() {
        TicketSearchFilterOptions options = TicketSearchFilterOptions.of(TicketSearchFilterOptions.ONLY_OPEN_TICKETS);
        options.withNumOfTickets(10000).withTicketsBundled(true);
        try (UserAccountScope scope = UserAccountScope.createPrivileged();){
            List<Integer> list = TicketManager.getReader().searchTicketsForUser(options);
            return list;
        }
    }

    public static int[] convertToIntArray(String commaSeparatedInts) {
        if (commaSeparatedInts != null && commaSeparatedInts.length() > 0) {
            int kommaCounter = 1;
            for (int i = 0; i < commaSeparatedInts.length(); ++i) {
                if (commaSeparatedInts.charAt(i) != ',') continue;
                ++kommaCounter;
            }
            int[] resultArray = new int[kommaCounter];
            if (kommaCounter == 1) {
                resultArray[0] = Integer.parseInt(commaSeparatedInts);
            } else {
                int start = 0;
                int writepos = 0;
                for (int i = 0; i < commaSeparatedInts.length(); ++i) {
                    if (commaSeparatedInts.charAt(i) != ',') continue;
                    resultArray[writepos++] = Integer.parseInt(commaSeparatedInts.substring(start, i).trim());
                    start = i + 1;
                }
                resultArray[writepos] = Integer.parseInt(commaSeparatedInts.substring(start).trim());
            }
            return resultArray;
        }
        return null;
    }

    public ResultSet getTreeStructure(String resStr, Auftrag.Field primaerTyp, Auftrag.Field sekundaerTyp) {
        return new Fetcher(this, workFlows, OpenOrderController.convertToIntArray(resStr), primaerTyp, sekundaerTyp).getResultSet();
    }

    public Fetcher getTreeStructure(int[] resources, Auftrag.Field primaerTyp, Auftrag.Field sekundaerTyp) {
        return new Fetcher(this, null, resources, primaerTyp, sekundaerTyp);
    }

    public Fetcher getAvailableAttributes(Auftrag.Field type) {
        return new Fetcher(type, this.getCache(type));
    }

    public Set<Integer> getOrderIdsForTypeFreiauswahl(String value) {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (int auf2 : OpenOrderController.getAllOpenOrderIDs()) {
            UserDefinedVO secA;
            Auftrag auf = this.getAuftrag(auf2);
            if (auf == null || !this.matchesSecondary(Auftrag.Field.FREI, value, secA = auf.getUserDefinedField())) continue;
            ids.add(auf2);
        }
        return ids;
    }

    private boolean matchesSecondary(Auftrag.Field sekunTyp, String sekunValue, FieldVO secA) {
        if (sekunTyp == null || secA == null) {
            return true;
        }
        if (sekunTyp.isNumeric()) {
            int sekunID = Integer.parseInt(sekunValue);
            if (secA.getId() == sekunID) {
                return true;
            }
        } else if (secA.getDisplayValue().equalsIgnoreCase(sekunValue)) {
            return true;
        }
        return false;
    }

    public String getVersion(String resStr) {
        int[] resIDs = OpenOrderController.convertToIntArray(resStr);
        return String.valueOf(resIDs == null ? currentVersion : this.getMaxVersion(resIDs));
    }

    public int getVersion(int[] resIDs) {
        return resIDs == null ? currentVersion : this.getMaxVersion(resIDs);
    }

    private int getMaxVersion(int[] resIDs) {
        int vers = 0;
        for (int resID : resIDs) {
            ResourceAdditionalData res = this.resourcesData.get(resID);
            if (res == null || res.getVersion() <= vers) continue;
            vers = res.getVersion();
        }
        return vers;
    }

    public Auftrag getAuftrag(int idx) {
        TicketVO ticket;
        Auftrag auftrag = buendel.get(idx);
        if (auftrag == null && this.isTicketForOOCHandling(ticket = TicketManager.getReaderForSystem().getTicket(idx))) {
            auftrag = new Auftrag(this, idx);
        }
        return auftrag;
    }

    private boolean isTicketForOOCHandling(TicketVO ticket) {
        return ticket != null && Status.isOpenStatus(ticket.getStatusID()) && ticket.getDispatchingReaStepID() != null && !ticket.isSlaveInBundle();
    }

    public boolean isNewState(int status) {
        ActionVO actionEmailEmpfangen = (ActionVO)ActionManager.getInstance().get(-9);
        return status == 100 || status == 101 || status == actionEmailEmpfangen.getStatusID();
    }

    private Auftrag getAuftragAlwaysCreate(int idx) {
        TicketVO ticket;
        Auftrag auftrag = buendel.get(idx);
        if (auftrag == null && (ticket = TicketManager.getReaderForSystem().getTicket(idx)) != null) {
            auftrag = new Auftrag(this, idx);
        }
        return auftrag;
    }

    public boolean orderAvailable(int[] resourcen, Auftrag auf) {
        return OpenOrderController.orderAvailable(resourcen, this.getTicketReader().getTicket(auf.getOrderID()).getStatusID(), auf.getResource() == null ? -1 : auf.getResource().getId());
    }

    public static boolean orderAvailable(int[] resourcen, int status, int resourceID) {
        if (resubmissionHidden && 150 == status) {
            return false;
        }
        if (resourcen == null) {
            return true;
        }
        return OpenOrderController.isOnPosition(resourceID, resourcen) > -1;
    }

    public void setVersion(int version) {
        if (version > currentVersion) {
            currentVersion = version;
        }
    }

    public ResourceAdditionalData getResource(int id, Connection con) {
        ResourceAdditionalData res = this.resourcesData.get(id);
        if (res == null) {
            this.resources.reloadFromDatabase();
            res = this.resourcesData.get(id);
        }
        return res;
    }

    public ResourceAdditionalData getResource(int id) {
        ResourceAdditionalData resourceAdditionalData = this.resourcesData.get(id);
        if (resourceAdditionalData == null) {
            HDLogger.warn("Requesting an unknown resource: " + id);
            HDLogger.warn("Known resources are: " + this.resourcesData.keySet());
        }
        return resourceAdditionalData;
    }

    public String getAttributName(Auftrag.Field typ, int val, boolean noValidCheck) {
        GenericFieldsManager<? extends FieldVO> map = this.getCache(typ);
        FieldVO attr = map.get(val);
        if (attr == null) {
            return null;
        }
        if (noValidCheck || attr instanceof Deletable && !((Deletable)((Object)attr)).isDeleted()) {
            return attr.getDisplayValue();
        }
        return null;
    }

    private GenericFieldsManager<? extends FieldVO> getCache(Auftrag.Field typ) {
        switch (typ) {
            case ITIL: 
            case KATEGORIE: 
            case KLASSIFIZIERUNG: 
            case ORT: 
            case PRIORITAET: 
            case STATUS: 
            case RESOURCE: 
            case BENUTZERGRUPPE: {
                return typ.getManager();
            }
        }
        return null;
    }

    public int getMatchingResource(String start) {
        if (start.length() == 0) {
            return -1;
        }
        String compareString = start.toLowerCase();
        return this.resources.getAll(true).stream().filter(r -> r.getDisplayValue().toLowerCase().startsWith(compareString)).mapToInt(r -> r.getId()).findFirst().orElse(-1);
    }

    public int getKey(String name, Auftrag.Field typ, boolean validityCheck) {
        switch (typ) {
            case KATEGORIE: {
                if (name == null) {
                    return -1;
                }
                String compareName = name.toLowerCase();
                FieldVO value = this.kategorien.getAll(validityCheck).stream().filter(f -> f.getPath().toLowerCase().equals(compareName)).findFirst().orElse(null);
                return value != null ? value.getId() : -1;
            }
            case ITIL: 
            case KLASSIFIZIERUNG: 
            case ORT: 
            case PRIORITAET: 
            case STATUS: 
            case BENUTZERGRUPPE: {
                return OpenOrderController.getIdByName(this.getCache(typ), name, validityCheck);
            }
        }
        return -1;
    }

    private static int getIdByName(GenericFieldsManager<? extends FieldVO> manager, String name, boolean checkForDeleted) {
        if (name == null) {
            return -1;
        }
        String compareName = name.toLowerCase();
        FieldVO value = manager.getAll(checkForDeleted).stream().filter(f -> f.getDisplayValue().toLowerCase().equals(compareName)).findFirst().orElse(null);
        return value != null ? value.getId() : -1;
    }

    public int checkKey(int val, Auftrag.Field typ) {
        GenericFieldsManager<? extends FieldVO> map = this.getCache(typ);
        if (map == null) {
            return -1;
        }
        FieldVO attr = map.get(val);
        if (attr == null || attr instanceof Deletable && ((Deletable)((Object)attr)).isDeleted()) {
            return -1;
        }
        return val;
    }

    public boolean isUserViewField() {
        return this.userViewField;
    }

    public String getUserViewField() {
        return this.dbFeldLang;
    }

    public UserField<?> getFreiauswahlUserField() {
        return this.freiauswahlUserField;
    }

    public UserDefinedVO getFreiauswahl(UserAccount account) {
        if (account == null || this.freiauswahlUserField == null) {
            return null;
        }
        String displayName = "";
        Object fieldValue = account.getValue(this.freiauswahlUserField);
        if (fieldValue != null) {
            displayName = fieldValue.toString();
        }
        return new UserDefinedVO(displayName.hashCode(), displayName);
    }

    public int[] getResources(int usrid, boolean allResources) {
        return ResourceManager.getInstance().getResources(HDUsersAndGroups.getUserAccount(usrid), allResources);
    }

    public boolean isMemberOfResource(int resourceID, String emailAdr) {
        IHelpDeskUserGroupManager manager = (IHelpDeskUserGroupManager)UserGroupManager.getInstance();
        UserGroupInfo resource = manager.getUserGroupInfoForResourceId(resourceID);
        Set memberIDs = resource.getMemberIDs();
        UserManager userManager = UserManager.getInstance();
        for (GUID id : memberIDs) {
            String email;
            UserAccount account = userManager.getUserAccount(id);
            if (account == null || !(email = (String)account.getValue((UserField)UsersAndGroups.FIELD_EMAIL)).equalsIgnoreCase(emailAdr) && email.indexOf(emailAdr) < 0) continue;
            return true;
        }
        return false;
    }

    public boolean isSupporter(UserAccount usr) {
        boolean hasRelevantPermission = SystemPermissionChecker.hasAnyPermission((UserAccount)usr, (Permission[])new Permission[]{HdPermissions.DISPATCHER, HdPermissions.TICKET_RESOURCES_READ, HdPermissions.TICKET_RESOURCES_READ_WRITE});
        return hasRelevantPermission || HDUsersAndGroups.isResourceMember(usr);
    }

    public void fetchUserMessages(UserSession userSession, int clientView, Properties daten) {
        Auftrag[] msgs = msgMap.get(HDUsersAndGroups.getUserID(userSession.getOwner()));
        if (msgs != null) {
            UserAccount userAccount = userSession.getOwner();
            Localization instance = this.getLocalizationInstance(userAccount);
            Set groupsForUser = UserGroupManager.getInstance().getGroupsForUser(userSession.getOwner().getID());
            groupsForUser = groupsForUser.stream().filter(ugi -> ugi.getType() == HDUsersAndGroups.RESOURCE).collect(Collectors.toSet());
            int write = 0;
            for (Auftrag msg : msgs) {
                if (msg == null || msg.getMsgFlag() == 0) continue;
                int resourceKey = msg.getResource().getId();
                if (!groupsForUser.stream().anyMatch(ugi -> {
                    Integer resourceId = (Integer)UserGroupManager.getInstance().getGroup(ugi.getID()).getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
                    return resourceId != null && resourceId == resourceKey;
                })) continue;
                this.addOrder(write++, msg, clientView, daten, instance);
            }
        }
    }

    private Localization getLocalizationInstance(UserAccount userAccount) {
        LocalizationBundle localization = (LocalizationBundle)ServerPluginManager.getInstance().getSingleInstance(LocalizationBundle.class);
        UserField languageField = UserManager.getInstance().getField("language");
        String languageKey = (String)userAccount.getValue(languageField);
        if ("xx".equalsIgnoreCase(languageKey)) {
            languageKey = Locale.getDefault().getLanguage();
            if (!Locale.GERMAN.getLanguage().equals(languageKey) && !Locale.ENGLISH.getLanguage().equals(languageKey)) {
                languageKey = Locale.GERMAN.getLanguage();
            }
        }
        TranslationTextConnector conFactory = (TranslationTextConnector)ServerPluginManager.getInstance().getSingleInstance(TranslationTextConnector.class);
        Localization instance = localization.getInstance(new Locale(languageKey), conFactory);
        return instance;
    }

    protected static void removeMessagesForUserId(int userId) {
        msgMap.remove(userId);
    }

    private void addOrder(int position, Auftrag auf, int viewOption, Properties daten, Localization instance) {
        String keyval = "sysTrayMsg" + position;
        daten.setProperty(keyval + "A", Integer.toString(auf.getOrderID()));
        if (auf.getMsgFlag() != 1) {
            daten.setProperty(keyval + "B", auf.getCuttedSubject());
            daten.setProperty(keyval + "C", OpenOrderController.getDisplayText(auf, Auftrag.Field.values()[viewOption / 10], Auftrag.Field.values()[viewOption % 10], instance));
            daten.setProperty(keyval + "D", Integer.toString(auf.getMsgFlag()));
        }
    }

    private static String getDisplayText(Auftrag auf, Auftrag.Field primTyp, Auftrag.Field sequTyp, Localization instance) {
        FieldVO prim = auf.getAttribut(primTyp);
        FieldVO sequ = auf.getAttribut(sequTyp);
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(auf.getOrderID());
        String primText = prim == null ? "" : prim.getDisplayValue();
        String sequText = sequ == null ? "" : sequ.getDisplayValue();
        StringBuilder buf = new StringBuilder();
        buf.append(OpenOrderController.getDisplayableName(primTyp, instance)).append(primText).append('\n');
        buf.append(OpenOrderController.getDisplayableName(sequTyp, instance)).append(sequText).append('\n');
        buf.append(ticket.getOwnerID() != null ? UserManager.getInstance().getUserAccount(ticket.getOwnerID()).getDisplayName() : "");
        return buf.toString();
    }

    public static String getDisplayableName(Auftrag.Field typ, Localization instance) {
        switch (typ) {
            case PRIORITAET: {
                return instance.getTranslation(Field.TICKETDATA_PRIORITYID) + ": ";
            }
            case KLASSIFIZIERUNG: {
                return instance.getTranslation(Field.TICKETDATA_CLASSIFICATIONID) + ": ";
            }
            case KATEGORIE: {
                return instance.getTranslation(Field.TICKETDATA_CATEGORY) + ": ";
            }
            case ORT: {
                return instance.getTranslation(Field.USERDATA_LOCATION) + ": ";
            }
            case BENUTZERGRUPPE: {
                return instance.getTranslation(Field.USERDATA_GROUP) + ": ";
            }
            case ITIL: {
                return instance.getTranslation(Field.TICKETDATA_ITILID) + ": ";
            }
            case FREI: {
                return instance.getTranslation("Auswahl") + ": ";
            }
        }
        return instance.getTranslation("ResID") + ": ";
    }

    public void notifyResourceIfNeeded(int ticketID, int mailType, int producerID) {
        if (mailType <= 0) {
            return;
        }
        if (mailType == 2 || mailType == 9 || mailType == 15 || mailType == 14) {
            this.benachrichtigeRessource(ticketID, true, producerID);
        } else if (mailType == 3 || mailType == 10) {
            this.benachrichtigeRessource(ticketID, false, producerID);
        }
    }

    private void benachrichtigeRessource(int ticketID, boolean neu, int producerID) {
        Auftrag auf = this.getAuftrag(ticketID);
        if (auf == null) {
            return;
        }
        CategoryVO kate = auf.getCategory();
        String kategorie = kate.getDisplayValue();
        if (ServerUtilities.linuxServer && kategorie != null && kategorie.indexOf(34) > -1) {
            kategorie = kategorie.replace('\"', '\'');
        }
        if (auf.getResource() != null && !auf.getResource().isDeleted() && auf.getResource().getMsg() > 0) {
            List listeners = ServerPluginManager.getInstance().get(ResourceNotificationListener.class);
            for (ResourceNotificationListener listener : listeners) {
                try {
                    listener.notifyResource(auf.getResource().getId(), neu, producerID, auf.getOrderID());
                }
                catch (Exception e) {
                    HDLogger.error("resource notification error from " + listener.getClass());
                    HDLogger.error(e);
                }
            }
            int flag = auf.getResource().getMsg() & 0xC;
            if (flag == 12) {
                auf.setMsgFlag(3);
            } else if (flag == 4) {
                auf.setMsgFlag(2);
            } else if (flag == 8) {
                auf.setMsgFlag(1);
            } else {
                auf.setMsgFlag(0);
            }
            if (flag <= 0) {
                return;
            }
            Set<GUID> memberIDs = HDUsersAndGroups.getMembersInResource(HDUsersAndGroups.getResourceGroupUUID(auf.getResourceID()), HDUsersAndGroups.RESOURCE_MEMBERSHIPTYPE_WRITE);
            for (GUID memberID : memberIDs) {
                int id = HDUsersAndGroups.getUserID(memberID);
                if (id == producerID) continue;
                OpenOrderController.addMessageForUserId(id, auf);
                this.sendNotificationToActiveUser(UserManager.getInstance().getUserAccount(memberID), auf);
            }
        }
    }

    private void sendNotificationToActiveUser(UserAccount user, Auftrag auf) {
        WebSocketEventHandler eventHandler = WebSocketEventHandler.getInstance();
        if (eventHandler.getConnectionsForUser(user.getID()).size() > 0) {
            Localization instance = this.getLocalizationInstance(user);
            String title = auf.getCuttedSubject();
            String message = OpenOrderController.getDisplayText(auf, Auftrag.Field.RESOURCE, Auftrag.Field.KATEGORIE, instance);
            Notification notification = new Notification(title, message);
            notification.setGroupingKey("helpdesk.notification.resource");
            notification.setTargetUrl("ticketlist/ticket/" + auf.getBunID());
            NotificationManager.getInstance().sendNotification(user.getID(), notification);
        }
    }

    private static void addMessageForUserId(int userId, Auftrag auf) {
        Auftrag[] msgs = msgMap.get(userId);
        if (ServerUtilities.conti.getSessionsForUser(userId) == null) {
            if (msgs != null) {
                OpenOrderController.removeMessagesForUserId(userId);
            }
            return;
        }
        if (msgs == null) {
            msgs = new Auftrag[10];
            msgMap.put(userId, msgs);
        } else {
            for (Auftrag msg : msgs) {
                if (msg != auf) continue;
                return;
            }
            int start = 8;
            for (int i = 0; i < msgs.length; ++i) {
                if (msgs[i] != null) continue;
                start = i - 1;
                break;
            }
            for (int n = start; n > -1; --n) {
                msgs[n + 1] = msgs[n];
            }
        }
        msgs[0] = auf;
    }

    public void wipeCacheFor(Auftrag auftrag) {
        if (this.inquiryCacheController != null) {
            this.inquiryCacheController.wipeCacheFor(auftrag);
        }
    }

    private void checkOpenOrdersQuery() {
        if (resubmissionHidden != OpenOrderController.isResubmissionHidden()) {
            resubmissionHidden = OpenOrderController.isResubmissionHidden();
            this.inquiryCacheController.resetQuery(OpenOrderController.getListOfOpenOrdersQuery());
            for (int key : OpenOrderController.getAllOpenOrderIDs()) {
                Auftrag auf = this.getAuftrag(key);
                TicketVO ticket = this.getTicketReader().getTicket(key);
                if (auf == null || 150 != ticket.getStatusID()) continue;
                auf.updateVersionToLastChanged(true);
                this.resourcesData.get(auf.getResource().getId()).realizeChanges(this);
            }
        }
    }

    private static boolean isResubmissionHidden() {
        int clientStartOption = 0;
        try {
            clientStartOption = (Integer)CLIENT_START_OPTION.get();
        }
        catch (Exception ex) {
            HDLogger.error(ex);
        }
        return (clientStartOption & 0x20000000) != 0;
    }

    public static String getListOfOpenOrdersQuery() {
        if (OpenOrderController.isResubmissionHidden()) {
            return ORDER_LIST_QUERY_WIEDERVORLAGE;
        }
        return ORDER_LIST_QUERY;
    }

    void setBuendelVariable(TypespecificIntMap<AuftragWithReferences> b) {
        buendel = b;
    }

    public static Auftrag.Field getFieldForId(int fieldTypeID) {
        return EXTERNAL_MODEL_MAPPING.get(fieldTypeID);
    }

    public static int getCurrentVersion() {
        return currentVersion;
    }

    public void init() {
        this.initResourceData();
    }

    public int getMsgFlag(int aufId) {
        Integer flag = this.BUENDEL_MSGFLAG.get(aufId);
        if (flag == null) {
            return 0;
        }
        return flag;
    }

    public void setMsgFlag(int aufid, int flag) {
        if (flag == 0) {
            this.BUENDEL_MSGFLAG.remove(aufid);
        } else {
            this.BUENDEL_MSGFLAG.put(aufid, flag);
        }
    }

    public String getDbFeldKurz() {
        return this.dbFeldKurz;
    }

    public int getAuftragLastVersion(int aufId) {
        Integer ver = this.BUENDEL_VERSIONS.get(aufId);
        if (ver == null) {
            return 0;
        }
        return ver;
    }

    public void setAuftragLastVersion(int aufId, int version) {
        this.BUENDEL_VERSIONS.put(aufId, version);
    }

    static {
        currentVersion = (int)(System.currentTimeMillis() % 100000L);
        references = new TypespecificIntMap();
        buendel = new TypespecificIntMap();
        workFlows = new TypespecificIntMap();
        EXTERNAL_MODEL_MAPPING = new TypespecificIntMap<Auftrag.Field>(){
            {
                this.put(6, Auftrag.Field.BENUTZERGRUPPE);
                this.put(8, Auftrag.Field.FREI);
                this.put(7, Auftrag.Field.ITIL);
                this.put(4, Auftrag.Field.KATEGORIE);
                this.put(3, Auftrag.Field.KLASSIFIZIERUNG);
                this.put(5, Auftrag.Field.ORT);
                this.put(2, Auftrag.Field.PRIORITAET);
                this.put(1, Auftrag.Field.RESOURCE);
                this.put(0, Auftrag.Field.STATUS);
                this.put(9, Auftrag.Field.LASTEDITOR);
            }
        };
        CLIENT_START_OPTION = new ConfigValue<Integer>(HDConfigKeys.CLIENT_START_OPTION){

            protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
                Integer oldValue = (Integer)this.get();
                super.setValue(strValue);
                if (oldValue != null) {
                    try {
                        ServerUtilities.getOpenOrderController().checkOpenOrdersQuery();
                    }
                    catch (IllegalStateException ex) {
                        HDLogger.debug(ex);
                    }
                }
            }
        };
        CLIENT_TREE_CONFIG = new ConfigValue<String>(HDConfigKeys.CLIENT_TREE_CONFIG){

            protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
                super.setValue(strValue);
                HDLogger.info("Swing Client view settings changed to: " + strValue);
                if (CLIENT_TREE_CONFIG != null) {
                    ServerUtilities.getOpenOrderController().initQueriesAndSelectionField(false);
                }
            }
        };
        EXTENDED_STATE_EVENTS = new ConfigValue(HDConfigKeys.EXTENDED_STATE_EVENTS);
        msgMap = new HashMap<Integer, Auftrag[]>();
    }
}

