/*
 * Decompiled with CFR 0.152.
 */
package srv.controller;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.SwingClientActiveUsersInfo;
import com.inet.helpdesk.core.swing.ListResultSet;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReaderForSystem;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVOManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.TicketSearchFilterOptions;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.ChangedTicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.shared.model.Status;
import com.inet.helpdesk.shared.util.TypespecificIntMap;
import com.inet.helpdesk.shared.util.UtilityFunctions;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import srv.ServerUtilities;
import srv.controller.OpenOrderController;
import srv.controller.TicketAccessController;
import srv.controller.UserSession;
import srv.controller.UserVersionManager;
import srv.controller.ticket.attributes.User;
import srv.mail.AutoMailSender;

public class MetaController
implements TicketEventListener,
SwingClientActiveUsersInfo {
    public static final long MILLIS_PER_WORKING_DAY = 32400000L;
    public static final int COMMAND_FETCH_USERS = 3;
    public static final int COMMAND_MULTI_MESSAGE = 4;
    private static final String NO_LOCK_NAME = " ";
    private static final String NULL_STRING = "0";
    static final String TP_MULTIPLEIDS = "multipleidschanged";
    private static final int[] COLUMNS_OFFENE = new int[]{12, 4, 4, 4, 4, 12, 93, -7, 4, 12, 12, 4, 12, 12};
    private static final String[] COLUMN_NAMES_OFFENE = new String[]{"Username", "AufID", "UsrID", "GebID", "LogUsrID", "logName", "AnfrageDat", "Anlagen", "Prio", "Nachname", "Vorname", "Version", "DerBetreff", "EmailEingang"};
    private static final int[] COLUMNS_MESSAGING = new int[]{4, 4, 4};
    private static final String[] COLUMN_NAMES_MESSAGING = new String[]{"UsrID", "SeesionID", "Member"};
    static final Integer NO_USER_LOCK = -1;
    private static final Integer SUPPORTER = 1;
    private static final Integer SIMPLE_USER = 0;
    private int minAufID = 0;
    private static int[] eskalationsStatus = new int[]{100, 101};
    private static String eskalationsString = null;
    private static HashSet<Integer> escalationCheckedStatus = new HashSet();
    public static final int CHANGED_KATEGORIE = 0;
    public static final int CHANGED_RESSOURCE = 1;
    public static final int CHANGED_ORT = 2;
    public static final int CHANGED_PRIORITAET = 3;
    public static final int CHANGED_IMAP = 4;
    public static final int CHANGED_AKTION = 5;
    public static final int CHANGED_KLASSE = 6;
    public static final int CHANGED_ANFRAGEN = 7;
    public static final int CHANGED_BENUTZERGRUPPE = 8;
    public static final int CHANGED_STATUS = 9;
    public static final int CHANGED_ITIL = 10;
    public static final int CHANGED_GERAETE_TYPEN = 11;
    public static final int CHANGED_SLA = 12;
    public static final int CHANGED_LIZENZEN = 13;
    public static final int CHANGED_VERKAEUFER = 14;
    public static final int CHANGED_DEVICES = 15;
    public static final String[] NAMES = new String[]{"CHANGED_KATEGORIE", "CHANGED_RESSOURCE", "CHANGED_ORT", "CHANGED_PRIORITAET", "CHANGED_IMAP", "CHANGED_AKTION", "CHANGED_KLASSE", "CHANGED_ANFRAGEN", "CHANGED_BENUTZERGRUPPE", "CHANGED_STATUS", "CHANGED_ITIL", "CHANGED_GERAETE_TYPEN", "CHANGED_SLA", "CHANGED_LIZENZEN", "CHANGED_VERKAEUFER", "CHANGED_DEVICES"};
    public static final int STATUS_BIT = 1;
    public static final int ORTE_BIT = 2;
    public static final int AKTIONEN_BIT = 4;
    public static final int KATEGORIE_BIT = 8;
    public static final int KLASSIFIZIERUNG_BIT = 16;
    public static final int PRIORITAET_BIT = 32;
    public static final int RESOURCE_BIT = 64;
    public static final int GERAETE_TYPEN_BIT = 128;
    public static final int VERKAEUFER_BIT = 256;
    public static final int LIZENZEN_BIT = 512;
    public static final int SLA_BIT = 1024;
    public static final int ITIL_BIT = 2048;
    public static final int BENUTZERGRUPPEN_BIT = 4096;
    private int deviceChangeVersion;
    private int katChange;
    private int resChange;
    private int ortChange;
    private int priChange;
    private int imapChange;
    private int aktChange;
    private int klassChange;
    private int anfragenChange;
    private int bgrChange;
    private int statusChange;
    private int itilChange;
    private int gerTypenChange;
    private int slaChange;
    private int lizChange;
    private int verkChange;
    private ArrayList<String[]> aktualisierungsDaten;
    private Vector<DeviceChange> deviceChanges = new Vector();
    private StringBuffer buf = new StringBuffer();
    private TypespecificIntMap<UserSession> sessions;
    private Map<Integer, UserSession> lockedSessionPerAnfrage = new HashMap<Integer, UserSession>();
    private Map<Integer, Boolean> exclusiveLockFlagPerAnfrage = new HashMap<Integer, Boolean>();
    private TicketAccessController orderAccess = new TicketAccessController();
    private TicketReaderForSystem readerForTests;
    private Set<Integer> offeneAnfragenIDs = null;
    private static final Object ANFRAGEN_ID_LIST_LOCK = new Object();
    private static final int IN_ACCOUNT_POSITION = 13;
    private static final int SUBJECT_POSITION = 12;
    private static final int VERSION_POSITION = 11;
    private static final int OWNER_FIRSTNAME_POSITION = 10;
    private static final int OWNER_NAME_POSITION = 9;
    private static final int PRIORITY_POSITION = 8;
    private static final int ATTACHMENT_POSITION = 7;
    private static final int INQUIRY_DATE_POSITION = 6;
    private static final int LOCKNAME_POSITION = 5;
    private static final int LOCKSESSION_POSITION = 4;
    private static final int LOCATIONID_POSITION = 3;
    private static final int USRID_POSITION = 2;
    private static final int TICKETID_POSITION = 1;
    private static final int USER_DISPLAYNAME_POSITION = 0;
    private Map<Integer, UserSession> firstSessionForUser = new HashMap<Integer, UserSession>();

    MetaController(TicketReaderForSystem reader) {
        this();
        this.readerForTests = reader;
    }

    public MetaController() {
        this.aktualisierungsDaten = new ArrayList();
        this.sessions = new TypespecificIntMap();
        for (String element : NAMES) {
            String[] reihe = new String[]{element, NULL_STRING};
            this.aktualisierungsDaten.add(reihe);
        }
        this.verkChange = 0;
        this.lizChange = 0;
        this.slaChange = 0;
        this.gerTypenChange = 0;
        this.itilChange = 0;
        this.statusChange = 0;
        this.bgrChange = 0;
        this.anfragenChange = 0;
        this.klassChange = 0;
        this.aktChange = 0;
        this.imapChange = 0;
        this.priChange = 0;
        this.ortChange = 0;
        this.resChange = 0;
        this.katChange = 0;
        this.deviceChangeVersion = 0;
        LocationManager.getInstance().addDataChangeListener(() -> this.setChanged(2, false));
        PriorityManager.getInstance().addDataChangeListener(() -> this.setChanged(3, false));
        ClassificationManager.getInstance().addDataChangeListener(() -> this.setChanged(6, false));
        CategoryManager.getInstance().addDataChangeListener(() -> this.setChanged(0, false));
        StatusManager.getInstance().addDataChangeListener(() -> this.setChanged(9, false));
        ItilManager.getInstance().addDataChangeListener(() -> this.setChanged(10, false));
    }

    public TicketAccessController getTicketAccessController() {
        return this.orderAccess;
    }

    public void inquiryChanged(int ticketID) {
        TicketVO request = this.getRequest(ticketID);
        if (request == null) {
            return;
        }
        ServerUtilities.conti.setChanged(7, false);
        int version = ServerUtilities.conti.getVersion(7);
    }

    public void setChanged(int index, boolean relevant) {
        int val = 0;
        switch (index) {
            case 0: {
                CategoryManager.getInstance().reloadFromDatabase();
                val = ++this.katChange;
                break;
            }
            case 1: {
                val = ++this.resChange;
                break;
            }
            case 2: {
                if (relevant) {
                    LocationManager.getInstance().reloadFromDatabase();
                }
                val = ++this.ortChange;
                break;
            }
            case 3: {
                PriorityManager.getInstance().reloadFromDatabase();
                val = ++this.priChange;
                break;
            }
            case 4: {
                val = ++this.imapChange;
                break;
            }
            case 9: {
                StatusManager.getInstance().reloadFromDatabase();
                val = ++this.statusChange;
                break;
            }
            case 5: {
                val = ++this.aktChange;
                ActionManager.getInstance().reloadFromDatabase();
                break;
            }
            case 6: {
                ClassificationManager.getInstance().reloadFromDatabase();
                val = ++this.klassChange;
                break;
            }
            case 7: {
                val = ++this.anfragenChange;
                break;
            }
            case 8: {
                UserGroupVOManager.getInstance().reloadFromDatabase();
                val = ++this.bgrChange;
                break;
            }
            case 10: {
                ItilManager.getInstance().reloadFromDatabase();
                val = ++this.itilChange;
                break;
            }
            case 11: {
                val = ++this.gerTypenChange;
                break;
            }
            case 12: {
                val = ++this.slaChange;
                break;
            }
            case 13: {
                val = ++this.lizChange;
                break;
            }
            case 14: {
                val = ++this.verkChange;
                break;
            }
            case 15: {
                val = ++this.deviceChangeVersion;
            }
        }
        String[] reihe = this.aktualisierungsDaten.get(index);
        reihe[1] = String.valueOf(val);
    }

    public int getVersion(int index) {
        int val = 0;
        switch (index) {
            case 0: {
                val = this.katChange;
                break;
            }
            case 1: {
                val = this.resChange;
                break;
            }
            case 2: {
                val = this.ortChange;
                break;
            }
            case 3: {
                val = this.priChange;
                break;
            }
            case 4: {
                val = this.imapChange;
                break;
            }
            case 9: {
                val = this.statusChange;
                break;
            }
            case 5: {
                val = this.aktChange;
                break;
            }
            case 6: {
                val = this.klassChange;
                break;
            }
            case 7: {
                val = this.anfragenChange;
                break;
            }
            case 8: {
                val = this.bgrChange;
                break;
            }
            case 10: {
                val = this.itilChange;
                break;
            }
            case 11: {
                val = this.gerTypenChange;
                break;
            }
            case 12: {
                val = this.slaChange;
                break;
            }
            case 13: {
                val = this.lizChange;
                break;
            }
            case 14: {
                val = this.verkChange;
                break;
            }
            case 15: {
                val = this.deviceChangeVersion;
            }
        }
        return val;
    }

    public void noticeClientChanges(int bits) {
        if ((bits & 1) != 0) {
            this.setChanged(9, true);
        }
        if ((bits & 2) != 0) {
            this.setChanged(2, true);
        }
        if ((bits & 4) != 0) {
            this.setChanged(5, true);
        }
        if ((bits & 8) != 0) {
            this.setChanged(0, true);
        }
        if ((bits & 0x10) != 0) {
            this.setChanged(6, true);
        }
        if ((bits & 0x20) != 0) {
            this.setChanged(3, true);
        }
        if ((bits & 0x40) != 0) {
            this.setChanged(1, true);
        }
        if ((bits & 0x80) != 0) {
            this.setChanged(11, true);
        }
        if ((bits & 0x100) != 0) {
            this.setChanged(14, true);
        }
        if ((bits & 0x200) != 0) {
            this.setChanged(13, true);
        }
        if ((bits & 0x400) != 0) {
            this.setChanged(12, true);
        }
        if ((bits & 0x800) != 0) {
            this.setChanged(10, true);
        }
        if ((bits & 0x1000) != 0) {
            this.setChanged(8, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noticeDeviceChanges(String value, Properties daten, UserSession theSession) {
        if (value != null) {
            if (theSession.getDeviceInfoVersion() != this.deviceChangeVersion && theSession.getDeviceInfoVersion() > -1) {
                Vector<DeviceChange> vector = this.deviceChanges;
                synchronized (vector) {
                    this.buf.setLength(0);
                    int idCounter = 0;
                    int i = this.deviceChanges.size();
                    while (i > 0) {
                        int[] values;
                        DeviceChange devChange = this.deviceChanges.elementAt(--i);
                        if (devChange.version <= theSession.getDeviceInfoVersion()) break;
                        if (TP_MULTIPLEIDS.equals(devChange.changes)) {
                            idCounter = 11;
                            break;
                        }
                        for (int value2 : values = (int[])devChange.changes) {
                            if (++idCounter == 1) {
                                this.buf.append(value2);
                                continue;
                            }
                            this.buf.append(',').append(value2);
                        }
                    }
                    if (idCounter > 10) {
                        daten.setProperty("deviceschanged", TP_MULTIPLEIDS);
                    } else {
                        daten.setProperty("deviceschanged", this.buf.toString());
                    }
                }
            }
            if (value.equals(TP_MULTIPLEIDS)) {
                this.deviceChanges.removeAllElements();
                this.setChanged(15, true);
                this.deviceChanges.addElement(new DeviceChange(TP_MULTIPLEIDS, this.deviceChangeVersion));
            } else if (value.length() > 0) {
                this.setChanged(15, true);
                this.deviceChanges.addElement(new DeviceChange(OpenOrderController.convertToIntArray(value), this.deviceChangeVersion));
                if (this.deviceChanges.size() > 10) {
                    this.deviceChanges.remove(0);
                }
            }
            theSession.setDeviceInfoVersion(this.deviceChangeVersion);
        }
    }

    public void writeData(Properties daten) {
        for (int i = 0; i < this.aktualisierungsDaten.size(); ++i) {
            daten.setProperty(this.aktualisierungsDaten.get(i)[0], this.aktualisierungsDaten.get(i)[1]);
        }
    }

    public static boolean isEscalatableStatus(int status) {
        for (int eskalationsStatu : eskalationsStatus) {
            if (eskalationsStatu != status) continue;
            return true;
        }
        return false;
    }

    public static String getEscalationStates() {
        if (eskalationsString == null) {
            StringBuffer buf = new StringBuffer().append(eskalationsStatus[0]);
            for (int i = 1; i < eskalationsStatus.length; ++i) {
                buf.append(',').append(eskalationsStatus[i]);
            }
            eskalationsString = buf.toString();
        }
        return eskalationsString;
    }

    public static void setEscalationCheckedState(int status) {
        escalationCheckedStatus.add(status);
    }

    public static boolean isEscalationCheckedState(int status) {
        return escalationCheckedStatus.contains(status);
    }

    public static void checkEscalationStates(int status) {
        for (int eskalationsStatu : eskalationsStatus) {
            if (eskalationsStatu != status) continue;
            return;
        }
        MetaController.setEscalationCheckedState(status);
        int[] newEskalations = new int[eskalationsStatus.length + 1];
        System.arraycopy(eskalationsStatus, 0, newEskalations, 0, eskalationsStatus.length);
        newEskalations[MetaController.eskalationsStatus.length] = status;
        eskalationsStatus = newEskalations;
        HDLogger.debug("New escalation status: " + status);
        eskalationsString = null;
    }

    private String getDisplayableName(User user) {
        return UtilityFunctions.getDisplayNameFor(user.getUsername(), user.getNachname(), user.getVorname());
    }

    public void checkOpenOrders(boolean vollesProgram, Connection con) {
        if (vollesProgram) {
            this.checkSessions();
        }
    }

    public int removeRequest(int id) {
        this.setChanged(7, false);
        UserSession userSession = this.lockedSessionPerAnfrage.remove(id);
        if (userSession != null) {
            this.unlockSession(userSession);
            return 0;
        }
        return -1;
    }

    public ResultSet getConnectedUsers(int requesrteSession) throws SQLException {
        try {
            ArrayList<Object[]> data = new ArrayList<Object[]>();
            int[] keys = this.sessions.getAllKeys();
            long compareTime = System.currentTimeMillis() - 11000L;
            for (int key : keys) {
                UserSession testSession;
                if (requesrteSession == key || (testSession = this.sessions.get(key)) == null || testSession.isClosed() || !testSession.isHdMobile() && testSession.getLastContact() <= compareTime) continue;
                Object[] usrSession = new Object[]{new Integer(HDUsersAndGroups.getUserID(testSession.getOwner())), new Integer(key), ServerUtilities.getOpenOrderController().isSupporter(testSession.getOwner()) ? SUPPORTER : SIMPLE_USER};
                data.add(usrSession);
            }
            ListResultSet theRS = new ListResultSet();
            theRS.setColumns(COLUMN_NAMES_MESSAGING);
            theRS.setColumnTypes(COLUMNS_MESSAGING);
            theRS.setValues(data);
            return theRS;
        }
        catch (Exception er) {
            HDLogger.error(er);
            throw new SQLException();
        }
    }

    public int deliverMulitiMessage(String messageOrginator, int sessionSender, int messageCount, long startTime, String message, String targetSessions) {
        int[] targetIDs;
        int deliverCount = 0;
        for (int targetID : targetIDs = OpenOrderController.convertToIntArray(targetSessions)) {
            UserSession target = this.sessions.get(targetID);
            if (target == null || target.isClosed()) continue;
            target.setMessage(0, sessionSender, 4, startTime, messageOrginator, message);
            ++deliverCount;
        }
        return deliverCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Integer> getAnfragen(int theUser) {
        List<Integer> anfragen = this.getTicketReader().searchTicketsForUser(theUser, TicketSearchFilterOptions.of(TicketSearchFilterOptions.ONLY_OPEN_INQUIRIES).withNumOfTickets(-1));
        Collections.sort(anfragen);
        Object object = ANFRAGEN_ID_LIST_LOCK;
        synchronized (object) {
            if (this.offeneAnfragenIDs == null) {
                this.offeneAnfragenIDs = new HashSet<Integer>(anfragen);
            }
        }
        return anfragen;
    }

    private boolean accessible(Integer ticketID, int theSessionID) {
        boolean exclusiveLocked = this.exclusiveLockFlagPerAnfrage.get(ticketID) == Boolean.TRUE;
        return !exclusiveLocked || exclusiveLocked && this.lockedSessionPerAnfrage.get(ticketID).getSessionID() == theSessionID;
    }

    public ResultSet getOffene(int theUser, int theSessionID) {
        ListResultSet theRS = new ListResultSet();
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        List<Integer> anfragen = this.getAnfragen(theUser);
        for (Integer anf : anfragen) {
            if (!this.accessible(anf, theSessionID)) continue;
            Object[] requestData = new Object[14];
            data.add(requestData);
            TicketVO request = this.getRequest(anf);
            if (request == null) {
                HDLogger.warn("[MetaController] Request not found:" + anf);
                continue;
            }
            UserAccount owner = null;
            if (request.getOwnerID() != null) {
                owner = UserManager.getInstance().getUserAccount(request.getOwnerID());
                requestData[0] = owner.getDisplayName();
            } else {
                requestData[0] = "";
            }
            requestData[1] = anf;
            requestData[2] = request.getOwnerID() == null ? null : Integer.valueOf(HDUsersAndGroups.getUserID(request.getOwnerID()));
            requestData[3] = owner == null ? null : owner.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
            requestData[4] = NO_USER_LOCK;
            requestData[5] = NO_LOCK_NAME;
            if (this.lockedSessionPerAnfrage.get(anf) != null) {
                requestData[4] = this.lockedSessionPerAnfrage.get(anf).getSessionID();
                requestData[5] = this.lockedSessionPerAnfrage.get(anf).getOwner().getDisplayName();
            }
            requestData[7] = request.getAttribute(Tickets.ATTRIBUTE_ATTACHMENTS);
            requestData[9] = owner == null ? "" : owner.getDisplayName();
            requestData[10] = owner == null ? "" : owner.getValue((UserField)UsersAndGroups.FIELD_FIRSTNAME);
            requestData[11] = new Long(request.getLastChanged());
            requestData[12] = request.getSubject();
            requestData[6] = new Timestamp(request.getInquiryDate());
            requestData[8] = request.getPriorityID();
            requestData[13] = request.getAttribute(Tickets.ATTRIBUTE_EMAIL_EINGANG);
        }
        theRS.setColumns(COLUMN_NAMES_OFFENE);
        theRS.setColumnTypes(COLUMNS_OFFENE);
        theRS.setValues(data);
        return theRS;
    }

    public String fetchRequestsData(int theSessionID, String ticket) {
        UserSession testSession = this.sessions.get(theSessionID);
        Integer userId = testSession == null || testSession.getOwner() == null ? (Integer)UserManager.getInstance().getCurrentUserAccount().getValue((UserField)HDUsersAndGroups.FIELD_USER_ID) : (Integer)testSession.getOwner().getValue((UserField)HDUsersAndGroups.FIELD_USER_ID);
        List<Integer> anfragen = this.getAnfragen(userId);
        int id = ticket != null && ticket.length() > 0 ? Integer.parseInt(ticket) : -1;
        StringBuffer buf = new StringBuffer();
        for (Integer anf : anfragen) {
            if (anf == id && this.lockedSessionPerAnfrage.get(anf) == null && testSession != null) {
                this.lockedSessionPerAnfrage.put(anf, testSession);
                testSession.setLockedRequest(anf);
            }
            if (!this.accessible(anf, theSessionID) || !this.addToString(anf, buf)) continue;
            this.setChanged(7, false);
        }
        return buf.toString();
    }

    public int changeInRequest(int aufid, int currentStatus, int user, int sessionID, int flag) {
        int BIT_LOCK = 3;
        int BIT_RELOAD = 8;
        int BIT_ANFRAGE = 16;
        int success = 0;
        if (aufid > -1) {
            if (currentStatus >= 100) {
                UserSession userSession = this.lockedSessionPerAnfrage.get(aufid);
                TicketVO request = this.getRequest(aufid);
                if (userSession != null && request != null) {
                    this.unlockSession(userSession);
                    if (currentStatus >= 400 && request.getOwnerID() != null) {
                        UserVersionManager.getInstance().incOrderVersion(request.getOwnerID());
                    }
                }
            } else {
                boolean lock;
                boolean reload = (flag & 8) > 0;
                boolean bl = lock = (flag & 3) > 0;
                if (reload && this.getRequest(aufid) == null) {
                    HDLogger.warn("Anfrage nicht gefunden: " + aufid);
                }
                if ((flag & 0x10) > 0) {
                    AutoMailSender.sendIfNeeded(aufid, 6, (String)null);
                }
                TicketVO anfrage = this.getRequest(aufid);
                UserSession session = this.aktualisiereUserSession(sessionID, user);
                this.unlockSession(session);
                if (lock) {
                    if (anfrage != null) {
                        this.lockSessionAndAuftrag(aufid, session);
                        this.exclusiveLockFlagPerAnfrage.put(aufid, (flag & 2) != 0);
                    } else {
                        HDLogger.debug("Anfrage nicht vorhanden (lock)");
                    }
                }
            }
        } else {
            UserSession session = this.aktualisiereUserSession(sessionID, user);
            this.unlockSession(session);
        }
        return success;
    }

    public void markUserOrderChange(int bunID) {
        TicketVO auftrag = this.getRequest(bunID);
        if (auftrag != null) {
            this.setChanged(7, false);
            if (auftrag.getOwnerID() != null) {
                UserVersionManager.getInstance().incOrderVersion(auftrag.getOwnerID());
            }
        }
    }

    private void lockSessionAndAuftrag(int aufid, UserSession session) {
        this.lockedSessionPerAnfrage.put(aufid, session);
        session.setLockedRequest(aufid);
    }

    private void unlockSession(UserSession session) {
        if (session.getLockedRequest() != null) {
            UserSession userSession = this.lockedSessionPerAnfrage.get(session.getLockedRequest());
            if (userSession == session) {
                this.lockedSessionPerAnfrage.remove(session.getLockedRequest());
                this.exclusiveLockFlagPerAnfrage.put(session.getLockedRequest(), false);
            }
            session.setLockedRequest(null);
        }
    }

    private boolean addToString(Integer anf, StringBuffer buf) {
        TicketVO request = this.getRequest(anf);
        if (request == null) {
            HDLogger.warn("[MetaController ]Request not found:" + anf);
            return false;
        }
        boolean change = false;
        String lockname = NO_LOCK_NAME;
        UserSession userSession = this.lockedSessionPerAnfrage.get(anf);
        if (userSession != null) {
            lockname = userSession.getOwner().getDisplayName();
        }
        buf.append(lockname).append('\n');
        buf.append(anf).append(';');
        GUID ownerID = request.getOwnerID();
        if (ownerID == null) {
            buf.append((Object)null).append(';');
            buf.append((Object)null).append(';');
        } else {
            buf.append(HDUsersAndGroups.getUserID(ownerID)).append(';');
            buf.append(UserManager.getInstance().getUserAccount(ownerID).getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID)).append(';');
        }
        if (userSession != null) {
            buf.append(userSession.getSessionID()).append(';');
        } else {
            buf.append(NO_USER_LOCK).append(';');
        }
        buf.append(request.getAttribute(Tickets.ATTRIBUTE_ATTACHMENTS) != false ? 1 : 0).append('\n');
        return change;
    }

    private TicketReaderForSystem getTicketReader() {
        if (this.readerForTests != null) {
            return this.readerForTests;
        }
        return TicketManager.getReaderForSystem();
    }

    public TicketVO getRequest(int id) {
        TicketVO ticket = this.getTicketReader().getTicket(id);
        return ticket == null ? null : (ticket.isInquiry() ? ticket : null);
    }

    private void checkSessions() {
        int[] keys = this.sessions.getAllKeys();
        long compareTime = System.currentTimeMillis() - 10000L;
        HDLogger.debug("Current SessionObject count: " + keys.length);
        for (int key : keys) {
            try {
                UserSession testSession = this.sessions.get(key);
                if (testSession.isHdMobile() || testSession.getLastContact() >= compareTime) continue;
                this.instanceClose(HDUsersAndGroups.getUserID(testSession.getOwner()), key);
            }
            catch (Throwable er) {
                HDLogger.error(er);
            }
        }
    }

    public void checkForInvalidatedSessions() {
        int[] keys = this.sessions.getAllKeys();
        long compareTime = System.currentTimeMillis() - 120000L;
        for (int key : keys) {
            try {
                UserSession testSession = this.sessions.get(key);
                if (testSession.getLastContact() >= compareTime) continue;
                this.instanceClose(HDUsersAndGroups.getUserID(testSession.getOwner()), key);
            }
            catch (Throwable er) {
                HDLogger.error(er);
            }
        }
    }

    public boolean instanceClose(int usrid, int hdsession) {
        UserSession session = this.sessions.get(hdsession);
        if (session != null) {
            this.orderAccess.handleOpenedOrders(session, null, null);
            session.setClosed();
            if (session.getLockedRequest() != null) {
                this.unlockSession(session);
            }
            this.sessions.remove(hdsession);
            this.removeSessionFromUser(hdsession, usrid);
        }
        return true;
    }

    public UserSession getUserSession(int hdsession) {
        return this.sessions.get(hdsession);
    }

    public TypespecificIntMap<UserSession> getCurrentConnectedSessions() {
        return this.sessions;
    }

    public UserSession aktualisiereUserSession(int hdsession, int usrid) {
        UserSession session = this.getSessionForUser(hdsession, usrid);
        if (session == null) {
            this.checkSessions();
            UserSession testSession = this.sessions.get(hdsession);
            if (testSession != null) {
                this.instanceClose(HDUsersAndGroups.getUserID(testSession.getOwner()), hdsession);
            }
            session = this.addSessionForUser(hdsession, usrid);
            this.sessions.put(hdsession, session);
        } else {
            session.setLastContact(System.currentTimeMillis());
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(TicketEvent event) {
        if (this.offeneAnfragenIDs == null) {
            Object object = ANFRAGEN_ID_LIST_LOCK;
            synchronized (object) {
                if (this.offeneAnfragenIDs == null) {
                    return;
                }
            }
        }
        List<ChangedTicketVO> changedTickets = event.getChangedTickets();
        for (ChangedTicketVO vo : changedTickets) {
            Object object;
            if (vo.getOldTicket() != null && Status.isOpenStatus(vo.getOldTicket().getStatusID()) && vo.getOldTicket().isInquiry() && (vo.getNewTicket() == null || !vo.getNewTicket().isInquiry() || !Status.isOpenStatus(vo.getNewTicket().getStatusID()))) {
                object = ANFRAGEN_ID_LIST_LOCK;
                synchronized (object) {
                    this.offeneAnfragenIDs.remove(vo.getOldTicket().getID());
                }
            }
            if (vo.getNewTicket() == null || !Status.isOpenStatus(vo.getNewTicket().getStatusID()) || !vo.getNewTicket().isInquiry()) continue;
            object = ANFRAGEN_ID_LIST_LOCK;
            synchronized (object) {
                this.offeneAnfragenIDs.add(vo.getNewTicket().getID());
            }
        }
    }

    @Override
    public Set<GUID> getGUIDsOfCurrentlyActiveSwingClientUsers() {
        TypespecificIntMap<UserSession> currentSwingSessions = this.getCurrentConnectedSessions();
        return currentSwingSessions.getValueList().stream().map(s -> s.getOwner().getID()).collect(Collectors.toSet());
    }

    @Nullable
    public ArrayList<UserSession> getSessionsForUser(int userId) {
        long compareTime = System.currentTimeMillis() - 10000L;
        ArrayList<UserSession> allMySessions = null;
        for (UserSession session = this.firstSessionForUser.get(userId); session != null; session = session.getNextSession()) {
            if (session.getLastContact() > compareTime && !session.isClosed()) {
                if (allMySessions == null) {
                    allMySessions = new ArrayList<UserSession>();
                }
                allMySessions.add(session);
                continue;
            }
            HDLogger.debug("ERROR found invalid Session-Object");
        }
        return allMySessions;
    }

    @Nullable
    public UserSession getSessionForUser(int key, int userId) {
        UserSession session;
        for (session = this.firstSessionForUser.get(userId); session != null && session.getSessionID() != key; session = session.getNextSession()) {
        }
        return session;
    }

    public UserSession addSessionForUser(int key, int userId) {
        int count = 1;
        UserAccount account = HDUsersAndGroups.getUserAccount(userId);
        UserSession session = new UserSession(account, key);
        UserSession firstSession = this.firstSessionForUser.get(userId);
        if (firstSession == null) {
            firstSession = session;
            this.firstSessionForUser.put(userId, firstSession);
        } else {
            UserSession someSession = firstSession;
            while (someSession.getNextSession() != null) {
                ++count;
                someSession = someSession.getNextSession();
            }
            someSession.setNextSession(session);
        }
        if (count % 10 == 0) {
            HDLogger.debug(count + ". SessionObject erzeugt. User " + userId + NO_LOCK_NAME + count);
        }
        return session;
    }

    private void removeSessionFromUser(int key, int userId) {
        UserSession firstSession = this.firstSessionForUser.get(userId);
        if (firstSession == null) {
            OpenOrderController.removeMessagesForUserId(userId);
            return;
        }
        if (firstSession.getSessionID() == key) {
            firstSession = firstSession.getNextSession();
            this.firstSessionForUser.put(userId, firstSession);
            if (firstSession == null) {
                OpenOrderController.removeMessagesForUserId(userId);
            }
        } else {
            UserSession session;
            UserSession prev = firstSession;
            for (session = firstSession.getNextSession(); session != null && session.getSessionID() != key; session = session.getNextSession()) {
                prev = session;
            }
            if (session != null) {
                this.unlockSession(session);
                prev.setNextSession(session.getNextSession());
            } else {
                HDLogger.debug("ERROR can not remove the Session-Object");
            }
        }
    }

    private class DeviceChange {
        private Object changes;
        private int version;

        private DeviceChange(Object changes, int version) {
            this.changes = changes;
            this.version = version;
        }
    }
}

