/*
 * Decompiled with CFR 0.152.
 */
package srv.commands;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.jj.srv.JavaCommand;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.SQLException;

public class BGAddUserCommand
extends JavaCommand {
    public static final String KEY = "BGAddUser";
    private Integer groupID;
    private Integer userID;

    public void setInt(int paramIndex, int value) throws SQLException {
        if (paramIndex == 1) {
            this.groupID = value;
        } else if (paramIndex == 2) {
            this.userID = value;
        } else {
            throw new SQLException("Parameter index out of range: " + paramIndex + " (Number of parameters is 2).");
        }
    }

    public boolean execute() throws SQLException {
        if (this.groupID == null) {
            throw new SQLException("No value specified for parameter 1");
        }
        if (this.userID == null) {
            throw new SQLException("No value specified for parameter 2");
        }
        MutableUserData userData = new MutableUserData();
        userData.put((UserField)HDUsersAndGroups.FIELD_GROUP_ID, (Object)this.groupID);
        UserAccount userAccount = HDUsersAndGroups.getUserAccount(this.userID);
        if (userAccount == null) {
            String errorMsg = String.format("Could not add user with ID %d to group with ID %d because account for specified user does not exist.", this.userID, this.groupID);
            HDLogger.error(errorMsg);
            return true;
        }
        try {
            UserManager.getInstance().updateUserData(userAccount.getID(), userData);
        }
        catch (IllegalArgumentException ex) {
            String errorMsg = String.format("Could not add user with ID %d to group with ID %d because of following error:", this.userID, this.groupID);
            HDLogger.error(errorMsg);
            HDLogger.error(ex);
        }
        return true;
    }
}

