/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic.deviceimport;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class MappingHandler {
    protected static final String[] MY_COLUMNS = new String[]{"GerBezeichnung", "Anlagennummer", "Kostenstelle", "GerFeld1", "Computername", "Zimmer", "Seriennummer", "Rechnungsnummer", "GerFeld2", "GerFeld3", "GerFeld4", "GerFeld5", "GerFeld6", "GerFeld7", "GerFeld8", "GerFeld9", "Beschreibung"};
    protected static final int[] MY_COLUMN_LENGTHS = new int[]{50, 50, 50, 50, 255, 50, 50, 50, 50, 50, 255, 255, 100, 100, 100, 100, 4000};
    private String[] currentColumnMapping = new String[17];

    public MappingHandler(String mappedColumns) {
        String[] parts;
        int writePos = 0;
        for (String attrName : parts = mappedColumns.split("<>")) {
            this.currentColumnMapping[writePos] = attrName.trim().length() > 0 ? attrName : null;
            ++writePos;
        }
        if (mappedColumns.length() - mappedColumns.replace("<>", "").length() < 32) {
            this.currentColumnMapping[16] = this.currentColumnMapping[12];
            this.currentColumnMapping[12] = null;
        }
    }

    protected List<MappedColumn> getMappedColumns() {
        return this.getListOfColumnsToSelect(new String[0]);
    }

    @Nonnull
    protected ArrayList<MappedColumn> getListOfColumnsToSelect(@Nonnull String[] additionals) {
        int i;
        ArrayList<MappedColumn> list = new ArrayList<MappedColumn>();
        int internalKey = -1;
        for (i = 0; i < additionals.length; ++i) {
            list.add(new MappedColumn(null, additionals[i], internalKey--, -1));
        }
        for (i = 0; i < this.currentColumnMapping.length; ++i) {
            if (this.currentColumnMapping[i] == null) continue;
            list.add(new MappedColumn(MY_COLUMNS[i], this.currentColumnMapping[i], i, MY_COLUMN_LENGTHS[i]));
        }
        return list;
    }

    protected class MappedColumn {
        private final int modelIndex;
        private final int maxValueLength;
        private final String internalColumnName;
        private final String sourceColumnName;

        private MappedColumn(String internalColumnName, String sourceColumnName, int modelIndex, int maxValueLength) {
            this.internalColumnName = internalColumnName;
            this.sourceColumnName = sourceColumnName;
            this.modelIndex = modelIndex;
            this.maxValueLength = maxValueLength;
        }

        protected boolean allowsMultiRows() {
            return this.modelIndex == MY_COLUMNS.length - 1;
        }

        protected int getMaxValueLength() {
            return this.maxValueLength;
        }

        protected String getInternalColumnName() {
            return this.internalColumnName;
        }

        protected String getSourceColumnName() {
            return this.sourceColumnName;
        }
    }
}

