/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic.deviceimport;

import com.inet.classloader.I18nMessages;
import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.config.LdapConnectionInfo;
import com.inet.helpdesk.core.data.DataImportJob;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.annotation.SuppressFBWarnings;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import srv.automatic.GeraeteImporter;
import srv.automatic.LdapFormatHandler;
import srv.automatic.LdapUtilities;
import srv.automatic.deviceimport.AbstractDeviceImporter;
import srv.automatic.deviceimport.DbDeviceImporter;
import srv.automatic.deviceimport.DeviceImportingException;
import srv.automatic.deviceimport.MappingHandler;

public class LdapDeviceImporter
extends AbstractDeviceImporter {
    private static final int PAGE_SIZE = 500;
    private InitialLdapContext ctxLDAP = null;
    private LdapConnectionInfo ldapConn;
    private static final I18nMessages I18N = new I18nMessages("com.inet.helpdesk.data.i18n.LanguageResources", DbDeviceImporter.class);

    public LdapDeviceImporter(LdapConnectionInfo ldapConn) throws NamingException {
        this.ldapConn = ldapConn;
        this.ctxLDAP = this.getDirContextInternal(ldapConn);
    }

    public InitialLdapContext getDirContextInternal(LdapConnectionInfo ldapConn) throws NamingException {
        return LdapUtilities.getDirContext(ldapConn);
    }

    @Override
    public HashMap<String, Integer> replaceOwnKey(HashMap<String, Integer> userHm, String objKlasse, String keyAttr, String userNameAttr, String filter) throws DeviceImportingException {
        try {
            HashMap<String, Integer> newHm;
            block9: {
                String[] atts;
                if (keyAttr == null || objKlasse == null || userNameAttr == null || keyAttr.isEmpty() || objKlasse.isEmpty() || userNameAttr.isEmpty()) {
                    throw new DeviceImportingException(new IllegalArgumentException(I18N.getMsg("dataImport.userImport.noUserReference", new Object[0])));
                }
                newHm = new HashMap<String, Integer>();
                LdapSearchOptions lso = new LdapSearchOptions();
                lso.ctx = this.ctxLDAP;
                lso.searchContextValues = LdapUtilities.getSearchContext(lso.ctx, filter);
                if (keyAttr.equals("dnX")) {
                    lso.spezDN = true;
                    atts = new String[1];
                } else {
                    atts = new String[2];
                    atts[1] = keyAttr;
                }
                atts[0] = userNameAttr;
                lso.sc = LdapUtilities.getSearchControls(atts);
                try {
                    this.executeReplaceOwnKey(userHm, newHm, objKlasse, keyAttr, userNameAttr, lso);
                }
                catch (OperationNotSupportedException onse) {
                    this.logger.error((Object)onse);
                    if (lso.searchExecutions != 0) break block9;
                    try {
                        lso.ctx.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    lso.pagedSearch = false;
                    lso.ctx = LdapUtilities.getDirContext(this.ldapConn);
                    this.executeReplaceOwnKey(userHm, newHm, objKlasse, keyAttr, userNameAttr, lso);
                }
            }
            return newHm;
        }
        catch (Exception exc) {
            throw new DeviceImportingException(exc);
        }
    }

    @SuppressFBWarnings(value={"LDAP_INJECTION"}, justification="custom ldap query is expected")
    private void executeReplaceOwnKey(HashMap<String, Integer> userHm, HashMap<String, Integer> newHm, String objKlasse, String keyAttr, String userNameAttr, LdapSearchOptions lso) throws NamingException, IOException {
        Attributes attrs = null;
        NamingEnumeration<SearchResult> enumeration = null;
        String addString = null;
        for (String searchContext : lso.searchContextValues) {
            if ((searchContext = LdapDeviceImporter.removeBlanks(searchContext)).length() > 0) {
                addString = "," + searchContext;
            }
            byte[] cookie = null;
            if (lso.pagedSearch) {
                lso.ctx.setRequestControls(new Control[]{new PagedResultsControl(500, true)});
            }
            do {
                enumeration = lso.ctx.search(searchContext, "objectClass=" + objKlasse, lso.sc);
                ++lso.searchExecutions;
                while (LdapUtilities.enumerationHasMore(enumeration)) {
                    Integer realUserId;
                    Object fremdKey = null;
                    String userName = null;
                    SearchResult sr = (SearchResult)enumeration.nextElement();
                    attrs = sr.getAttributes();
                    Attribute attr = attrs.get(userNameAttr);
                    if (attr != null && attr.size() == 1) {
                        userName = attr.get().toString();
                    }
                    if ((userName = GeraeteImporter.normalizeName(userName)) == null || (realUserId = userHm.get(userName)) == null) continue;
                    if (lso.spezDN) {
                        fremdKey = sr.getName();
                        if (addString != null) {
                            fremdKey = (String)fremdKey + addString;
                        }
                        if (this.logger.isDebug()) {
                            this.logger.debug((Object)("User mapping: '" + userName + "' -> '" + realUserId + "' ref '" + (String)fremdKey + "'"));
                        }
                        this.putKontrolle(newHm, (String)fremdKey, realUserId);
                        continue;
                    }
                    attr = attrs.get(keyAttr);
                    if (attr == null) continue;
                    for (int i = 0; i < attr.size(); ++i) {
                        if (this.logger.isDebug()) {
                            this.logger.debug((Object)("User mapping: '" + userName + "' -> '" + realUserId + "' ref '" + attr.get(i).toString() + "'"));
                        }
                        this.putKontrolle(newHm, attr.get(i).toString(), realUserId);
                    }
                }
                try {
                    enumeration.close();
                }
                catch (Exception sr) {
                    // empty catch block
                }
                if (!lso.pagedSearch) continue;
                Control[] controls = lso.ctx.getResponseControls();
                if (controls != null) {
                    for (Control control : controls) {
                        if (!(control instanceof PagedResultsResponseControl)) continue;
                        PagedResultsResponseControl prrc = (PagedResultsResponseControl)control;
                        cookie = prrc.getCookie();
                    }
                }
                lso.ctx.setRequestControls(new Control[]{new PagedResultsControl(500, cookie, true)});
            } while (cookie != null);
        }
    }

    @Override
    public List<Map<String, String>> doImport(DataImportJob dataImportJob, Map<Integer, Integer> userGebs, HashMap<String, Integer> userHm, Connection conHD, DeviceImportConfigInfo importConfig, String name, String filter, int newVersID, int gerTyp, MappingHandler mappingHandler, String nameRef, boolean indirekt, AbstractDeviceImporter.RowAddedListener listener) throws Exception {
        List<Map<String, String>> result;
        block5: {
            ArrayList<MappingHandler.MappedColumn> requiredAttributes = mappingHandler.getListOfColumnsToSelect(new String[0]);
            ArrayList<String> attributeNames = new ArrayList<String>();
            attributeNames.add(nameRef);
            for (MappingHandler.MappedColumn attribute : requiredAttributes) {
                String colName = attribute.getSourceColumnName();
                if (attributeNames.contains(colName) || "dnX".equals(colName)) continue;
                attributeNames.add(colName);
            }
            LdapSearchOptions lso = new LdapSearchOptions();
            lso.sc = LdapUtilities.getSearchControls(attributeNames.toArray(new String[attributeNames.size()]));
            lso.ctx = this.ctxLDAP;
            lso.searchContextValues = LdapUtilities.getSearchContext(lso.ctx, filter);
            lso.indirekt = indirekt;
            this.prepareAllStatements(conHD, name, newVersID, gerTyp, mappingHandler);
            result = null;
            try {
                result = this.executeDoImport(dataImportJob, userGebs, userHm, importConfig, nameRef, lso, requiredAttributes, listener, conHD);
            }
            catch (OperationNotSupportedException onse) {
                this.logger.error((Object)onse);
                if (lso.searchExecutions != 0) break block5;
                try {
                    lso.ctx.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                lso.pagedSearch = false;
                lso.ctx = LdapUtilities.getDirContext(this.ldapConn);
                result = this.executeDoImport(dataImportJob, userGebs, userHm, importConfig, nameRef, lso, requiredAttributes, listener, conHD);
            }
        }
        this.closeAllStatements();
        return result;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC", "LDAP_INJECTION"}, justification="internally created statement, custom ldap query is expected")
    private List<Map<String, String>> executeDoImport(DataImportJob dataImportJob, Map<Integer, Integer> userGebs, HashMap<String, Integer> userHm, DeviceImportConfigInfo importConfig, String nameRef, LdapSearchOptions lso, ArrayList<MappingHandler.MappedColumn> requiredAttributes, AbstractDeviceImporter.RowAddedListener listener, Connection conHD) throws Exception {
        String addString = null;
        Attributes attrs = null;
        NamingEnumeration<SearchResult> enumeration = null;
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        String[] dataBuf = new String[requiredAttributes.size()];
        String importSourceClass = importConfig.getImportSource();
        Vector<AbstractDeviceImporter.DeviceData> existingDeviceData = new Vector<AbstractDeviceImporter.DeviceData>();
        int gerType = importConfig.getGerTyp();
        for (String searchContext : lso.searchContextValues) {
            if ((searchContext = LdapDeviceImporter.removeBlanks(searchContext)).length() > 0) {
                addString = "," + searchContext;
            }
            this.logger.info((Object)("searchContext: '" + searchContext + "' objectClass '" + importSourceClass + "' Username-Attribut '" + nameRef + "'"));
            byte[] cookie = null;
            if (lso.pagedSearch) {
                lso.ctx.setRequestControls(new Control[]{new PagedResultsControl(500, true)});
            }
            do {
                enumeration = lso.ctx.search(searchContext, "objectClass=" + importSourceClass, lso.sc);
                ++lso.searchExecutions;
                ArrayList<String[]> exampleBuffer = new ArrayList<String[]>();
                while (LdapUtilities.enumerationHasMore(enumeration)) {
                    int datensatzCount;
                    ++this.available;
                    dataImportJob.incrementDataCount();
                    SearchResult sr = (SearchResult)enumeration.nextElement();
                    attrs = sr.getAttributes();
                    Object dnString = sr.getName();
                    if (addString != null) {
                        dnString = (String)dnString + addString;
                    }
                    Attribute nameAttr = attrs.get(nameRef);
                    if (((String)dnString).length() > 250) {
                        dnString = ((String)dnString).substring(0, 250);
                    }
                    if (nameAttr != null && (datensatzCount = nameAttr.size()) > 0) {
                        int i;
                        userIds.clear();
                        for (i = 0; i < datensatzCount; ++i) {
                            Integer uId;
                            String test = nameAttr.get(i).toString();
                            if (!lso.indirekt) {
                                test = GeraeteImporter.normalizeName(test);
                            }
                            if ((uId = userHm.get(test)) == null) continue;
                            userIds.add(uId);
                        }
                        if (userIds.size() > 0) {
                            for (i = 0; i < requiredAttributes.size(); ++i) {
                                String attrName = requiredAttributes.get(i).getSourceColumnName();
                                try {
                                    if ("dnX".equals(attrName)) {
                                        dataBuf[i] = dnString;
                                    } else {
                                        Attribute someAttr = attrs.get(attrName);
                                        if (someAttr != null) {
                                            if (!requiredAttributes.get(i).allowsMultiRows()) {
                                                dataBuf[i] = LdapFormatHandler.handleLdapFormat(attrName, someAttr.get().toString());
                                            } else {
                                                int countMemo = someAttr.size();
                                                StringBuffer buf = new StringBuffer();
                                                for (int n = 0; n < countMemo; ++n) {
                                                    buf.append(someAttr.get(n)).append('\n');
                                                }
                                                dataBuf[i] = buf.toString();
                                            }
                                        } else {
                                            dataBuf[i] = null;
                                        }
                                    }
                                    if (dataBuf[i] == null || dataBuf[i].length() <= requiredAttributes.get(i).getMaxValueLength()) continue;
                                    dataBuf[i] = dataBuf[i].substring(0, requiredAttributes.get(i).getMaxValueLength());
                                    continue;
                                }
                                catch (Throwable e) {
                                    dataBuf[i] = null;
                                    this.logger.error((Object)e);
                                }
                            }
                            if (dataBuf[0] == null || dataBuf[0].length() == 0) {
                                dataImportJob.incrementErrorsCount();
                                this.logger.info((Object)("Daten inkonsistent f\u00fcr '" + (String)dnString + "'"));
                                continue;
                            }
                            if (listener != null) {
                                exampleBuffer.add((String[])dataBuf.clone());
                                if (!listener.finishedWithRowCount(exampleBuffer.size())) continue;
                                break;
                            }
                            existingDeviceData.removeAllElements();
                            this.checkBestand((String)dnString, userIds, existingDeviceData);
                            if (existingDeviceData.size() > 0) {
                                this.logger.debug((Object)("Update Anzahl: " + existingDeviceData.size()));
                                for (AbstractDeviceImporter.DeviceData devDat : existingDeviceData) {
                                    if (this.compareData(devDat.getData(), dataBuf) && devDat.gerTyp == gerType) {
                                        this.updateVersion(devDat.getId());
                                        continue;
                                    }
                                    this.setUpdateData(this.pstSimpleUpdate, null, dataBuf, 1);
                                    this.pstSimpleUpdate.setInt(requiredAttributes.size() + 1, existingDeviceData.elementAt(0).getId());
                                    this.pstSimpleUpdate.execute();
                                    ++this.updates;
                                    dataImportJob.incrementUpdatedCount();
                                }
                            }
                            if (userIds.size() <= 0) continue;
                            this.logger.debug((Object)("Insert Anzahl: " + userIds.size()));
                            this.pstInsert.setString(1, (String)dnString);
                            this.setUpdateData(this.pstInsert, null, dataBuf, 4);
                            for (int i2 = 0; i2 < userIds.size(); ++i2) {
                                Integer userId = (Integer)userIds.get(i2);
                                this.pstInsert.setInt(2, userId);
                                this.pstInsert.setInt(3, userGebs.get(userId));
                                try {
                                    this.pstInsert.execute();
                                    ++this.newImports;
                                }
                                catch (Exception ex) {
                                    dataImportJob.incrementErrorsCount();
                                    this.logger.error((Object)ex);
                                    this.logger.debug((Object)("dnString:-" + (String)dnString + "-"));
                                    this.logger.debug((Object)("un:-" + userId + "-"));
                                    this.logger.debug((Object)("Geb:-" + userGebs.get(userId) + "-"));
                                    try {
                                        this.pstInsert.close();
                                    }
                                    catch (Throwable buf) {
                                        // empty catch block
                                    }
                                    this.pstInsert = conHD.prepareStatement(this.theInsertStatement);
                                    this.pstInsert.setString(1, (String)dnString);
                                    this.setUpdateData(this.pstInsert, requiredAttributes, dataBuf, 4);
                                }
                                dataImportJob.incrementAddedCount();
                            }
                            continue;
                        }
                        dataImportJob.incrementErrorsCount();
                        this.logger.info((Object)("Keine User f\u00fcr '" + (String)dnString + "' gefunden"));
                        continue;
                    }
                    dataImportJob.incrementErrorsCount();
                    this.logger.info((Object)("Kein Eintrag f\u00fcr Attribut '" + nameRef + "' in '" + (String)dnString + "'"));
                }
                try {
                    enumeration.close();
                }
                catch (Exception sr) {
                    // empty catch block
                }
                if (listener != null) {
                    return this.createEntrys(exampleBuffer, requiredAttributes);
                }
                if (!lso.pagedSearch) continue;
                Control[] controls = lso.ctx.getResponseControls();
                if (controls != null) {
                    for (Control control : controls) {
                        if (!(control instanceof PagedResultsResponseControl)) continue;
                        PagedResultsResponseControl prrc = (PagedResultsResponseControl)control;
                        cookie = prrc.getCookie();
                    }
                }
                lso.ctx.setRequestControls(new Control[]{new PagedResultsControl(500, cookie, true)});
            } while (cookie != null);
        }
        return null;
    }

    @Override
    public void cleanup() {
        try {
            this.ctxLDAP.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.ctxLDAP = null;
    }

    private void checkBestand(String uniqueName, List<Integer> users, Vector<AbstractDeviceImporter.DeviceData> gerids) throws SQLException {
        this.pstSelect.setString(2, uniqueName);
        ResultSet rs = this.pstSelect.executeQuery();
        while (rs.next()) {
            int index;
            AbstractDeviceImporter.DeviceData devDat = this.getDataFromResultSet(rs);
            if (devDat.getUserId() == null || (index = users.indexOf(devDat.getUserId())) <= -1) continue;
            users.remove(index);
            gerids.addElement(devDat);
        }
    }

    private class LdapSearchOptions {
        private int searchExecutions = 0;
        private boolean pagedSearch = true;
        private boolean indirekt = false;
        private boolean spezDN = false;
        private InitialLdapContext ctx;
        private SearchControls sc;
        private String[] searchContextValues;

        private LdapSearchOptions() {
        }
    }
}

