/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.LdapConnectionInfo;
import com.inet.helpdesk.config.LdapConnectionInfoMap;
import com.inet.helpdesk.config.UserImportConfigInfo;
import com.inet.helpdesk.config.UserImportConfigInfoMap;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.DataImportJob;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVOManager;
import com.inet.helpdesk.data.UserDataConnectorImpl;
import com.inet.helpdesk.usersandgroups.HDFieldLocator;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.UserIterator;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import srv.HdLicenseObserver;
import srv.ServerUtilities;
import srv.automatic.CIHashMap;
import srv.automatic.FieldImportRules;
import srv.automatic.LdapFormatHandler;
import srv.automatic.LdapUtilities;
import srv.automatic.StringIntHashMap;

public class UserImporter {
    static final char[] BUCHSTABEN = new char[]{'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'p', 'q', 'r', 't', 'v', 'w', 'x', 'y', 'z'};
    static final String ACCOUNT_CONTROL = "userAccountControl";
    static final String HIDE_FROM_ADDRESSLISTS = "msExchHideFromAddressLists";
    static final int ACCOUNT_DISABLED = 2;
    protected static final int[] DB_COLUMN_SIZES = new int[]{100, 50, 50, 50, 50, 50, 50, 100, 100, 50, 255, 255, 255, 255, 255, -1};
    static final String[] DB_COLUMNS = new String[]{"Username", "Nachname", "Vorname", "GebID", "BgrID", "Telefon", "Zimmer", "Abteilung", "Email", "Kostenstelle", "Frei1", "Frei2", "Frei3", "Frei4", "Frei5", "Frei6"};
    static final String[] DB_COLUMNS_DISPLAY = new String[]{"Username", "Nachname", "Vorname", "GebID", "BgrID", "Telefon", "Zimmer", "Abteilung", "Email", "Kostenstelle", "Frei1", "Frei2", "Frei3", "Frei4", "Frei5", "Frei6", "Supervisor"};
    private static final int PAGE_SIZE = 500;
    private static long ATTRIBUTE_BUFFER_TIME = 10000L;
    private static String bufferKey;
    private static ArrayList<String> bufferdAttributes;
    private static long lastRequested;
    private UserImportConfigInfo importConfigInfo;
    private boolean locationDaten;
    private boolean benutzerGruppenDaten;
    private boolean supervisorDaten;
    private static boolean userAccountControlAvailable;
    private static boolean userHideFromListAvailable;
    private int lizenzCounter;
    private int userUpdateCounter;
    private int newUserCounter;
    private static boolean killed;
    private int locationInsertCounter;
    private int bgrInsertCounter;
    private String[] attrListe;
    private int userCount;
    private int bufferedData;
    private StringIntHashMap entrysPerImport;
    protected static final int USERNAME_POSITION = 0;
    protected static final int SURNAME_POSITION = 1;
    protected static final int GIVENNAME_POSITION = 2;
    protected static final int LOCATION_POSITION = 3;
    protected static final int USERGROUP_POSITION = 4;
    protected static final int EMAIL_POSITION = 8;
    protected static final int SUPERVISOR_POSITION = 16;
    private String[] readColumns = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    private StringIntHashMap locations;
    private StringIntHashMap benutzergruppen;
    private HashMap<String, UserDataSet> userLogins;
    private UserField<Object> importNameField;
    private int standardGeb;
    private int standardBenGr;
    private int globaleVersion;
    private String standardSprache;
    private String objVersionString;
    private boolean needSpezialDN;
    private String defaultSnColumn;
    private String spezialDNadd;
    private static ConfigValue<UserImportConfigInfoMap> USER_IMPORT_CONFIGS;
    private static final ConfigValue<LdapConnectionInfoMap> LDAP_CONNECTION_INFOS;
    private static final ConfigValue<DatabaseConfigInfoList> DB_INFOS;
    private static final Logger logger;
    private static final Object MONITOR_OBJECT;
    private static final I18nMessages MSG;
    private static final int ID_UNAVAILABLE = -1;
    private static final int ID_ALREADY_TREATED = -2;
    private static final int ID_INACTIVE = -3;
    private static final int ID_NOT_RELEVANT = -4;

    public UserImporter() {
        killed = false;
    }

    public UserImporter(UserImportConfigInfo userImportConfigInfo) {
        this.importConfigInfo = userImportConfigInfo;
        killed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserImporter(boolean zeitTest, UserImportConfigInfo userImportConfigInfo, DataImportJob dataImportJob) {
        try {
            this.importConfigInfo = userImportConfigInfo;
            DataImportConnector dataImportConnector = (DataImportConnector)ServerPluginManager.getInstance().getSingleInstance(DataImportConnector.class);
            if (zeitTest && !dataImportConnector.isTimeForJob(userImportConfigInfo.getUid(), userImportConfigInfo.getSchedule(), ServerUtilities.getCalendar())) {
                return;
            }
            logger.info((Object)"Start User Import");
            if (userImportConfigInfo.isLdap()) {
                LdapConnectionInfoMap ldapConns = (LdapConnectionInfoMap)LDAP_CONNECTION_INFOS.get();
                LdapConnectionInfo ldapConn = ldapConns.get(userImportConfigInfo.getConnectionName());
                if (ldapConn == null) {
                    throw new IllegalArgumentException(MSG.getMsg("dataImport.noConnectionFound", new Object[]{userImportConfigInfo.getConnectionName()}));
                }
                this.runForLdap(dataImportJob, new ReadAndImportRecordStateFactory(), ldapConn, zeitTest, userImportConfigInfo);
                return;
            }
            DatabaseConfigInfoList list = (DatabaseConfigInfoList)DB_INFOS.get();
            DatabaseConfigInfo dbConn = list.get(userImportConfigInfo.getConnectionName());
            if (dbConn == null) {
                throw new IllegalArgumentException(MSG.getMsg("dataImport.noConnectionFound", new Object[]{userImportConfigInfo.getConnectionName()}));
            }
            this.runForSqlDb(dataImportJob, new ReadAndImportRecordStateFactory(), dbConn, userImportConfigInfo);
        }
        catch (Throwable t) {
            logger.error((Object)t);
            String error = StringFunctions.getUserFriendlyErrorMessage((Throwable)t);
            if (error.isEmpty()) {
                error = MSG.getMsg("dataImport.userImport.importFailed", new Object[0]);
            }
            dataImportJob.setError(error);
        }
        finally {
            if (dataImportJob != null) {
                if (dataImportJob.getStartTime() == 0L) {
                    dataImportJob.setStartTime(System.currentTimeMillis());
                }
                if (dataImportJob.getEndTime() == 0L) {
                    dataImportJob.setEndTime(System.currentTimeMillis());
                }
            }
            HdLicenseObserver.resetLicenseCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="The SQL for ther query is internally created")
    public ReadRecordState runForSqlDb(DataImportJob dataImportJob, ReadRecordStateFactory readRecordStateFactory, DatabaseConfigInfo dbConn, UserImportConfigInfo userImportConfigInfo) {
        if (dataImportJob == null) {
            dataImportJob = new DataImportJob();
        }
        long start = System.currentTimeMillis();
        StringBuffer sql = new StringBuffer("SELECT ");
        try {
            dataImportJob.setStartTime(start);
            logger.debug((Object)"SQL Import called");
            Statement stQuelle = null;
            ResultSet rsQuelle = null;
            Connection conQuelle = null;
            String[] dataBuffer = new String[DB_COLUMNS.length + 1];
            try {
                ReadRecordState readRecordState;
                this.setImportOptions(userImportConfigInfo, false);
                this.fetchStartData(UserManager.getInstance(), userImportConfigInfo.getUid());
                conQuelle = UserImporter.getConnection(dbConn);
                String quotString = conQuelle.getMetaData().getIdentifierQuoteString();
                sql.append(quotString).append(this.attrListe[0]).append(quotString);
                for (int i = 1; i < this.attrListe.length; ++i) {
                    sql.append(", ").append(quotString).append(this.attrListe[i]).append(quotString);
                }
                sql.append(" FROM ");
                if (DatabaseConfigInfo.DatabaseType.odbc.equals((Object)dbConn.getDriver())) {
                    sql.append(quotString).append(userImportConfigInfo.getTable()).append(quotString);
                } else {
                    sql.append(userImportConfigInfo.getTable());
                }
                String query = DatabaseConfigInfo.DatabaseType.inetora.equals((Object)dbConn.getDriver()) ? sql.toString().toUpperCase() : sql.toString();
                stQuelle = conQuelle.createStatement();
                rsQuelle = stQuelle.executeQuery(query);
                while (rsQuelle.next() && !killed) {
                    if (this.fillDataBuffer(rsQuelle, dataBuffer)) {
                        readRecordState = readRecordStateFactory.createReadRecordState(dataImportJob, userImportConfigInfo.getUid(), userImportConfigInfo.isAlle(), userImportConfigInfo.isReaktivieren(), dataBuffer).invoke();
                        if (!readRecordStateFactory.isFinished(true)) continue;
                        ReadRecordState readRecordState2 = readRecordState;
                        return readRecordState2;
                    }
                    logger.debug((Object)("Daten nicht plausibel: " + dataBuffer[0]));
                }
                if (readRecordStateFactory.isFinished(false)) {
                    readRecordState = readRecordStateFactory.getLastState();
                    return readRecordState;
                }
                if (userImportConfigInfo.isLoeschen() && !killed) {
                    this.delete(dataImportJob, userImportConfigInfo.isSupporterLoeschen(), userImportConfigInfo.getUid());
                }
                logger.info((Object)("Add " + dataImportJob.getEntriesAdded() + " count " + dataImportJob.getEntriesCount() + " errors " + dataImportJob.getEntriesError()));
                if (this.supervisorDaten) {
                    this.handleSupervisedGroups(dataImportJob, userImportConfigInfo.getUid());
                    logger.info((Object)("Supervisor add " + dataImportJob.getEntriesAddedSupervisors() + " supervisor remove " + dataImportJob.getEntriesDeletedSupervisors()));
                }
                if (this.lizenzCounter > 0) {
                    String errorMessage = MSG.getMsg("dataImport.userImport.licenseCount", new Object[]{this.lizenzCounter});
                    logger.error((Object)errorMessage);
                    dataImportJob.setError(errorMessage);
                }
            }
            catch (Throwable e) {
                logger.error((Object)("SQL: " + sql.toString()));
                logger.error((Object)e);
                String message = StringFunctions.getUserFriendlyErrorMessage((Throwable)e);
                dataImportJob.setError(message);
            }
            finally {
                try {
                    rsQuelle.close();
                }
                catch (Throwable throwable) {}
                try {
                    stQuelle.close();
                }
                catch (Throwable throwable) {}
                try {
                    conQuelle.close();
                }
                catch (Throwable throwable) {}
            }
            if (this.bgrInsertCounter > 0) {
                ServerUtilities.conti.setChanged(8, true);
            }
            if (this.locationInsertCounter <= 0) return null;
            ServerUtilities.conti.setChanged(2, true);
            return null;
        }
        finally {
            long endZeit = System.currentTimeMillis();
            long dauer = endZeit - start;
            dataImportJob.setEndTime(endZeit);
            logger.info((Object)("User-Import fertig: " + dauer + "ms " + this.userUpdateCounter + " updates  " + this.newUserCounter + " imports!"));
        }
    }

    public void work() {
        UserImportConfigInfoMap userImportConfigs = (UserImportConfigInfoMap)USER_IMPORT_CONFIGS.get();
        DataImportConnector dataImportConnector = (DataImportConnector)ServerPluginManager.getInstance().getSingleInstance(DataImportConnector.class);
        HashMap<String, DataImportJob> jobs = new HashMap<String, DataImportJob>();
        for (String userImportConfigKey : userImportConfigs.keySet()) {
            UserImportConfigInfo userImportConfigInfo = (UserImportConfigInfo)userImportConfigs.get(userImportConfigKey);
            if (dataImportConnector.getJobs(userImportConfigInfo.getUid()).stream().filter(DataImportJob::isRunning).count() > 0L || !dataImportConnector.isTimeForJob(userImportConfigInfo.getUid(), userImportConfigInfo.getSchedule(), ServerUtilities.getCalendar())) continue;
            jobs.put(userImportConfigKey, dataImportConnector.createJob(userImportConfigInfo.getUid()));
        }
        new Thread(() -> {
            Object object = MONITOR_OBJECT;
            synchronized (object) {
                for (String userImportConfigKey : userImportConfigs.keySet()) {
                    try {
                        UserImportConfigInfo userImportConfigInfo = (UserImportConfigInfo)userImportConfigs.get(userImportConfigKey);
                        new UserImporter(true, userImportConfigInfo, (DataImportJob)jobs.get(userImportConfigKey));
                    }
                    catch (Throwable e) {
                        logger.error((Object)e);
                    }
                }
            }
        }, "UserImport - Scheduled").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runNow(UserImportConfigInfo userImportConfigInfo, DataImportJob dataImportJob) {
        Object object = MONITOR_OBJECT;
        synchronized (object) {
            logger.info((Object)"Start manual User Import");
            try {
                new UserImporter(false, userImportConfigInfo, dataImportJob);
            }
            catch (Throwable e) {
                logger.error((Object)e);
            }
        }
    }

    private boolean fillDataBuffer(ResultSet rs, String[] buf) throws SQLException {
        for (int i = 0; i < this.readColumns.length; ++i) {
            if (this.readColumns[i].length() <= 0) continue;
            String value = rs.getString(this.readColumns[i]);
            if (value == null) {
                value = "";
            }
            buf[i] = value;
        }
        return this.checkUser(buf);
    }

    /*
     * Exception decompiling
     */
    public ReadRecordState runForLdap(DataImportJob dataImportJob, ReadRecordStateFactory readRecordStateFactory, LdapConnectionInfo ldapConn, boolean startOption, UserImportConfigInfo userImportConfigInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 10[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @SuppressFBWarnings(value={"LDAP_INJECTION"}, justification="The LDAP statement is genrerated internally")
    private ReadRecordState executeLdapSearch(InitialLdapContext ctx, String[] searchItems, DataImportJob dataImportJob, LdapConnectionInfo ldapConn, ReadRecordStateFactory readRecordStateFactory, LdapSearchOptions lso) throws NamingException, IOException {
        String[] dataBuffer = new String[DB_COLUMNS.length + 1];
        for (String searchContext : lso.searchContextValues) {
            if (searchContext.length() > 0 && this.needSpezialDN) {
                this.spezialDNadd = "," + searchContext;
            }
            for (String searchItem : searchItems) {
                if (killed) {
                    return null;
                }
                logger.debug((Object)("SEARCH: " + searchContext + " - " + searchItem));
                byte[] cookie = null;
                if (lso.pagedSearch) {
                    ctx.setRequestControls(new Control[]{new PagedResultsControl(500, true)});
                }
                do {
                    NamingEnumeration<SearchResult> enumeration = ctx.search(searchContext, searchItem, LdapUtilities.getSearchControls(this.attrListe));
                    ++lso.searchExecutions;
                    while (LdapUtilities.enumerationHasMore(enumeration)) {
                        Object uhfl;
                        Object uac;
                        Attribute attr;
                        SearchResult sr = (SearchResult)enumeration.nextElement();
                        Attributes attrs = sr.getAttributes();
                        String invalidReason = "";
                        if (userAccountControlAvailable && (attr = attrs.get(ACCOUNT_CONTROL)) != null && (uac = attr.get()) != null && (Integer.parseInt(uac.toString()) & 2) != 0) {
                            invalidReason = "Disabled";
                        }
                        if (userHideFromListAvailable && (attr = attrs.get(HIDE_FROM_ADDRESSLISTS)) != null && (uhfl = attr.get()) != null && "TRUE".equals(uhfl)) {
                            invalidReason = "Hidden";
                        }
                        if (invalidReason.length() == 0) {
                            if (this.fillDataBuffer(attrs, dataBuffer, sr)) {
                                dataBuffer[0] = this.plusDomain(dataBuffer[0]);
                                ReadRecordState recordState = readRecordStateFactory.createLdapReadRecordState(dataImportJob, lso.importName, lso.startOption, lso.inserten, lso.reaktivieren, logger, dataBuffer, attrs).invoke();
                                if (!readRecordStateFactory.isFinished(true)) continue;
                                return recordState;
                            }
                            logger.debug((Object)("Daten nicht plausibel: " + dataBuffer[0]));
                            continue;
                        }
                        attr = attrs.get(this.readColumns[0]);
                        dataBuffer[0] = attr != null ? attr.get().toString() : "Unknown";
                        logger.debug((Object)(invalidReason + " Account: " + dataBuffer[0]));
                    }
                    try {
                        enumeration.close();
                    }
                    catch (Exception sr) {
                        // empty catch block
                    }
                    if (readRecordStateFactory.isFinished(false)) {
                        return readRecordStateFactory.getLastState();
                    }
                    if (!lso.pagedSearch) continue;
                    Control[] controls = ctx.getResponseControls();
                    if (controls != null) {
                        for (Control control : controls) {
                            if (!(control instanceof PagedResultsResponseControl)) continue;
                            PagedResultsResponseControl prrc = (PagedResultsResponseControl)control;
                            cookie = prrc.getCookie();
                        }
                    }
                    ctx.setRequestControls(new Control[]{new PagedResultsControl(500, cookie, true)});
                } while (cookie != null);
            }
        }
        return null;
    }

    private String getDisplayableMessage(int id) {
        if (id < 0) {
            switch (id) {
                case -1: {
                    return "user does not exist in hd database";
                }
                case -2: {
                    return "user already updated";
                }
                case -3: {
                    return "user is disabled";
                }
                case -4: {
                    return "user is not relevant for this import";
                }
            }
        }
        return String.valueOf(id);
    }

    protected String uppercasePlusDomain(String username) {
        username = this.plusDomain(username);
        return username.toUpperCase();
    }

    private String plusDomain(String username) {
        if (((String)(username = ((String)username).replace('/', '\\'))).indexOf(92) == -1) {
            username = this.getDomain() + (String)username;
        }
        return username;
    }

    private String getDomain() {
        LdapConnectionInfo ldapConn = this.getCurrentLdapConnectionInfo();
        if (ldapConn != null && ldapConn.getDomaene() != null && ldapConn.getDomaene().length() > 0) {
            return ldapConn.getDomaene() + "\\";
        }
        return "";
    }

    protected LdapConnectionInfo getCurrentLdapConnectionInfo() {
        if (this.importConfigInfo.isLdap()) {
            LdapConnectionInfoMap ldapConns = (LdapConnectionInfoMap)LDAP_CONNECTION_INFOS.get();
            return ldapConns.get(this.importConfigInfo.getConnectionName());
        }
        return null;
    }

    private void reaktivieren(DataImportJob dataImportJob, String importName, String[] dataBuff) {
        UserDataSet theUser = this.getUserDataByName(dataBuff[0]);
        if (this.update(dataImportJob, importName, dataBuff, theUser.id, true)) {
            theUser.active = true;
            theUser.found = true;
            ++this.userCount;
            if (logger.isDebug()) {
                UserAccount userAccount = HDUsersAndGroups.getUserAccount(theUser.id);
                logger.debug((Object)("User: " + dataBuff[0] + " reactivation " + userAccount.isActive()));
            }
        } else {
            logger.debug((Object)("User: " + dataBuff[0] + " no reactivation."));
            dataImportJob.incrementErrorsCount();
        }
    }

    private boolean update(DataImportJob dataImportJob, String importName, String[] dataBuff, int usrID, boolean reaktivieren) throws IllegalStateException {
        boolean changedFlag = false;
        try {
            UserAccount userAccount = HDUsersAndGroups.getUserAccount(usrID);
            GUID accountId = userAccount.getID();
            if (reaktivieren) {
                if (userAccount.getValue((UserField)UsersAndGroups.FIELD_USER_LOCKED) != null) {
                    logger.warn((Object)("Account " + accountId.toString() + " is locked and can not be reactivated!"));
                    return false;
                }
                if (!userAccount.isActive()) {
                    UserManager.getInstance().setUserAccountActive(userAccount.getID());
                    changedFlag = true;
                    dataImportJob.incrementReactivatedCount();
                }
            }
            for (int i = 0; i < DB_COLUMNS.length; ++i) {
                UserField field;
                Object value;
                MutableUserData userData;
                String str = dataBuff[i];
                if (str == null) continue;
                if (str.length() > 0 && DB_COLUMN_SIZES[i] > -1 && str.length() > DB_COLUMN_SIZES[i]) {
                    str = str.substring(0, DB_COLUMN_SIZES[i]);
                }
                if (i == 0) {
                    boolean equal = false;
                    List logins = userAccount.getLoginSettingsFor("system");
                    for (LoginSettings ls : logins) {
                        String loginName = ls.getLoginID();
                        if (!this.normalizeForMap(str).equals(this.normalizeForMap(loginName))) continue;
                        equal = true;
                        break;
                    }
                    if (equal) continue;
                    ArrayList<LoginSettings> settingsToAdd = new ArrayList<LoginSettings>();
                    settingsToAdd.add(new LoginSettings("system", str, null));
                    ArrayList settingsToRemove = new ArrayList();
                    UserManager.getInstance().updateLoginSettings(accountId, settingsToAdd, settingsToRemove);
                    changedFlag = true;
                    continue;
                }
                if (i == 3) {
                    if (str.length() == 0) continue;
                    int neuerWert = this.getGebID(str);
                    UserField oldLocation = UserManager.getInstance().getField("location");
                    if ((Integer)userAccount.getValue(oldLocation) == neuerWert) continue;
                    userData = new MutableUserData();
                    userData.put(oldLocation, (Object)neuerWert);
                    UserManager.getInstance().updateUserData(accountId, userData);
                    changedFlag = true;
                    continue;
                }
                if (i == 4) {
                    if (str.length() == 0) continue;
                    int neuerWert = this.getBgrID(str);
                    UserField oldUsergroup = UserManager.getInstance().getField("groupid");
                    if ((Integer)userAccount.getValue(oldUsergroup) == neuerWert) continue;
                    userData = new MutableUserData();
                    userData.put(oldUsergroup, (Object)neuerWert);
                    UserManager.getInstance().updateUserData(accountId, userData);
                    changedFlag = true;
                    continue;
                }
                if (i == 8) {
                    try {
                        UserDataConnectorImpl.checkEmailReceivers(str);
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                        str = "";
                    }
                }
                if (str.contains("\n")) {
                    str = str.contains("\r\n") ? str.replaceAll("\r\n", "  ") : str.replace('\n', ' ');
                }
                if (this.compareEquals(str = UserImporter.testReplacement(str), value = userAccount.getValue(field = (UserField)HDFieldLocator.getUserFieldForDBKey(DB_COLUMNS[i])))) continue;
                userData = new MutableUserData();
                userData.put(field, (Object)str);
                UserManager.getInstance().updateUserData(accountId, userData);
                changedFlag = true;
            }
            Object importNameObject = userAccount.getValue(this.importNameField);
            if (importName != null && !importName.equals(importNameObject)) {
                MutableUserData userData = new MutableUserData();
                userData.put(this.importNameField, (Object)importName);
                UserManager.getInstance().updateUserData(accountId, userData);
                changedFlag = true;
            }
            if (changedFlag) {
                dataImportJob.incrementUpdatedCount();
                ++this.userUpdateCounter;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            dataImportJob.setError(e.getMessage());
            return false;
        }
        return true;
    }

    private boolean compareEquals(@Nonnull String str, Object compare) {
        if (str.length() == 0 && compare == null) {
            return true;
        }
        return str.equals(compare);
    }

    private static String testReplacement(@Nonnull String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) >= ' ') continue;
            char[] chars = str.toCharArray();
            for (int n = i; n < chars.length; ++n) {
                if (str.charAt(n) >= ' ') continue;
                chars[n] = 32;
            }
            return new String(chars);
        }
        return str;
    }

    private void bufferImportableData(String importName, String[] data, DataImportJob dataImportJob) {
        UserDataSet insertableUser = new UserDataSet(importName);
        if (this.handleNonImportableUser(insertableUser, data, dataImportJob)) {
            this.userLogins.put(this.normalizeForMap(data[0]), insertableUser);
        }
    }

    private boolean handleNonImportableUser(UserDataSet possibleUser, String[] dataBuffer, DataImportJob dataImportJob) {
        if (possibleUser.bufData == null) {
            dataImportJob.incrementErrorsCount();
            ++this.lizenzCounter;
            int currentAvailable = this.entrysPerImport.get(possibleUser.importKey) - dataImportJob.getEntriesCount();
            logger.debug((Object)("User: " + dataBuffer[0] + " buffer data! Unknown Licence count " + currentAvailable + " imported " + this.entrysPerImport.get(possibleUser.importKey)));
            if (this.bufferedData <= currentAvailable) {
                ++this.bufferedData;
                possibleUser.bufData = new String[dataBuffer.length];
                System.arraycopy(dataBuffer, 0, possibleUser.bufData, 0, dataBuffer.length);
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean loginNotOfThisImport(String username) {
        String domain = this.getDomain();
        return domain.length() > 0 && !username.startsWith(domain.toUpperCase());
    }

    private UserDataSet getUserDataByName(String name) {
        String currentDomain;
        String username = this.normalizeForMap(name);
        UserDataSet theUser = this.userLogins.get(username);
        if (theUser == null && (currentDomain = this.getDomain().toUpperCase()).length() > 0 && username.startsWith(currentDomain)) {
            username = username.substring(currentDomain.length());
            theUser = this.userLogins.get(username);
        }
        return theUser;
    }

    private int getUserID(String[] dataBuffer, String importName) {
        UserDataSet theUser = this.getUserDataByName(dataBuffer[0]);
        if (theUser == null) {
            return -1;
        }
        theUser.setSupervisionGroup(dataBuffer[16]);
        if (importName.equals(theUser.importKey) || theUser.importKey.length() == 0) {
            if (theUser.active && !theUser.found) {
                theUser.found = true;
                return theUser.id;
            }
            if (theUser.active && theUser.found) {
                return -2;
            }
            return -3;
        }
        if (!theUser.active) {
            return -3;
        }
        return -4;
    }

    private void delete(DataImportJob dataImportJob, boolean supporterLoeschen, String importName) throws SQLException {
        UserDataSet currentUser;
        UserManager userManager = UserManager.getInstance();
        for (Map.Entry<String, UserDataSet> e : this.userLogins.entrySet()) {
            currentUser = e.getValue();
            if (!currentUser.active || currentUser.found || !importName.equals(currentUser.importKey) || currentUser.supporter && !supporterLoeschen) continue;
            UserAccount userAccount = HDUsersAndGroups.getUserAccount(currentUser.id);
            if (currentUser.loginCount == 1 && this.loginNotOfThisImport(e.getKey())) {
                MutableUserData userData = new MutableUserData();
                userData.put(this.importNameField, (Object)"");
                UserManager.getInstance().updateUserData(userAccount.getID(), userData);
                continue;
            }
            for (UserGroupVOManager.SupervisorMemberShip sms : currentUser.getSupervisorMemberShips()) {
                UserGroupVOManager.getInstance().removeSupervisorMemberShip(sms.getUserID(), sms.getGroupID());
                dataImportJob.incrementDeletedSupervisorsCount();
            }
            UserManager.getInstance().setUserAccountInactive(userAccount.getID());
            dataImportJob.incrementDeletedCount();
            --this.userCount;
            currentUser.active = false;
        }
        if (dataImportJob.getEntriesDeleted() > 0) {
            logger.info((Object)("Von " + this.userCount + " Benutzern wurden " + dataImportJob.getEntriesDeleted() + " gel\u00f6scht!"));
            if (dataImportJob.getEntriesError() > 0 && this.userCount < HdLicenseObserver.getMaxUsers() && HdLicenseObserver.getMaxUsers() != -1) {
                for (Map.Entry<String, UserDataSet> e : this.userLogins.entrySet()) {
                    currentUser = e.getValue();
                    if (currentUser.bufData == null) continue;
                    if (currentUser.id == -1) {
                        this.insert(dataImportJob, importName, currentUser.bufData, 0);
                        currentUser = this.userLogins.get(e.getKey());
                    } else {
                        this.reaktivieren(dataImportJob, importName, currentUser.bufData);
                    }
                    if (currentUser.active) {
                        dataImportJob.decrementErrorsCount();
                        --this.lizenzCounter;
                    }
                    currentUser.bufData = null;
                    if (this.userCount != HdLicenseObserver.getMaxUsers()) continue;
                    break;
                }
            }
        }
    }

    private void handleSupervisedGroups(DataImportJob dataImportJob, String importName) {
        int count = 0;
        for (Map.Entry<String, UserDataSet> e : this.userLogins.entrySet()) {
            UserDataSet currentUser = e.getValue();
            ++count;
            if (!currentUser.active || !currentUser.found || !currentUser.hasSupervisorData()) continue;
            if (currentUser.getSupervisionGroup() != null && currentUser.getSupervisionGroup().length() > 0) {
                StringTokenizer tokens = new StringTokenizer(currentUser.getSupervisionGroup(), ";,");
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    int bgrID = this.benutzergruppen.get(token.trim().toLowerCase());
                    if (bgrID <= -1) continue;
                    List<UserGroupVOManager.SupervisorMemberShip> smsList = currentUser.getSupervisorMemberShips();
                    Optional<UserGroupVOManager.SupervisorMemberShip> findFirst = smsList.stream().filter(s -> s.getGroupID() == bgrID && s.getUserID() == currentUser.id).findFirst();
                    if (findFirst.isPresent()) {
                        UserGroupVOManager.SupervisorMemberShip sms = findFirst.get();
                        if (!(importName.equals(sms.getSource()) || sms.getSource() != null && sms.getSource().length() != 0)) {
                            UserGroupVOManager.getInstance().addOrUpdateSupervisorMemberShip(currentUser.id, bgrID, importName);
                        }
                        logger.debug((Object)("User " + currentUser.id + " is already supervisor from usergroup " + token));
                        smsList.remove(sms);
                        continue;
                    }
                    logger.info((Object)("Add User " + currentUser.id + " as supervisor to usergroup " + token));
                    UserGroupVOManager.getInstance().addOrUpdateSupervisorMemberShip(currentUser.id, bgrID, importName);
                    dataImportJob.incrementAddedSuperviorsCount();
                }
            }
            currentUser.setSupervisionGroup(null);
            for (UserGroupVOManager.SupervisorMemberShip sms : currentUser.getSupervisorMemberShips()) {
                if (!importName.equals(sms.getSource())) continue;
                logger.info((Object)("Remove User " + currentUser.id + " as supervisor from usergroup " + sms.getGroupID()));
                UserGroupVOManager.getInstance().removeSupervisorMemberShip(sms.getUserID(), sms.getGroupID());
                dataImportJob.incrementDeletedSupervisorsCount();
            }
            currentUser.getSupervisorMemberShips().clear();
        }
    }

    private void insert(DataImportJob dataImportJob, String importName, String[] dataBuff, int version) {
        MutableUserData userData = new MutableUserData();
        userData.put((UserField)HDFieldLocator.getUserFieldForDBKey("GebID"), (Object)this.standardGeb);
        for (int i = 0; i < DB_COLUMNS.length; ++i) {
            String str = dataBuff[i];
            if (i == 8 && str != null) {
                try {
                    UserDataConnectorImpl.checkEmailReceivers(str);
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    str = "";
                }
            }
            if (str == null || str.length() <= 0) continue;
            if (DB_COLUMN_SIZES[i] > -1 && str.length() > DB_COLUMN_SIZES[i]) {
                str = str.substring(0, DB_COLUMN_SIZES[i]);
            }
            if (i == 3) {
                userData.put((UserField)HDFieldLocator.getUserFieldForDBKey(DB_COLUMNS[i]), (Object)this.getGebID(str));
                continue;
            }
            if (i == 4) {
                userData.put((UserField)HDFieldLocator.getUserFieldForDBKey(DB_COLUMNS[i]), (Object)this.getBgrID(str));
                continue;
            }
            if (i == 0) continue;
            userData.put((UserField)HDFieldLocator.getUserFieldForDBKey(DB_COLUMNS[i]), (Object)UserImporter.testReplacement(str));
        }
        userData.put((UserField)HDFieldLocator.getUserFieldForDBKey("SprID"), (Object)this.standardSprache);
        userData.put((UserField)HDFieldLocator.getUserFieldForDBKey("ImpName"), (Object)importName);
        String userName = dataBuff[0];
        LoginSettings loginSettings = new LoginSettings("system", userName, null);
        UserAccount userAccount = UserManager.getInstance().createUserAccount(UserAccountType.Standard, userData, loginSettings);
        ++this.newUserCounter;
        ++this.userCount;
        dataImportJob.incrementAddedCount();
        String normalizedUsername = this.uppercasePlusDomain(userName);
        UserDataSet theUser = new UserDataSet(userAccount, importName, 1);
        theUser.setSupervisionGroup(dataBuff[16]);
        theUser.found = true;
        this.userLogins.put(normalizedUsername, theUser);
    }

    private int getGebID(String name) {
        if (this.locationDaten && name != null) {
            int id = this.locations.get(name.toLowerCase());
            if (id == -1) {
                try {
                    id = LocationManager.getInstance().add(new LocationVO(-1, name, null, null, null, 0, false));
                    this.locations.put(name.toLowerCase(), id);
                }
                catch (SQLException sql) {
                    logger.error((Object)sql);
                    return this.standardGeb;
                }
                ++this.locationInsertCounter;
                return id;
            }
            return id;
        }
        return this.standardGeb;
    }

    private int getBgrID(String name) {
        if (this.benutzerGruppenDaten && name != null) {
            int id = this.benutzergruppen.get(name.toLowerCase());
            if (id == -1) {
                try {
                    id = UserGroupVOManager.getInstance().add(new UserGroupVO(-1, name, 0, 0, false));
                    this.benutzergruppen.put(name.toLowerCase(), id);
                }
                catch (SQLException sql) {
                    logger.error((Object)sql);
                    return this.standardBenGr;
                }
                ++this.bgrInsertCounter;
                return id;
            }
            return id;
        }
        return this.standardBenGr;
    }

    private boolean fillDataBuffer(Attributes attrs, String[] buf, SearchResult sr) {
        Attribute attr;
        for (int i = 0; i < this.readColumns.length; ++i) {
            if (this.readColumns[i].length() <= 0) continue;
            try {
                Object str;
                if (this.needSpezialDN && "dnX".equals(this.readColumns[i])) {
                    str = this.spezialDNadd == null ? sr.getName() : sr.getName() + this.spezialDNadd;
                } else {
                    attr = attrs.get(this.readColumns[i]);
                    if (attr != null) {
                        str = attr.get().toString();
                        str = LdapFormatHandler.handleLdapFormat(this.readColumns[i], (String)str);
                    } else {
                        str = "";
                    }
                }
                buf[i] = str;
                continue;
            }
            catch (Throwable e) {
                buf[i] = null;
                logger.error((Object)e);
            }
        }
        if (this.defaultSnColumn.length() > 0 && buf[1] == null) {
            try {
                attr = attrs.get(this.defaultSnColumn);
                if (attr != null) {
                    buf[1] = attr.get().toString();
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return this.checkUser(buf);
    }

    private boolean checkUser(String[] buf) {
        return FieldImportRules.areUserNamesValid(this.readColumns, buf);
    }

    private void setImportOptions(UserImportConfigInfo userImportConfigInfo, boolean ldap) throws SQLException, IllegalStateException {
        int i;
        String supervisorColumn = userImportConfigInfo.getSupervisorColumn();
        boolean bl = this.supervisorDaten = supervisorColumn != null && supervisorColumn.length() > 0;
        if (this.supervisorDaten) {
            this.readColumns[16] = supervisorColumn;
        }
        char[] chs = userImportConfigInfo.getSelektionList().toCharArray();
        int start = 0;
        int index = 0;
        for (int i2 = 0; i2 < chs.length - 1; ++i2) {
            if (chs[i2] == '<' && chs[i2 + 1] == '>') {
                this.readColumns[index++] = new String(chs, start, i2 - start);
                start = i2 + 2;
            }
            if (index != DB_COLUMNS.length - 1) continue;
            this.readColumns[index] = new String(chs, start, chs.length - start);
            break;
        }
        Vector<String> vec = new Vector<String>();
        this.locationDaten = this.readColumns[3].length() > 0;
        this.benutzerGruppenDaten = this.readColumns[4].length() > 0;
        for (i = 0; i < this.readColumns.length; ++i) {
            if (this.readColumns[i].length() <= 0) continue;
            if (vec.indexOf(this.readColumns[i]) == -1 && !this.readColumns[i].equals("dnX")) {
                vec.addElement(this.readColumns[i]);
                continue;
            }
            if (!this.readColumns[i].equals("dnX")) continue;
            this.needSpezialDN = true;
        }
        if (ldap) {
            LdapConnectionInfo ldapConn = this.getCurrentLdapConnectionInfo();
            Vector<String> data = new Vector<String>();
            try {
                UserImporter.getLdapAttributs(data, ldapConn, "organizationalPerson", userImportConfigInfo.isUseUserSyntax(), userImportConfigInfo.getUserSyntax());
                if (data.contains("Object-Version")) {
                    this.objVersionString = "Object-Version";
                } else if (data.contains("uSNChanged")) {
                    this.objVersionString = "uSNChanged";
                }
                if (this.objVersionString != null) {
                    vec.addElement(this.objVersionString);
                }
                if (data.contains(ACCOUNT_CONTROL)) {
                    vec.addElement(ACCOUNT_CONTROL);
                    userAccountControlAvailable = true;
                }
                if (data.contains(HIDE_FROM_ADDRESSLISTS)) {
                    vec.addElement(HIDE_FROM_ADDRESSLISTS);
                    userHideFromListAvailable = true;
                }
            }
            catch (NamingException e) {
                logger.error((Object)e);
            }
        }
        this.defaultSnColumn = userImportConfigInfo.getDefaultSnColumn();
        if (this.defaultSnColumn.length() > 0 && vec.indexOf(this.defaultSnColumn) == -1) {
            vec.addElement(this.defaultSnColumn);
        }
        this.attrListe = new String[vec.size()];
        for (i = 0; i < vec.size(); ++i) {
            this.attrListe[i] = (String)vec.elementAt(i);
        }
        if (this.attrListe.length == 0) {
            throw new IllegalStateException("Keine Attribute f\u00fcr den Import ausgew\u00e4hlt!");
        }
    }

    private void fetchStartData(UserManager manager, String currentImpName) throws SQLException {
        String name;
        this.entrysPerImport = new StringIntHashMap();
        this.userLogins = new HashMap();
        this.importNameField = manager.getField("importname");
        AndSearchExpression and = new AndSearchExpression();
        and.add((SearchExpression)new SearchCondition("loginsettings", SearchCondition.SearchTermOperator.GT, (Object)""));
        List<UserIterator.AccountLogins> accountLoginsList = new UserIterator().getUserSystemLogins(manager, (List<SearchExpression>)and);
        for (UserIterator.AccountLogins accountLogins : accountLoginsList) {
            this.handleData(accountLogins);
        }
        this.standardSprache = "xx";
        this.standardGeb = (Integer)HDUsersAndGroups.FIELD_LOCATION_ID.getDefaultValue();
        if (this.locationDaten) {
            this.locations = new StringIntHashMap();
            List locationVOs = LocationManager.getInstance().getAll(false);
            for (LocationVO locationVO : locationVOs) {
                name = locationVO.getDisplayValue();
                if (name == null) continue;
                this.locations.put(name.toLowerCase(), locationVO.getId());
            }
            this.locations.put("", this.standardGeb);
        } else {
            this.locations = null;
        }
        if (this.benutzerGruppenDaten || this.supervisorDaten) {
            this.benutzergruppen = new StringIntHashMap();
            List usergroupVOs = UserGroupVOManager.getInstance().getAll(false);
            for (UserGroupVO usergroupVO : usergroupVOs) {
                name = usergroupVO.getDisplayValue();
                if (name == null) continue;
                this.benutzergruppen.put(name.toLowerCase(), usergroupVO.getId());
            }
            this.benutzergruppen.put("", 0);
        } else {
            this.benutzergruppen = null;
        }
        if (this.supervisorDaten) {
            UserGroupVOManager.getInstance().reloadFromDatabase();
            List<UserGroupVOManager.SupervisorMemberShip> memberShips = UserGroupVOManager.getInstance().getAllSupervisorMemberShips();
            block3: for (UserGroupVOManager.SupervisorMemberShip sms : memberShips) {
                UserAccount ua = HDUsersAndGroups.getUserAccount(sms.getUserID());
                for (LoginSettings login : ua.getLoginSettings()) {
                    UserDataSet uds;
                    if (!"system".equals(login.getLoginSource()) || (uds = this.getUserDataByName(login.getLoginID())) == null) continue;
                    uds.addSupervisorDataSet(sms);
                    continue block3;
                }
            }
        }
        this.standardBenGr = 0;
    }

    public void handleData(UserIterator.AccountLogins accountLogins) {
        UserAccount userAccount = accountLogins.getUserAccount();
        List<UserIterator.LoginData> systemLogins = accountLogins.getSystemLogins();
        UserDataSet currentUser = new UserDataSet(userAccount, userAccount.getValue(this.importNameField), systemLogins.size());
        if (userAccount.isActive()) {
            ++this.userCount;
            if (currentUser.importKey != null && currentUser.importKey.length() > 0) {
                int count = this.entrysPerImport.get(currentUser.importKey);
                count = count == -1 ? 1 : ++count;
                this.entrysPerImport.put(currentUser.importKey, count);
            }
        }
        if (systemLogins.size() > 0) {
            for (UserIterator.LoginData systemLogin : systemLogins) {
                this.userLogins.put(systemLogin.getNormalizedUserName(), currentUser);
            }
        } else {
            this.userLogins.put("UsrID" + currentUser.id, currentUser);
        }
    }

    private String normalizeForMap(String userName) {
        return userName.toUpperCase().replace('/', '\\');
    }

    private static void insertLDAPmainAttributes(StringIntHashMap mainAttributes) {
        mainAttributes.put("uid", 0);
        mainAttributes.put("sAMAccountName", 0);
        mainAttributes.put("cn", 0);
        mainAttributes.put("sn", 0);
        mainAttributes.put("givenName", 0);
        mainAttributes.put("l", 0);
        mainAttributes.put("dn", 0);
        mainAttributes.put("distinguishedName", 0);
        mainAttributes.put("ou", 0);
        mainAttributes.put("personalTitle", 0);
        mainAttributes.put("manager", 0);
        mainAttributes.put("telephoneNumber", 0);
        mainAttributes.put("office", 0);
        mainAttributes.put("physicalDeliveryOfficeName", 0);
        mainAttributes.put("department", 0);
        mainAttributes.put("mail", 0);
        mainAttributes.put(ACCOUNT_CONTROL, 0);
        mainAttributes.put(HIDE_FROM_ADDRESSLISTS, 0);
    }

    private static boolean testStringChars(String data) {
        for (int i = 0; i < data.length(); ++i) {
            if (data.charAt(i) >= ' ' || data.charAt(i) == '\n' || data.charAt(i) == '\r') continue;
            return false;
        }
        return true;
    }

    @SuppressFBWarnings(value={"LDAP_INJECTION"}, justification="The LDAP statement is created internally")
    public static void getLdapAttributs(Vector<String> attibutesBuffer, LdapConnectionInfo ldapConnectionInfo, String objectClass, boolean useUserSyntax, String userSyntax) throws NamingException {
        ArrayList<Object> attributes;
        block47: {
            int[] statistics;
            String[] previewVals;
            String[] searchContextValues;
            String[] stringArray;
            String dataBufferKey;
            block46: {
                dataBufferKey = ldapConnectionInfo.getHost() + ldapConnectionInfo.getSearchContext() + objectClass + (useUserSyntax ? userSyntax : "");
                if (bufferdAttributes == null || !dataBufferKey.equals(bufferKey) || lastRequested <= System.currentTimeMillis() - ATTRIBUTE_BUFFER_TIME) break block46;
                attributes = bufferdAttributes;
                break block47;
            }
            attributes = new ArrayList();
            boolean foundDN = false;
            if (useUserSyntax && userSyntax != null && !userSyntax.isEmpty()) {
                stringArray = UserImporter.getUserDefinedSyntax(userSyntax);
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "objectClass=" + (objectClass != null && !objectClass.isEmpty() ? objectClass : "organizationalPerson");
            }
            String[] searchItems = stringArray;
            StringIntHashMap mainAttributes = new StringIntHashMap();
            UserImporter.insertLDAPmainAttributes(mainAttributes);
            int count = 0;
            String attrValue = null;
            String additional = null;
            CIHashMap columnStatistik = new CIHashMap();
            Hashtable<String, String[]> columnPreview = new Hashtable<String, String[]>();
            NamingEnumeration<SearchResult> enumeration = null;
            InitialLdapContext ctx = LdapUtilities.getDirContext(ldapConnectionInfo);
            for (String searchContext : searchContextValues = LdapUtilities.getSearchContext(ctx, ldapConnectionInfo.getSearchContext())) {
                additional = searchContext.length() > 0 ? "," + searchContext : null;
                for (String searchItem : searchItems) {
                    logger.debug((Object)("Suche: " + searchItem));
                    try {
                        boolean searchSuccess = true;
                        try {
                            enumeration = ctx.search(searchContext, searchItem, LdapUtilities.getSearchControls(null));
                            searchSuccess = enumeration.hasMore();
                        }
                        catch (NamingException ex) {
                            searchSuccess = false;
                        }
                        while (searchSuccess) {
                            ++count;
                            Attributes attrs = null;
                            SearchResult si = (SearchResult)enumeration.nextElement();
                            attrs = si.getAttributes();
                            NamingEnumeration<String> enum2 = attrs.getIDs();
                            boolean doAgain = enum2.hasMore();
                            while (doAgain) {
                                block49: {
                                    int n;
                                    block48: {
                                        int xy;
                                        String attrName = enum2.next();
                                        if (attrName.equalsIgnoreCase("distinguishedName") || attrName.equalsIgnoreCase("dn")) {
                                            logger.debug((Object)attrs.get(attrName).get().toString());
                                            foundDN = true;
                                        }
                                        if ((previewVals = (String[])columnPreview.get(attrName)) == null) {
                                            previewVals = new String[10];
                                            statistics = new int[6];
                                            for (n = 0; n < 10; ++n) {
                                                previewVals[n] = null;
                                                if (n >= 6) continue;
                                                statistics[n] = 0;
                                            }
                                            columnPreview.put(attrName, previewVals);
                                            columnStatistik.put(attrName, statistics);
                                        } else {
                                            statistics = columnStatistik.get(attrName);
                                        }
                                        if (statistics[4] != 0 && mainAttributes.get(attrName) == -1) break block48;
                                        int attributeCount = attrs.get(attrName).size();
                                        statistics[0] = statistics[0] + 1;
                                        statistics[1] = statistics[1] + attributeCount;
                                        if (attributeCount > 1) {
                                            if (mainAttributes.get(attrName) > -1) {
                                                Attribute attrCN = attrs.get("cn");
                                                logger.debug((Object)("cn: " + (attrCN != null ? attrCN.get().toString() : "null")));
                                                logger.debug((Object)(" Nicht Eindeutiges Attribut " + attrName + ":"));
                                                for (int x = 0; x < attributeCount; ++x) {
                                                    attrValue = attrs.get(attrName).get(x).toString();
                                                    logger.debug((Object)("-" + attrValue));
                                                }
                                            } else {
                                                attrValue = attrs.get(attrName).get().toString();
                                            }
                                            statistics[2] = statistics[2] + 1;
                                        } else {
                                            attrValue = attributeCount == 1 ? attrs.get(attrName).get().toString() : "";
                                        }
                                        statistics[3] = statistics[3] + attrValue.length();
                                        if (attrValue.length() > 50) {
                                            attrValue = attrValue.substring(0, 50);
                                        }
                                        if (!UserImporter.testStringChars(attrValue)) {
                                            if (mainAttributes.get(attrName) > -1) {
                                                logger.debug((Object)(attrName + " enth\u00e4lt nicht darstellbare Zeichen!"));
                                            }
                                            statistics[4] = statistics[4] + 1;
                                        }
                                        if (statistics[5] >= 10) break block49;
                                        for (xy = 0; xy < statistics[5] && !attrValue.equals(previewVals[xy]); ++xy) {
                                        }
                                        if (xy != statistics[5]) break block49;
                                        int n2 = statistics[5];
                                        statistics[5] = n2 + 1;
                                        previewVals[n2] = attrValue;
                                        break block49;
                                    }
                                    if (previewVals[0] != null) {
                                        for (n = 0; n < 10; ++n) {
                                            previewVals[n] = null;
                                        }
                                    }
                                }
                                try {
                                    doAgain = enum2.hasMore();
                                }
                                catch (NamingException ex) {
                                    doAgain = false;
                                }
                            }
                            enum2.close();
                            if (!foundDN) {
                                Object dn = additional == null ? si.getName() : si.getName() + additional;
                                previewVals = (String[])columnPreview.get("dnX");
                                if (previewVals == null) {
                                    previewVals = new String[10];
                                    statistics = new int[6];
                                    for (int n = 0; n < 10; ++n) {
                                        previewVals[n] = null;
                                        if (n >= 6) continue;
                                        statistics[n] = 0;
                                    }
                                    columnPreview.put("dnX", previewVals);
                                    columnStatistik.put("dnX", statistics);
                                } else {
                                    statistics = columnStatistik.get("dnX");
                                }
                                statistics[0] = statistics[0] + 1;
                                statistics[1] = statistics[1] + 1;
                                statistics[3] = statistics[3] + ((String)dn).length();
                                if (statistics[5] < 10) {
                                    if (((String)dn).length() > 50) {
                                        dn = ((String)dn).substring(0, 50);
                                    }
                                    int n = statistics[5];
                                    statistics[5] = n + 1;
                                    previewVals[n] = dn;
                                }
                            }
                            try {
                                searchSuccess = enumeration.hasMore();
                            }
                            catch (NamingException ex) {
                                searchSuccess = false;
                            }
                        }
                        if (!searchSuccess) continue;
                        enumeration.close();
                    }
                    catch (NamingException e) {
                        logger.error((Object)e);
                    }
                }
            }
            try {
                ctx.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            logger.debug((Object)("Untersuchte Objekte: " + count));
            Enumeration enumCols = columnPreview.keys();
            while (enumCols.hasMoreElements()) {
                boolean isMainAttr;
                String key = (String)enumCols.nextElement();
                previewVals = (String[])columnPreview.get(key);
                statistics = columnStatistik.get(key);
                int relativeHaeufigkeit = statistics[0] * 100 / count;
                boolean bl = isMainAttr = mainAttributes.get(key) != -1;
                if (statistics[4] == 0 || isMainAttr) {
                    if (statistics[2] == 0 || isMainAttr) {
                        int differntValueCount = 0;
                        int geschweiftKlammer = 0;
                        int eckKlammer = 0;
                        for (int i = 0; i < 10 && previewVals[i] != null; ++i) {
                            if (previewVals[i].length() > 0) {
                                if (previewVals[i].charAt(0) == '{') {
                                    ++geschweiftKlammer;
                                }
                                if (previewVals[i].charAt(0) == '[') {
                                    ++eckKlammer;
                                }
                            }
                            ++differntValueCount;
                        }
                        if (!(isMainAttr || geschweiftKlammer != differntValueCount && eckKlammer != differntValueCount)) {
                            logger.debug((Object)("Attribut: " + key + " scheint nicht f\u00fcr Import geeignet!"));
                            continue;
                        }
                        logger.debug((Object)(key + " ist OK Haeufikeit: " + relativeHaeufigkeit + "% mehrfach: " + statistics[2] + " Durchschnitt-Laenge: " + statistics[3] / statistics[0] + " Zeichenfehler: " + statistics[4]));
                        attributes.add(key);
                        Vector<String> pevVals = new Vector<String>();
                        for (int i = 0; i < 10 && previewVals[i] != null; ++i) {
                            pevVals.addElement(previewVals[i]);
                        }
                        continue;
                    }
                    logger.debug((Object)("Attribut: " + key + " ist nicht eindeutig!"));
                    continue;
                }
                logger.debug((Object)("Attribut: " + key + " enth\u00e4lt nicht darstellbare Sonderzeichen!"));
            }
            bufferKey = dataBufferKey;
            bufferdAttributes = attributes;
            lastRequested = System.currentTimeMillis();
        }
        attibutesBuffer.addAll(attributes);
    }

    private String[] getSearchQuery() {
        Object additionalSyntax = this.importConfigInfo.getLdapAndSyntax();
        if (((String)additionalSyntax).length() > 0 && ((String)additionalSyntax).charAt(0) != '(') {
            additionalSyntax = "(" + (String)additionalSyntax + ")";
        }
        logger.debug((Object)("ldapAndSyntax: " + (String)additionalSyntax));
        String[] result = new String[]{((String)additionalSyntax).length() > 0 ? "(&(objectClass=organizationalPerson)" + (String)additionalSyntax + ")" : "(objectClass=organizationalPerson)"};
        return result;
    }

    private static String[] getUserDefinedSyntax(String input) {
        if (input == null) {
            input = "";
        }
        StringTokenizer stok = new StringTokenizer(input, "\n");
        ArrayList<String> ausdruecke = new ArrayList<String>();
        while (stok.hasMoreElements()) {
            String line = stok.nextToken().trim();
            if (line.startsWith("//")) continue;
            ausdruecke.add(line);
        }
        String[] output = new String[ausdruecke.size()];
        for (int i = 0; i < ausdruecke.size(); ++i) {
            output[i] = (String)ausdruecke.get(i);
        }
        return output;
    }

    private static String[] getNonPagedSearchArray(String[] baseSearchQueries) {
        String[] result = new String[51 * baseSearchQueries.length];
        for (int n = 0; n < baseSearchQueries.length; ++n) {
            int i;
            Object additionalSyntax = baseSearchQueries[n];
            if (((String)additionalSyntax).startsWith("(&")) {
                additionalSyntax = ((String)additionalSyntax).substring(2, ((String)additionalSyntax).length() - 1);
            }
            int offset = n * 51;
            if (((String)additionalSyntax).length() > 0 && ((String)additionalSyntax).charAt(0) != '(') {
                additionalSyntax = "(" + (String)additionalSyntax + ")";
            }
            result[offset] = "(&(|(sn=a*)(sn=A*)(sn=\u00c4*)(sn=\u00e4*))" + (String)additionalSyntax + ")";
            result[offset + 1] = "(&(|(sn=o*)(sn=O*)(sn=\u00d6*)(sn=\u00f6*))" + (String)additionalSyntax + ")";
            result[offset + 2] = "(&(|(sn=u*)(sn=U*)(sn=\u00dc*)(sn=\u00fc*))" + (String)additionalSyntax + ")";
            for (i = 0; i < BUCHSTABEN.length; ++i) {
                result[offset + i + 3] = "(&(|(sn=" + BUCHSTABEN[i] + "*)(sn=" + Character.toUpperCase(BUCHSTABEN[i]) + "*))" + (String)additionalSyntax + ")";
            }
            for (i = 0; i < BUCHSTABEN.length; ++i) {
                result[offset + i + 3 + UserImporter.BUCHSTABEN.length] = "(&(|(sn=s" + BUCHSTABEN[i] + "*)(sn=S" + BUCHSTABEN[i] + "*))" + (String)additionalSyntax + ")";
            }
            result[offset + 47] = "(&(|(sn=Sa*)(sn=S\u00e4*))" + (String)additionalSyntax + ")";
            result[offset + 48] = "(&(|(sn=So*)(sn=S\u00f6*))" + (String)additionalSyntax + ")";
            result[offset + 49] = "(&(|(sn=Su*)(sn=S\u00fc*))" + (String)additionalSyntax + ")";
            result[offset + 50] = "(&(|(sn=0*)(sn=1*)(sn=2*)(sn=3*)(sn=4*)(sn=6*)(sn=7*)(sn=8*)(sn=9*))" + (String)additionalSyntax + ")";
        }
        return result;
    }

    public static Connection getConnection(DatabaseConfigInfo dbConn) throws SQLException {
        DriverManager.setLoginTimeout(10);
        logger.debug((Object)("DriverManager url: " + dbConn.getUrl() + " user " + dbConn.getUser()));
        return DriverManager.getConnection(dbConn.getUrl(), dbConn.getUser(), dbConn.getDecodedPassword());
    }

    static {
        USER_IMPORT_CONFIGS = new ConfigValue(HDConfigKeys.USER_IMPORT_CONFIGS);
        LDAP_CONNECTION_INFOS = new ConfigValue(HDConfigKeys.LDAP_CONNECTION_INFOS);
        DB_INFOS = new ConfigValue(HDConfigKeys.DB_CONFIGS);
        logger = LogManager.getLogger((String)"Data Import");
        MONITOR_OBJECT = new Object();
        MSG = new I18nMessages("com.inet.helpdesk.data.i18n.LanguageResources", UserImporter.class);
    }

    private class UserDataSet {
        private int id;
        private boolean active;
        private boolean supporter;
        private boolean found;
        private String importKey;
        private int loginCount;
        private String[] bufData = null;
        private ArrayList<UserGroupVOManager.SupervisorMemberShip> supervisedGroups = new ArrayList();
        private String supervisorSettings;

        private UserDataSet(UserAccount userAccount, Object importKey, int loginCount) {
            this.id = HDUsersAndGroups.getUserID(userAccount);
            this.active = userAccount.isActive();
            this.supporter = HDUsersAndGroups.isDispatcher(userAccount) || HDUsersAndGroups.isResourceMember(userAccount);
            this.found = false;
            this.importKey = importKey != null ? importKey.toString() : "";
            this.loginCount = loginCount;
        }

        private UserDataSet(Object importKey) {
            this.id = -1;
            this.loginCount = 0;
            this.found = true;
            this.active = false;
            this.supporter = false;
            this.importKey = importKey.toString();
        }

        private void addSupervisorDataSet(UserGroupVOManager.SupervisorMemberShip sds) {
            this.supervisedGroups.add(sds);
        }

        private List<UserGroupVOManager.SupervisorMemberShip> getSupervisorMemberShips() {
            return this.supervisedGroups;
        }

        private boolean hasSupervisorData() {
            return this.supervisorSettings != null && this.supervisorSettings.length() > 0 || this.supervisedGroups.size() > 0;
        }

        private void setSupervisionGroup(String supervisorSettings) {
            this.supervisorSettings = supervisorSettings;
        }

        private String getSupervisionGroup() {
            return this.supervisorSettings;
        }
    }

    private class ReadLdapRecordStateImpl
    implements ReadRecordState {
        private final String importName;
        private boolean startOption;
        private boolean inserten;
        private boolean reaktivieren;
        private Logger logger;
        private String[] dataBuffer;
        private Attributes attrs;
        private DataImportJob dataImportJob;

        public ReadLdapRecordStateImpl(DataImportJob dataImportJob, String importName, boolean startOption, boolean inserten, boolean reaktivieren, Logger logger, String[] dataBuffer, Attributes attrs) {
            this.dataImportJob = dataImportJob;
            this.importName = importName;
            this.startOption = startOption;
            this.inserten = inserten;
            this.reaktivieren = reaktivieren;
            this.logger = logger;
            this.dataBuffer = dataBuffer;
            this.attrs = attrs;
        }

        @Override
        public ReadLdapRecordStateImpl invoke() {
            this.dataImportJob.incrementDataCount();
            int userID = UserImporter.this.getUserID(this.dataBuffer, this.importName);
            int version = UserImporter.this.globaleVersion;
            if (this.startOption && UserImporter.this.objVersionString != null) {
                try {
                    version = Integer.parseInt(this.attrs.get(UserImporter.this.objVersionString).get().toString());
                }
                catch (Throwable pex) {
                    version = UserImporter.this.globaleVersion;
                }
            }
            this.logger.debug((Object)("User: " + this.dataBuffer[0] + " ID: " + UserImporter.this.getDisplayableMessage(userID) + " Version: " + version));
            if (userID > -1) {
                UserImporter.this.update(this.dataImportJob, this.importName, this.dataBuffer, userID, false);
            } else if (userID == -1) {
                if (this.inserten && (UserImporter.this.userCount < HdLicenseObserver.getMaxUsers() || HdLicenseObserver.getMaxUsers() == -1)) {
                    UserImporter.this.insert(this.dataImportJob, this.importName, this.dataBuffer, version);
                } else if (this.inserten) {
                    UserImporter.this.bufferImportableData(this.importName, this.dataBuffer, this.dataImportJob);
                }
            } else if (userID == -2) {
                this.dataImportJob.incrementDuplicatesCount();
                this.logger.warn((Object)("LDAP ERROR: " + this.dataBuffer[0] + " not unique!"));
            } else if (userID == -3) {
                if (this.reaktivieren && (UserImporter.this.userCount < HdLicenseObserver.getMaxUsers() || HdLicenseObserver.getMaxUsers() == -1)) {
                    UserImporter.this.reaktivieren(this.dataImportJob, this.importName, this.dataBuffer);
                } else if (this.reaktivieren) {
                    UserDataSet reactivateableUser = UserImporter.this.getUserDataByName(this.dataBuffer[0]);
                    UserImporter.this.handleNonImportableUser(reactivateableUser, this.dataBuffer, this.dataImportJob);
                }
            }
            return this;
        }
    }

    private class ReadRecordStateImpl
    implements ReadRecordState {
        private final String importName;
        private boolean inserten;
        private boolean reaktivieren;
        private String[] dataBuffer;
        private DataImportJob dataImportJob;

        private ReadRecordStateImpl(DataImportJob dataImportJob, String importName, boolean inserten, boolean reaktivieren, String[] dataBuffer) {
            this.dataImportJob = dataImportJob;
            this.importName = importName;
            this.inserten = inserten;
            this.reaktivieren = reaktivieren;
            this.dataBuffer = dataBuffer;
        }

        @Override
        public ReadRecordState invoke() {
            this.dataImportJob.incrementDataCount();
            int userID = UserImporter.this.getUserID(this.dataBuffer, this.importName);
            logger.debug((Object)("User: " + this.dataBuffer[0] + " ID: " + UserImporter.this.getDisplayableMessage(userID)));
            if (userID > -1) {
                UserImporter.this.update(this.dataImportJob, this.importName, this.dataBuffer, userID, false);
            } else if (userID == -1) {
                if (this.inserten && (UserImporter.this.userCount - this.dataImportJob.getEntriesDeleted() < HdLicenseObserver.getMaxUsers() || HdLicenseObserver.getMaxUsers() == -1)) {
                    UserImporter.this.insert(this.dataImportJob, this.importName, this.dataBuffer, 0);
                } else if (this.inserten) {
                    UserImporter.this.bufferImportableData(this.importName, this.dataBuffer, this.dataImportJob);
                }
            } else if (userID == -2) {
                this.dataImportJob.incrementDuplicatesCount();
                logger.warn((Object)("SYNCHRONISATION ERROR: " + this.dataBuffer[0] + " not unique!"));
            } else if (userID == -3) {
                if (this.reaktivieren && (UserImporter.this.userCount - this.dataImportJob.getEntriesDeleted() < HdLicenseObserver.getMaxUsers() || HdLicenseObserver.getMaxUsers() == -1)) {
                    UserImporter.this.reaktivieren(this.dataImportJob, this.importName, this.dataBuffer);
                } else if (this.reaktivieren) {
                    UserDataSet reactivateableUser = UserImporter.this.getUserDataByName(this.dataBuffer[0]);
                    UserImporter.this.handleNonImportableUser(reactivateableUser, this.dataBuffer, this.dataImportJob);
                }
            }
            return this;
        }
    }

    public static class ReadSampleRecordStateImpl
    implements ReadRecordStateWithSamples {
        private final String[] columnNames;
        private String[] latestDataBuffer;
        private ArrayList<Map<String, String>> samples = new ArrayList();

        public ReadSampleRecordStateImpl() {
            this.columnNames = DB_COLUMNS_DISPLAY;
            this.samples = new ArrayList();
        }

        @Override
        public ReadRecordState invoke() {
            HashMap<String, String> values = new HashMap<String, String>();
            for (int index = 0; index < this.columnNames.length; ++index) {
                String value = this.latestDataBuffer[index];
                if (value == null || value.length() <= 0) continue;
                values.put(this.columnNames[index], value);
            }
            this.samples.add(values);
            return this;
        }

        public boolean isFinished() {
            return this.samples.size() == 20;
        }

        public void receivedNewRow(String[] dataBuffer) {
            this.latestDataBuffer = dataBuffer;
        }

        @Override
        public ArrayList<Map<String, String>> getSamples() {
            return this.samples;
        }
    }

    public static interface ReadRecordStateWithSamples
    extends ReadRecordState {
        public ArrayList<Map<String, String>> getSamples();
    }

    private static interface ReadRecordState {
        public ReadRecordState invoke();
    }

    public static class ReadSampleRecordStateFactory
    implements ReadRecordStateFactory {
        private ReadSampleRecordStateImpl sampleCollectorState = new ReadSampleRecordStateImpl();

        @Override
        public ReadRecordState createLdapReadRecordState(DataImportJob dataImportJob, String importName, boolean startOption, boolean inserten, boolean reaktivieren, Logger logger, String[] dataBuffer, Attributes attrs) {
            this.sampleCollectorState.receivedNewRow(dataBuffer);
            return this.sampleCollectorState;
        }

        @Override
        public ReadRecordStateWithSamples createReadRecordState(DataImportJob dataImportJob, String importName, boolean inserten, boolean reaktivieren, String[] dataBuffer) {
            this.sampleCollectorState.receivedNewRow(dataBuffer);
            return this.sampleCollectorState;
        }

        @Override
        public boolean isFinished(boolean inProgress) {
            return !inProgress || this.sampleCollectorState.isFinished();
        }

        @Override
        public ReadRecordStateWithSamples getLastState() {
            return this.sampleCollectorState;
        }
    }

    private class ReadAndImportRecordStateFactory
    implements ReadRecordStateFactory {
        private ReadRecordStateImpl lastState;

        private ReadAndImportRecordStateFactory() {
        }

        @Override
        public ReadRecordState createLdapReadRecordState(DataImportJob dataImportJob, String importName, boolean startOption, boolean inserten, boolean reaktivieren, Logger logger, String[] dataBuffer, Attributes attrs) {
            return new ReadLdapRecordStateImpl(dataImportJob, importName, startOption, inserten, reaktivieren, logger, dataBuffer, attrs);
        }

        @Override
        public ReadRecordState createReadRecordState(DataImportJob dataImportJob, String importName, boolean inserten, boolean reaktivieren, String[] dataBuffer) {
            this.lastState = new ReadRecordStateImpl(dataImportJob, importName, inserten, reaktivieren, dataBuffer);
            return this.lastState;
        }

        @Override
        public boolean isFinished(boolean inProgress) {
            return false;
        }

        @Override
        public ReadRecordState getLastState() {
            return this.lastState;
        }
    }

    private static interface ReadRecordStateFactory {
        public ReadRecordState createLdapReadRecordState(DataImportJob var1, String var2, boolean var3, boolean var4, boolean var5, Logger var6, String[] var7, Attributes var8);

        public ReadRecordState createReadRecordState(DataImportJob var1, String var2, boolean var3, boolean var4, String[] var5);

        public boolean isFinished(boolean var1);

        public ReadRecordState getLastState();
    }

    private class LdapSearchOptions {
        private int searchExecutions = 0;
        private boolean inserten;
        private boolean reaktivieren;
        private boolean pagedSearch = true;
        private boolean startOption;
        private String importName;
        private String[] searchContextValues;

        private LdapSearchOptions() {
        }
    }
}

