/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.authentication.base.LoginManager;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.swing.AbstractResultSet;
import com.inet.helpdesk.core.swing.MyResultSetMetaData;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Base64;

public class MultiResultSet
extends AbstractResultSet {
    private String[] columnNames;
    private int[] columnDataTypes;
    private String param1;
    private String param2;
    private String answerOne = "access";
    private String answerTwo = "";
    static final String[] NAMES = new String[]{"pwd", "Username", "Nachname", "Vorname", "Email", "Telefon", "Frei1", "Frei2", "Frei3", "Frei4", "Frei6"};
    private String[] values;
    private Connection con;

    public MultiResultSet(Connection con) {
        this.con = con;
        this.values = new String[NAMES.length];
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            return this.answerOne;
        }
        if (columnIndex == 2) {
            return this.answerTwo;
        }
        return null;
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        if (columnIndex == 1) {
            this.param1 = x;
        } else if (columnIndex == 2) {
            this.param2 = x;
        }
    }

    @Override
    public void updateRow() throws SQLException {
        if ("cmd".equals(this.param1)) {
            this.executeCommand(this.param2);
        } else {
            for (int i = 0; i < NAMES.length; ++i) {
                if (!NAMES[i].equals(this.param1)) continue;
                this.values[i] = this.param2;
                break;
            }
        }
    }

    private void executeCommand(String cmd) throws SQLException {
        if ("regnew".equals(cmd)) {
            if (!LoginManager.isUserCanRegister()) {
                throw new SQLException("New Users are not allowed!");
            }
            Base64.Decoder decoder = Base64.getDecoder();
            String loginID = new String(decoder.decode(this.values[1]), StandardCharsets.UTF_8);
            UserManager userManager = UserManager.getInstance();
            UserAccount account = userManager.findActiveUserAccount("product", loginID);
            if (account != null) {
                this.answerTwo = "EXISTING";
                HDLogger.debug("Unsuccessful register for username: " + loginID);
            } else {
                String hashToken = this.values[0];
                LoginSettings loginSettings = new LoginSettings("product", loginID, hashToken);
                try {
                    account = userManager.createUserAccount(UserAccountType.Standard, new MutableUserData(), loginSettings);
                    this.answerTwo = "YES";
                }
                catch (IllegalArgumentException ex) {
                    throw new SQLException(ex);
                }
            }
        }
    }

    @Override
    public boolean next() throws SQLException {
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        return true;
    }

    @Override
    public void close() throws SQLException {
        this.columnDataTypes = null;
        this.values = null;
        this.columnNames = null;
    }

    public void setColumns(String[] columns) {
        this.columnNames = columns;
    }

    public void setColumnTypes(int[] columnDataTypes) {
        this.columnDataTypes = columnDataTypes;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new MyResultSetMetaData(this.columnDataTypes, this.columnNames);
    }
}

