/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigKeyParser;
import com.inet.config.ConfigValue;
import com.inet.config.LicenseInfo;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.shared.LicenceInfo;
import com.inet.notification.NotificationGenerator;
import com.inet.notification.NotificationManager;
import com.inet.search.SearchResult;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import srv.HdLicenseErrorNotificationGenerator;

public class HdLicenseObserver {
    private static final long MILLIS_PER_DAY = 86400000L;
    private static int maxUsers;
    private static int namedUsers;
    private long nextLicenseCheck = 0L;
    private int namedUsersCount = -1;
    private int previous_namedUsersCount = -1;
    private int licenseDataVersion = 0;
    private String licensee = "";
    private String licenseDataVersionString = "0";
    private static ConfigValue<String> LICENSE_KEY;
    private static HdLicenseObserver instance;
    private static boolean recalculationRequested;
    private static int resetCount;
    private static final HdLicenseErrorNotificationGenerator licenseErrorNotificationGenerator;
    private static volatile long lastRecalculationRequested;
    private Thread lazyCalculationThread = null;

    protected HdLicenseObserver() {
    }

    private static synchronized HdLicenseObserver getInstance() {
        if (instance == null) {
            instance = new HdLicenseObserver();
        }
        return instance;
    }

    private void initLicenseKey() {
        LICENSE_KEY = new ConfigValue<String>(ConfigKey.LICENSEKEY){

            protected void setValue(@Nonnull String strValue) throws IllegalArgumentException {
                super.setValue(strValue);
                HdLicenseObserver.this.checkLicenseAndResetIfNeeded(strValue);
            }
        };
    }

    private void checkLicenseAndResetIfNeeded(String strValue) {
        List licenses = new ConfigKeyParser().validate(strValue);
        for (LicenseInfo info : licenses) {
            if (!info.isValid()) continue;
            this.licensee = info.getLicensee();
            String str = (String)info.getAttributes().get("usercount");
            if (str != null) {
                maxUsers = Integer.parseInt(str);
                namedUsers = 0;
            } else {
                str = (String)info.getAttributes().get("namedusers");
                if (str != null) {
                    maxUsers = -1;
                    namedUsers = Integer.parseInt(str);
                } else {
                    this.nextLicenseCheck = System.currentTimeMillis() + 86400000L;
                    maxUsers = -1;
                    namedUsers = -1;
                }
            }
            ++this.licenseDataVersion;
            this.licenseDataVersionString = String.valueOf(this.licenseDataVersion);
            HdLicenseObserver.resetLicenseCount();
            return;
        }
        ++this.licenseDataVersion;
        this.licenseDataVersionString = String.valueOf(this.licenseDataVersion);
        this.licensee = "";
        maxUsers = 0;
        namedUsers = 0;
        HdLicenseObserver.resetLicenseCount();
    }

    private boolean needsLicenseCheck() {
        return this.nextLicenseCheck != 0L && this.nextLicenseCheck < System.currentTimeMillis();
    }

    public static int getNamedUserLicenseCount() {
        return HdLicenseObserver.getInstance().getNamedUserLicenseCountInternal();
    }

    private int getNamedUserLicenseCountInternal() {
        if (LICENSE_KEY == null) {
            this.initLicenseKey();
        } else if (this.needsLicenseCheck()) {
            this.checkLicenseAndResetIfNeeded((String)LICENSE_KEY.get());
        }
        return namedUsers;
    }

    public static int getMaxUsers() {
        return HdLicenseObserver.getInstance().getMaxUsersInternal();
    }

    private int getMaxUsersInternal() {
        if (LICENSE_KEY == null) {
            this.initLicenseKey();
        } else if (this.needsLicenseCheck()) {
            this.checkLicenseAndResetIfNeeded((String)LICENSE_KEY.get());
        }
        return maxUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetLicenseCount() {
        ++resetCount;
        recalculationRequested = true;
        HdLicenseObserver hdLicenseObserver = HdLicenseObserver.getInstance();
        synchronized (hdLicenseObserver) {
            lastRecalculationRequested = System.currentTimeMillis();
            if (HdLicenseObserver.getInstance().lazyCalculationThread == null) {
                HdLicenseObserver.getInstance().lazyCalculationThread = new Thread(() -> {
                    HdLicenseObserver hdLicenseObserver = HdLicenseObserver.getInstance();
                    synchronized (hdLicenseObserver) {
                        while (recalculationRequested) {
                            try {
                                HdLicenseObserver.getInstance().wait(500L);
                            }
                            catch (InterruptedException e) {
                                HDLogger.error(e);
                            }
                            if (System.currentTimeMillis() - lastRecalculationRequested <= 5000L || !recalculationRequested) continue;
                            if (namedUsers > 0) {
                                HdLicenseObserver.getInstance().registerLicenseErrorNotificationIfNeeded(HdLicenseObserver.getCountOfNamedUsers(), HdLicenseObserver.getNamedUserLicenseCount());
                            } else {
                                HdLicenseObserver.getInstance().registerLicenseErrorNotificationIfNeeded(HdLicenseObserver.getCurrentActiveUserCount(), HdLicenseObserver.getMaxUsers());
                            }
                            recalculationRequested = false;
                            lastRecalculationRequested = 0L;
                            break;
                        }
                        HdLicenseObserver.getInstance().lazyCalculationThread = null;
                    }
                }, "lazy license recalculation thread");
                HdLicenseObserver.getInstance().lazyCalculationThread.start();
            }
        }
    }

    private synchronized void resetLicenseCountInternal() {
        recalculationRequested = false;
        if (this.namedUsersCount > -1) {
            this.previous_namedUsersCount = this.namedUsersCount;
        }
        this.namedUsersCount = -1;
        ++this.licenseDataVersion;
        this.licenseDataVersionString = String.valueOf(this.licenseDataVersion);
        HDLogger.debug("Count of resets " + resetCount);
    }

    public static int getCurrentActiveUserCount() {
        int delta = UserManager.getInstance().getUserAccount(UserManager.MASTER_ACCOUNT_ID) != null ? -1 : 0;
        int result = UserManager.getInstance().getActiveIndexCount() + delta;
        if (namedUsers <= 0) {
            HdLicenseObserver.getInstance().registerLicenseErrorNotificationIfNeeded(result, HdLicenseObserver.getMaxUsers());
        }
        return result;
    }

    public static int getCountOfNamedUsers() {
        return HdLicenseObserver.getInstance().calculateNamedUsers();
    }

    private synchronized int calculateNamedUsers() {
        if (recalculationRequested) {
            this.resetLicenseCountInternal();
        }
        if (this.namedUsersCount >= 0) {
            return this.namedUsersCount;
        }
        long calculationStart = System.currentTimeMillis();
        IndexSearchEngine searchEngine = UserManager.getInstance().getSearchEngine();
        TextSearchCommandBuilder builder = new TextSearchCommandBuilder(searchEngine, "supporter:named");
        SearchResult result = searchEngine.search(builder.build());
        this.namedUsersCount = result.getEntries().size();
        if (UserManager.getInstance().getUserAccount(UserManager.MASTER_ACCOUNT_ID) != null) {
            --this.namedUsersCount;
        }
        HDLogger.debug("Calculation of named users in " + (System.currentTimeMillis() - calculationStart) + "ms");
        if (HdLicenseObserver.getNamedUserLicenseCount() > 0) {
            this.registerLicenseErrorNotificationIfNeeded(this.namedUsersCount, HdLicenseObserver.getNamedUserLicenseCount());
        }
        return this.namedUsersCount;
    }

    private void registerLicenseErrorNotificationIfNeeded(int userCount, int maxCount) {
        if (userCount > maxCount && maxCount >= 0) {
            NotificationManager.getInstance().registerGenerator((NotificationGenerator)licenseErrorNotificationGenerator);
        } else {
            NotificationManager.getInstance().unregisterGenerator(HdLicenseErrorNotificationGenerator.LICENSE_ERROR_NOTIFICATION_ID);
        }
    }

    private String getLicenseDataVersion() {
        return this.licenseDataVersionString;
    }

    public static void addLicenseData(Properties props, String version) {
        if (recalculationRequested) {
            HdLicenseObserver.getInstance().resetLicenseCountInternal();
        }
        String versionString = HdLicenseObserver.getInstance().getLicenseDataVersion();
        if (version == null || !versionString.equals(version)) {
            LicenceInfo licInf = LicenceInfo.getInstance();
            if (!versionString.equals(licInf.getVersion())) {
                Properties newProps = HdLicenseObserver.generateLicenseProperties();
                newProps.setProperty("licencedata", versionString);
                licInf.updateLicenceInformations(newProps);
            }
            licInf.setLicenceInformations(props);
        }
    }

    private static Properties generateLicenseProperties() {
        Properties newProps = new Properties();
        newProps.setProperty("MaxUsers", String.valueOf(HdLicenseObserver.getMaxUsers()));
        newProps.setProperty("CountOfUsers", String.valueOf(HdLicenseObserver.getCurrentActiveUserCount()));
        newProps.setProperty("NamedUsersLicence", String.valueOf(HdLicenseObserver.getNamedUserLicenseCount()));
        newProps.setProperty("NamedUsersCount", String.valueOf(HdLicenseObserver.getNamedUserLicenseCount() > 0 ? HdLicenseObserver.getCountOfNamedUsers() : 0));
        return newProps;
    }

    public static String getLicensee() {
        return HdLicenseObserver.getInstance().licensee;
    }

    static {
        namedUsers = -1;
        recalculationRequested = false;
        resetCount = 0;
        licenseErrorNotificationGenerator = new HdLicenseErrorNotificationGenerator();
        lastRecalculationRequested = 0L;
    }
}

