/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.SwingClientQuickTicketResultSetGenerator;
import com.inet.helpdesk.core.ticketmanager.TicketManipulatorBackdoor;
import com.inet.helpdesk.core.utils.DatabaseTransactionUtils;
import com.inet.helpdesk.ticketmanager.adapt.UpdateCategoryResultSet;
import com.inet.helpdesk.ticketmanager.adapt.UpdateTicketResultSet;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.jj.srv.JavaCommand;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.annotation.SuppressFBWarnings;
import srv.UserNameMappingResultSet;

public class DatabaseCommand
extends JavaCommand {
    public static final int UPDATE_COMMAND = 1;
    public static final int SELECT_COMMAND = 2;
    public static final int DELETE_COMMAND = 3;
    private int typ;
    private int rsTyp;
    private int rsConc;
    private PreparedStatement pst;
    private Connection con;
    private String sql;
    private int ticketIdParameter;
    private int userIdParameter;
    private int quiIdParameter;
    private boolean updateTicketText;

    public DatabaseCommand(Connection con, int executeTyp, int rsType, int rsConcur) {
        this.rsTyp = rsType;
        this.rsConc = rsConcur;
        this.typ = executeTyp;
        this.con = con;
    }

    public DatabaseCommand(Connection con, int executeTyp) {
        this(con, executeTyp, -1, -1);
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="this methode should set a statement value")
    public void setString(int pos, String value) throws SQLException {
        if (pos == 1) {
            this.sql = this.typ == 2 ? "SELECT " + value : (this.typ == 3 ? "DELETE " + value : "UPDATE " + value);
            if (this.sql.equalsIgnoreCase("SELECT * from tblUser WHERE UsrId = ?")) {
                this.sql = "SELECT tblUser.*, tblUser.UsrId as UserID FROM tblUser WHERE tblUser.UsrId = ?";
            }
            this.pst = this.rsTyp != -1 ? this.con.prepareStatement(this.sql, this.rsTyp, this.rsConc) : this.con.prepareStatement(this.sql);
            HDLogger.debug("[Swing] prepare statement for: " + this.sql);
        } else {
            if (pos == 2) {
                throw new IllegalArgumentException("must be the ticketId!");
            }
            if (pos == 3) {
                throw new IllegalArgumentException("must be the userId!");
            }
            this.pst.setString(this.shiftIndex(pos), value);
        }
    }

    public void setString(int pos, Object value) throws SQLException {
        this.pst.setString(this.shiftIndex(pos), value != null ? value.toString() : null);
    }

    public void setBigDecimal(int pos, BigDecimal value) throws SQLException {
        this.pst.setBigDecimal(this.shiftIndex(pos), value);
    }

    public void setByte(int pos, byte value) throws SQLException {
        this.pst.setByte(this.shiftIndex(pos), value);
    }

    public void setLong(int pos, long value) throws SQLException {
        this.pst.setLong(this.shiftIndex(pos), value);
    }

    public void setInt(int pos, int value) throws SQLException {
        if (pos == 2) {
            this.ticketIdParameter = value;
            return;
        }
        if (pos == 3) {
            this.userIdParameter = value;
            return;
        }
        if (pos == 4) {
            this.quiIdParameter = value;
        }
        this.pst.setInt(this.shiftIndex(pos), value);
    }

    private int shiftIndex(int pos) {
        if (this.typ != 1) {
            return pos - 3;
        }
        return pos - 4;
    }

    public void setDouble(int pos, double value) throws SQLException {
        int index = this.shiftIndex(pos);
        if (index > 0) {
            this.pst.setDouble(index, value);
        }
    }

    public void setObject(int pos, Object value) throws SQLException {
        int index = this.shiftIndex(pos);
        if (index > 0) {
            this.pst.setObject(index, value);
        }
    }

    public void setTimestamp(int pos, Timestamp value) throws SQLException {
        int index = this.shiftIndex(pos);
        if (index > 0) {
            this.pst.setTimestamp(index, value);
        }
    }

    public void setDate(int pos, Date value) throws SQLException {
        int index = this.shiftIndex(pos);
        if (index > 0) {
            this.pst.setDate(index, value);
        }
    }

    public void setBoolean(int pos, boolean value) throws SQLException {
        if (pos == 4) {
            this.updateTicketText = value;
            return;
        }
        int index = this.shiftIndex(pos);
        if (index > 0) {
            this.pst.setBoolean(index, value);
        }
    }

    public ResultSet executeQuery() throws SQLException {
        try {
            if (this.sql.equals("SELECT * FROM tblQuickTicket WHERE QuiID = ?")) {
                return ((SwingClientQuickTicketResultSetGenerator)ServerPluginManager.getInstance().getSingleInstance(SwingClientQuickTicketResultSetGenerator.class)).getQuickTicketById(this.quiIdParameter);
            }
            ResultSet rs = DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> {
                if (this.sql.contains("UsrId as UserID")) {
                    return new UserNameMappingResultSet(this.pst.executeQuery(), "UserID");
                }
                return this.pst.executeQuery();
            });
            if (this.sql.toLowerCase().contains("tblauftraege") || this.sql.toLowerCase().contains("tblbuendel")) {
                return new UpdateTicketResultSet(rs, this.ticketIdParameter);
            }
            if (this.sql.toLowerCase().contains("tblbetreffs")) {
                return new UpdateCategoryResultSet(rs);
            }
            return rs;
        }
        catch (SQLException er) {
            HDLogger.debug(this.sql);
            throw er;
        }
    }

    public boolean execute() throws SQLException {
        if (this.pst == null) {
            throw new IllegalStateException("!!");
        }
        if (this.ticketIdParameter <= 0) {
            if (this.sqlSeemsToUpdateTicket()) {
                throw new IllegalArgumentException("Must provide a ticketid when updating a ticket! Like this: pst.setInt( UpdateCommandConstants.META_UPDATE_PARAMETER_TICKETID, ticketId );");
            }
            try {
                return DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> this.pst.execute());
            }
            catch (SQLException er) {
                HDLogger.debug(this.sql);
                throw er;
            }
        }
        try (UserAccountScope scope = UserAccountScope.create((GUID)HDUsersAndGroups.getUserAccount(this.userIdParameter).getID());){
            boolean bl = TicketManipulatorBackdoor.getBackdoor().updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(this.ticketIdParameter, this.updateTicketText, () -> {
                try {
                    return DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> this.pst.execute());
                }
                catch (SQLException er) {
                    HDLogger.debug(this.sql);
                    throw er;
                }
            });
            return bl;
        }
    }

    private boolean sqlSeemsToUpdateTicket() {
        String lowerCase = this.sql.toLowerCase();
        return lowerCase.contains("aufid =") || lowerCase.contains("bunid =") || lowerCase.contains("aufid=") || lowerCase.contains("bunid=");
    }

    public int executeUpdate() throws SQLException {
        if (this.ticketIdParameter <= 0) {
            if (this.sqlSeemsToUpdateTicket()) {
                throw new IllegalArgumentException("Must provide a ticketid when updating a ticket! Like this: pst.setInt( UpdateCommandConstants.META_UPDATE_PARAMETER_TICKETID, ticketId );");
            }
            try {
                return DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> this.pst.executeUpdate());
            }
            catch (SQLException er) {
                HDLogger.debug(this.sql);
                throw er;
            }
        }
        try (UserAccountScope scope = UserAccountScope.create((GUID)HDUsersAndGroups.getUserAccount(this.userIdParameter).getID());){
            int n = TicketManipulatorBackdoor.getBackdoor().updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(this.ticketIdParameter, this.updateTicketText, () -> {
                try {
                    return this.pst.executeUpdate();
                }
                catch (SQLException er) {
                    HDLogger.debug(this.sql);
                    throw er;
                }
            });
            return n;
        }
    }

    public void close() throws SQLException {
        if (this.pst != null) {
            this.pst.close();
        }
    }
}

