/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.ticket;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.webapi.HelpDeskTicketWebAPIExtension;
import com.inet.helpdesk.webapi.data.HelpDeskTicketIdResponseData;
import com.inet.helpdesk.webapi.ticket.HelpDeskTicketActionApplyHandler;
import com.inet.helpdesk.webapi.ticket.HelpDeskTicketActionListHandler;
import com.inet.helpdesk.webapi.ticket.step.HelpDeskTicketStepsHandler;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIHelper;
import com.inet.http.ClientMessageException;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.GenericInfoHandler;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@InternalApi
public class HelpDeskTicketIdHandler
extends GenericInfoHandler<Integer, TicketVO> {
    public HelpDeskTicketIdHandler() {
        super(new String[]{"ticketId"});
        this.registerRequestHandler((RequestHandlerBase)new HelpDeskTicketActionApplyHandler());
        this.registerRequestHandler((RequestHandlerBase)new HelpDeskTicketStepsHandler());
        this.registerRequestHandler((RequestHandlerBase)new HelpDeskTicketActionListHandler());
    }

    public Integer typeFor(String token) {
        boolean requiresEncodedToken = HelpDeskWebAPIHelper.requestRequiresEncodedTicketId();
        int ticketID = Tickets.decodeTicketID(token, requiresEncodedToken);
        if (ticketID == -1) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.notATicketId", new Object[]{token}));
        }
        return ticketID;
    }

    public String getHelpPageKey() {
        return "webapi.ticket.id";
    }

    public TicketVO handle(HttpServletRequest request, HttpServletResponse response, Integer ticketId, List<String> pathTokens, boolean previewModeEnabled) throws IOException {
        HelpDeskWebAPIHelper.checkTicketReadAccessOrThrow(ticketId, response);
        TicketVO ticket = TicketManager.getReader().getTicket(ticketId);
        if (ticket == null) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.notATicket", new Object[0]));
        }
        List<String> requestedFields = HelpDeskWebAPIHelper.getRequestedFields(request, fields -> {
            fields.addAll(ticket.getIncludedAttributes().parallelStream().map(a -> a.getKey()).collect(Collectors.toList()));
            fields.addAll(ticket.getIncludedFields().parallelStream().map(a -> a.getKey()).collect(Collectors.toList()));
        });
        ResponseWriter.json((HttpServletResponse)response, (Object)HelpDeskTicketIdResponseData.from(ticket, requestedFields));
        return ticket;
    }
}

