/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.ticket;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.webapi.HelpDeskTicketWebAPIExtension;
import com.inet.helpdesk.webapi.data.HelpDeskTicketCreateRequestData;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIHelper;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@InternalApi
public class HelpDeskTicketCreateHandler
extends RequestHandler<Void, Integer> {
    public static final String CREATE_REQUEST_HANDLER_NAME = "create";

    public HelpDeskTicketCreateHandler() {
        super(new String[]{CREATE_REQUEST_HANDLER_NAME});
    }

    public String getHelpPageKey() {
        return "webapi.ticket.create";
    }

    public Integer handle(HttpServletRequest request, HttpServletResponse response, Void genericObject, boolean previewModeEnabled) throws IOException {
        HelpDeskTicketCreateRequestData requestData = (HelpDeskTicketCreateRequestData)this.jsonFromRequest(request, HelpDeskTicketCreateRequestData.class);
        MutableTicketData mutableTicketData = HelpDeskWebAPIHelper.createMutableTicketData(requestData.getFields());
        ExtensionArguments extensionArguments = HelpDeskWebAPIHelper.createExtensionArguments(requestData.getExtensionArguments());
        HelpDeskWebAPIHelper.addAttachmentsToExtensionArguments(extensionArguments, request, requestData.getAttachments());
        String emailEingang = null;
        ReaStepTextVO ticketText = ReaStepTextVO.of(requestData.getText(), requestData.isHtmlContent());
        GUID ownerGUID = requestData.getOwnerGUID();
        UserManager userManager = UserManager.getInstance();
        UserAccount currentUserAccount = userManager.getCurrentUserAccount();
        if (ownerGUID == null && currentUserAccount != null && !currentUserAccount.getID().equals((Object)UserManager.PRIVILEGED_ACCOUNT_ID)) {
            ownerGUID = currentUserAccount.getID();
        } else if (ownerGUID != null && !HDUsersAndGroups.isSupporter(currentUserAccount)) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.step.apply.ownerGUIDMustNotBeGiven", new Object[0]));
        }
        mutableTicketData.put(Tickets.FIELD_OWNER_GUID, ownerGUID);
        TicketVO ticketVO = TicketManager.getManipulator().createTicket(ticketText, mutableTicketData, emailEingang, extensionArguments);
        if (ticketVO == null) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.errorWhileCreatingTicket", new Object[0]));
        }
        Integer ticketID = ticketVO.getID();
        boolean requiresTicketIdEncoded = HelpDeskWebAPIHelper.requestRequiresEncodedTicketId();
        ResponseWriter.json((HttpServletResponse)response, (Object)(requiresTicketIdEncoded ? Tickets.encodeTicketId(ticketID) : ticketID));
        return ticketID;
    }
}

