/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.ticket;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIHelper;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HelpDeskTicketActionListHandler
extends RequestHandler<Integer, Map<Integer, String>> {
    public static final String ACTIONS_REQUEST_HANDLER_NAME = "actions";

    public HelpDeskTicketActionListHandler() {
        super(new String[]{ACTIONS_REQUEST_HANDLER_NAME});
    }

    public String getHelpPageKey() {
        return "webapi.ticket.id.actions";
    }

    public Map<Integer, String> handle(HttpServletRequest request, HttpServletResponse response, Integer ticketId, boolean previewModeEnabled) throws IOException {
        HelpDeskWebAPIHelper.checkTicketReadAccessOrThrow(ticketId, response);
        List<ActionVO> allPossibleActionsForTicket = TicketManager.getTicketActionChecker().getAllPossibleActionsForTicket(ticketId);
        Map<Integer, String> responseObject = allPossibleActionsForTicket.stream().collect(Collectors.groupingBy(e -> e.getId())).entrySet().stream().map(e -> (ActionVO)((List)e.getValue()).get(0)).collect(Collectors.toMap(FieldVO::getId, ActionVO::getDisplayValue));
        ResponseWriter.json((HttpServletResponse)response, responseObject);
        return responseObject;
    }
}

