/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.ticket;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.webapi.HelpDeskTicketWebAPIExtension;
import com.inet.helpdesk.webapi.data.HelpDeskTicketApplyActionRequestData;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIHelper;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@InternalApi
public class HelpDeskTicketActionApplyHandler
extends RequestHandler<Integer, ReaStepVO> {
    public static final String APPLY_REQUEST_HANDLER_NAME = "apply";

    public HelpDeskTicketActionApplyHandler() {
        super(new String[]{APPLY_REQUEST_HANDLER_NAME});
    }

    public String getHelpPageKey() {
        return "webapi.ticket.id.apply";
    }

    public ReaStepVO handle(HttpServletRequest request, HttpServletResponse response, Integer ticketId, boolean previewModeEnabled) throws IOException {
        HelpDeskWebAPIHelper.checkTicketWriteAccessOrThrow(ticketId, response);
        TicketVO ticket = TicketManager.getReader().getTicket(ticketId);
        if (ticket == null) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.notATicket", new Object[0]));
        }
        HelpDeskTicketApplyActionRequestData requestData = (HelpDeskTicketApplyActionRequestData)this.jsonFromRequest(request, HelpDeskTicketApplyActionRequestData.class);
        UserManager userManager = UserManager.getInstance();
        UserAccount currentUserAccount = userManager.getCurrentUserAccount();
        if (currentUserAccount == null) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.step.apply.noUserLoggedIn", new Object[0]));
        }
        if (currentUserAccount.getID().equals((Object)UserManager.PRIVILEGED_ACCOUNT_ID)) {
            GUID userGUID = requestData.getUserGUID();
            if (userGUID != null && userManager.getUserAccount(userGUID) != null) {
                try (UserAccountScope scope = UserAccountScope.create((GUID)userGUID);){
                    ReaStepVO reaStepVO = this.createReaStepInUserAccountScope(request, response, ticket, requestData);
                    return reaStepVO;
                }
            }
        } else if (requestData.getUserGUID() != null) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.step.apply.userGUIDMustNotBeGiven", new Object[0]));
        }
        return this.createReaStepInUserAccountScope(request, response, ticket, requestData);
    }

    private ReaStepVO createReaStepInUserAccountScope(HttpServletRequest request, HttpServletResponse response, TicketVO ticket, HelpDeskTicketApplyActionRequestData requestData) throws IOException {
        MutableReaStepData reaStepData = HelpDeskWebAPIHelper.createMutableReaStepData(requestData.getFields());
        ExtensionArguments extensionArgs = HelpDeskWebAPIHelper.createExtensionArguments(requestData.getExtensionArguments());
        HelpDeskWebAPIHelper.addAttachmentsToExtensionArguments(extensionArgs, request, requestData.getAttachments());
        ActionVO action = (ActionVO)ActionManager.getInstance().get(requestData.getActionId());
        if (action == null) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.step.apply.actionNotFound", new Object[0]));
        }
        ReaStepTextVO reastepText = ReaStepTextVO.of(requestData.getText(), requestData.isHtmlContent());
        int reaStep = TicketManager.getManipulator().applyAction(ticket.getID(), reaStepData, reastepText, action, extensionArgs);
        ResponseWriter.json((HttpServletResponse)response, (Object)reaStep);
        return TicketManager.getReader().getReaStep(reaStep);
    }
}

