/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.user.fields;

import com.inet.helpdesk.shared.communication.LocationDataAccess;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.usersandgroups.api.BasicFieldValidation;
import com.inet.usersandgroups.api.UserField;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class FieldLocationID
extends UserField<Integer> {
    public static final String KEY = "location";

    public FieldLocationID() {
        super(FieldLocationID.createSearchTag(), (Object)0);
    }

    public void setDefaultValue(@Nonnull Integer value) {
        this.validate(value);
        super.setDefaultValue((Object)value);
    }

    private static SearchTag createSearchTag() {
        return new SearchTag(KEY, SearchDataType.IntegerMap, false, 900, KEY, true){

            public String getDisplayName() {
                return HDFieldDisplayNameProvider.getDisplayNameForCustomField(HDUsersAndGroups.FIELD_LOCATION_ID);
            }

            public Map<Integer, String> getMapData() {
                LocationDataAccess locationDataAccess = (LocationDataAccess)ServerPluginManager.getInstance().getSingleInstance(LocationDataAccess.class);
                try {
                    return locationDataAccess.getAllDisplayNames(false);
                }
                catch (IOException e) {
                    return new HashMap<Integer, String>();
                }
            }
        };
    }

    public void validate(Integer value) {
        super.validate((Object)value);
        BasicFieldValidation.throwIfNull((Object)value);
        BasicFieldValidation.throwIfNegative((int)value);
    }
}

