/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.user.fields;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.http.servlet.ClientLocale;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.search.tokenizers.TextSearchTokenizer;
import com.inet.usersandgroups.api.BasicFieldValidation;
import com.inet.usersandgroups.api.UserField;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

public class FieldLanguage
extends UserField<String> {
    public static final String KEY = "language";
    public static final String DEFAULT_VALUE = "xx";
    private static final String SQL_LANGUAGES = "SELECT * FROM tblSprachen";

    public FieldLanguage() {
        super(FieldLanguage.createSearchTag(), (Object)DEFAULT_VALUE);
    }

    private static SearchTag createSearchTag() {
        return new SearchTag(KEY, SearchDataType.StringMap, false, (SearchTokenizer)TextSearchTokenizer.DEFAULT, 100, KEY, false){
            private Map<String, String> mapData = null;

            public String getDisplayName() {
                return HDFieldDisplayNameProvider.getDisplayNameForField(FieldLanguage.KEY);
            }

            @Nonnull
            public Map<String, String> getMapData() {
                if (this.mapData == null) {
                    ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                    HashMap<String, String> langMap = FieldLanguage.loadLanguagesFromDatabase(connectionFactory);
                    this.mapData = langMap;
                }
                return this.mapData;
            }
        };
    }

    private static HashMap<String, String> loadLanguagesFromDatabase(ConnectionFactory connectionFactory) {
        HashMap<String, String> languages = new HashMap<String, String>();
        try (Connection con = connectionFactory.getConnection();
             Statement st = con.createStatement();
             ResultSet rs = st.executeQuery(SQL_LANGUAGES);){
            while (rs.next()) {
                String displayName;
                String sprache = rs.getString("Sprache");
                String sprID = rs.getString("SprID");
                if (!sprID.equalsIgnoreCase(displayName = new Locale(sprID).getDisplayName(ClientLocale.getThreadLocale()))) {
                    sprache = displayName;
                }
                languages.put(sprID, sprache);
            }
        }
        catch (Exception ex) {
            HDLogger.error(ex);
        }
        return languages;
    }

    public void validate(String value) {
        super.validate((Object)value);
        BasicFieldValidation.throwIfNull((Object)value);
        BasicFieldValidation.throwIfLengthExceedsLimit((String)value, (int)2);
    }
}

